/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.outcome;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.util.Preconditions;
import java.util.Collections;
import java.util.Optional;

public class MagicCommandOutput
implements MagicCommandOutcomeItem {
    private Optional<MIMEContainer> mineContainer;
    private MagicCommandOutcomeItem.Status status;
    private TryResult result;
    private EvaluationObject seo;
    private MessageCreatorService messageCreatorService;

    private MagicCommandOutput(MagicCommandOutcomeItem.Status status, Optional<MIMEContainer> mineContainer, TryResult result, EvaluationObject seo, MessageCreatorService messageCreatorService) {
        this.mineContainer = mineContainer;
        this.status = Preconditions.checkNotNull(status);
        this.result = result;
        this.seo = seo;
        this.messageCreatorService = messageCreatorService;
    }

    public MagicCommandOutput(MagicCommandOutcomeItem.Status status, MessageCreatorService messageCreatorService) {
        this(status, Optional.empty(), null, null, messageCreatorService);
    }

    public MagicCommandOutput(MagicCommandOutcomeItem.Status status, String text, MessageCreatorService messageCreatorService) {
        this(status, Optional.of(MIMEContainer.Text(Preconditions.checkNotNull(text).concat("\n"))), null, null, messageCreatorService);
    }

    public MagicCommandOutput(MagicCommandOutcomeItem.Status status, String text, TryResult result, EvaluationObject seo, MessageCreatorService messageCreatorService) {
        this(status, Optional.of(MIMEContainer.Text(Preconditions.checkNotNull(text).concat("\n"))), result, seo, messageCreatorService);
    }

    @Override
    public Optional<MIMEContainer> getMIMEContainer() {
        return this.mineContainer;
    }

    @Override
    public MagicCommandOutcomeItem.Status getStatus() {
        return this.status;
    }

    @Override
    public TryResult getResult() {
        return this.result;
    }

    @Override
    public EvaluationObject getSimpleEvaluationObject() {
        return this.seo;
    }

    @Override
    public void sendRepliesWithStatus(KernelFunctionality kernel, Message message, int executionCount) {
        if (this.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
            if (this.getMIMEContainer().isPresent()) {
                kernel.publish(Collections.singletonList(this.messageCreatorService.buildOutputMessage(message, (String)this.getMIMEContainer().get().getData(), false)));
            }
            kernel.send(this.messageCreatorService.buildReplyWithOkStatus(message, executionCount));
        } else {
            kernel.publish(Collections.singletonList(this.messageCreatorService.buildOutputMessage(message, (String)this.getMIMEContainer().get().getData(), true)));
            kernel.send(this.messageCreatorService.buildReplyWithErrorStatus(message, executionCount));
        }
    }

    @Override
    public void sendMagicCommandOutcome(KernelFunctionality kernel, Message message, int executionCount) {
        if (this.getMIMEContainer().isPresent()) {
            boolean hasError = this.getStatus().equals((Object)MagicCommandOutcomeItem.Status.ERROR);
            kernel.publish(Collections.singletonList(this.messageCreatorService.buildOutputMessage(message, (String)this.getMIMEContainer().get().getData(), hasError)));
        }
    }
}

