/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.util;

public class Preconditions {
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String message) {
        if (reference == null) {
            throw new NullPointerException(message);
        }
        return reference;
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static String checkNotEmpty(String text) {
        return Preconditions.checkNotEmpty(text, "");
    }

    public static String checkNotEmpty(String text, String errorMessage) {
        if (text == null || text.isEmpty()) {
            throw new IllegalStateException(errorMessage);
        }
        return text;
    }
}

