/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.msg;

import com.twosigma.beakerx.MIMEContainerFactory;
import com.twosigma.beakerx.jvm.object.ConsoleOutput;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.jvm.object.EvaluationStatus;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.SocketEnum;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.kernel.msg.MessageHolder;
import com.twosigma.beakerx.kernel.msg.TracebackPrinter;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCreator
implements MessageCreatorService {
    private static MessageCreatorService messageCreator = new MessageCreator();
    public static final String EXECUTION_STATE = "execution_state";
    public static final String BUSY = "busy";
    public static final String IDLE = "idle";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String NULL_RESULT = "null";
    public static final String ERROR_MESSAGE = "text";
    public static final String TEXT = "text";
    public static final String NAME = "name";
    public static final String STDERR = "stderr";
    public static final String STDOUT = "stdout";
    public static Logger logger = LoggerFactory.getLogger(MessageCreator.class);

    private MessageCreator() {
    }

    public static MessageCreatorService get() {
        return messageCreator;
    }

    private static Message initMessage(JupyterMessages type, Message message) {
        Message reply = new Message(new Header(type, message.getHeader().getSession()));
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        return reply;
    }

    public static Message buildMessage(Message message, List<MIMEContainer> mimes, int executionCount) {
        Message reply = MessageCreator.initMessage(JupyterMessages.EXECUTE_RESULT, message);
        reply.setContent(new HashMap());
        reply.getContent().put("execution_count", executionCount);
        HashMap map3 = new HashMap();
        mimes.forEach(mimeItem -> map3.put(mimeItem.getMime().asString(), mimeItem.getData()));
        reply.getContent().put("data", map3);
        reply.getContent().put("metadata", new HashMap());
        return reply;
    }

    private static Message buildMessage(Message message, List<MIMEContainer> mimes, String outputdataResult, int executionCount) {
        if (!outputdataResult.isEmpty()) {
            List<MIMEContainer> collect = mimes.stream().map(x -> new MIMEContainer(x.getMime().asString(), (Object)(x.getData() + outputdataResult))).collect(Collectors.toList());
            return MessageCreator.buildMessage(message, collect, executionCount);
        }
        return MessageCreator.buildMessage(message, mimes, executionCount);
    }

    public static Message buildClearOutput(Message message, boolean wait) {
        Message reply = MessageCreator.initMessage(JupyterMessages.CLEAR_OUTPUT, message);
        reply.setContent(new HashMap());
        reply.getContent().put("wait", wait);
        reply.getContent().put("metadata", new HashMap());
        return reply;
    }

    public static Message buildDisplayData(Message message, List<MIMEContainer> mimes) {
        Message reply = MessageCreator.initMessage(JupyterMessages.DISPLAY_DATA, message);
        reply.setContent(new HashMap());
        reply.getContent().put("metadata", new HashMap());
        HashMap map3 = new HashMap();
        mimes.forEach(mimeItem -> map3.put(mimeItem.getMime().asString(), mimeItem.getData()));
        reply.getContent().put("data", map3);
        return reply;
    }

    private static Message buildReply(Message message, EvaluationObject seo) {
        Message reply = MessageCreator.buildReplyWithoutStatus(message, seo.getExecutionCount());
        if (EvaluationStatus.FINISHED == seo.getStatus()) {
            reply.getMetadata().put("status", "ok");
            reply.getContent().put("status", "ok");
            reply.getContent().put("user_expressions", new HashMap());
        } else if (EvaluationStatus.ERROR == seo.getStatus()) {
            reply.getMetadata().put("status", "error");
            reply.getContent().put("status", "error");
        }
        return reply;
    }

    public static Message buildAbortedReply(Message message) {
        Message abortedReply = MessageCreator.initMessage(JupyterMessages.EXECUTE_REPLY, message);
        Hashtable<String, String> content = new Hashtable<String, String>(1);
        content.put("status", "aborted");
        abortedReply.setContent(content);
        return abortedReply;
    }

    public static Message buildReplyWithoutStatus(Message message, int executionCount) {
        Message reply = MessageCreator.initMessage(JupyterMessages.EXECUTE_REPLY, message);
        Hashtable<String, Object> map6 = new Hashtable<String, Object>(3);
        map6.put("dependencies_met", true);
        map6.put("started", Utils.timestamp());
        reply.setMetadata(map6);
        Hashtable<String, Integer> map7 = new Hashtable<String, Integer>(1);
        map7.put("execution_count", executionCount);
        reply.setContent(map7);
        return reply;
    }

    public Message buildReplyWithOkStatus(Message message, int executionCount) {
        Message messageWithStatus = MessageCreator.buildReplyWithoutStatus(message, executionCount);
        messageWithStatus.getContent().put("status", "ok");
        return messageWithStatus;
    }

    public Message buildReplyWithErrorStatus(Message message, int executionCount) {
        Message messageWithStatus = MessageCreator.buildReplyWithoutStatus(message, executionCount);
        messageWithStatus.getContent().put("status", "error");
        return messageWithStatus;
    }

    public Message buildOutputMessage(Message message, String text, boolean hasError) {
        Message reply = MessageCreator.initMessage(JupyterMessages.STREAM, message);
        reply.setContent(new HashMap());
        reply.getContent().put(NAME, hasError ? STDERR : STDOUT);
        reply.getContent().put("text", text);
        logger.debug("Console output:", (Object)("Error: " + hasError), (Object)text);
        return reply;
    }

    public List<MessageHolder> createMessage(EvaluationObject seo) {
        logger.debug("Creating message response message from: " + seo);
        Message message = seo.getJupyterMessage();
        ArrayList<MessageHolder> ret = new ArrayList<MessageHolder>();
        if (MessageCreator.isConsoleOutputMessage(seo)) {
            ret.addAll(this.createConsoleResult(seo, message));
        } else if (MessageCreator.isError(seo.getStatus())) {
            ret.addAll(MessageCreator.createError(seo, message));
        } else if (MessageCreator.isFinish(seo.getStatus()) && seo.isShowResult()) {
            ret.addAll(MessageCreator.createFinish(seo, message));
        } else {
            logger.debug("Unhandled status of SimpleEvaluationObject : " + seo.getStatus());
        }
        return ret;
    }

    private static List<MessageHolder> createFinish(EvaluationObject seo, Message message) {
        ArrayList<MessageHolder> ret = new ArrayList<MessageHolder>();
        MessageHolder mh = MessageCreator.createFinishResult(seo, message);
        if (mh != null) {
            ret.add(mh);
        }
        ret.add(new MessageHolder(SocketEnum.SHELL_SOCKET, MessageCreator.buildReply(message, seo)));
        return ret;
    }

    private static boolean isFinish(EvaluationStatus status) {
        return EvaluationStatus.FINISHED == status;
    }

    private static List<MessageHolder> createError(EvaluationObject seo, Message message) {
        ArrayList<MessageHolder> ret = new ArrayList<MessageHolder>();
        ret.add(MessageCreator.createErrorResult(seo, message));
        ret.add(new MessageHolder(SocketEnum.SHELL_SOCKET, MessageCreator.buildReply(message, seo)));
        return ret;
    }

    private static boolean isError(EvaluationStatus status) {
        return EvaluationStatus.ERROR == status;
    }

    private static boolean isConsoleOutputMessage(EvaluationObject seo) {
        return seo.getConsoleOutput() != null && !seo.getConsoleOutput().isEmpty();
    }

    private List<MessageHolder> createConsoleResult(EvaluationObject seo, Message message) {
        ArrayList<MessageHolder> result = new ArrayList<MessageHolder>();
        while (!seo.getConsoleOutput().isEmpty()) {
            ConsoleOutput co = (ConsoleOutput)seo.getConsoleOutput().poll();
            result.add(new MessageHolder(SocketEnum.IOPUB_SOCKET, this.buildOutputMessage(message, co.getText(), co.isError())));
        }
        return result;
    }

    private static MessageHolder createErrorResult(EvaluationObject seo, Message message) {
        String[] temp;
        String[] errorMessage = seo.getPayload().toString().split("\n");
        if ((errorMessage = MessageCreator.clearText(errorMessage)) != null && errorMessage.length > 0) {
            logger.debug("Execution result ERROR: " + seo.getPayload().toString());
        }
        Message reply = MessageCreator.initMessage(JupyterMessages.ERROR, message);
        Hashtable<String, Object> map4 = new Hashtable<String, Object>(2);
        String ename = "";
        String evalue = "";
        if (errorMessage != null && errorMessage[0] != null && !errorMessage[0].isEmpty() && (temp = errorMessage[0].split(":")) != null) {
            if (temp.length == 1) {
                ename = temp[0];
                evalue = temp[0];
            } else if (temp.length > 1) {
                ename = temp[0];
                evalue = temp[1];
            }
        }
        map4.put("ename", ename);
        map4.put("evalue", evalue);
        map4.put("traceback", TracebackPrinter.print(errorMessage));
        map4.put("text", seo.getPayload().toString());
        reply.setContent(map4);
        return new MessageHolder(SocketEnum.IOPUB_SOCKET, reply);
    }

    private static String[] clearText(String[] input) {
        ArrayList<String> ret = new ArrayList<String>();
        if (input != null) {
            for (String line : input) {
                if (line == null) continue;
                if (line.endsWith("\r")) {
                    ret.add(line.substring(0, line.length() - 1));
                    continue;
                }
                ret.add(line);
            }
        }
        return (String[])ret.stream().toArray(String[]::new);
    }

    private static MessageHolder createFinishResult(EvaluationObject seo, Message message) {
        MessageHolder ret = null;
        List<MIMEContainer> mimes = MIMEContainerFactory.createMIMEContainers(seo.getPayload());
        if (!mimes.contains(MIMEContainer.HIDDEN)) {
            ret = new MessageHolder(SocketEnum.IOPUB_SOCKET, MessageCreator.buildMessage(message, mimes, MessageCreator.outputdataResult(seo.getOutputdata()), seo.getExecutionCount()));
        }
        return ret;
    }

    private static String outputdataResult(List<Object> outputdata) {
        Object result = "";
        for (Object o : outputdata) {
            if (o instanceof SimpleEvaluationObject.EvaluationStdOutput) {
                result = (String)result + "\n" + ((SimpleEvaluationObject.EvaluationStdOutput)o).payload;
                continue;
            }
            if (!(o instanceof SimpleEvaluationObject.EvaluationStdError)) continue;
            result = (String)result + "\n" + ((SimpleEvaluationObject.EvaluationStdError)o).payload;
        }
        return result;
    }

    private static boolean showResult(EvaluationObject seo) {
        boolean ret = true;
        if (seo != null && seo.getPayload() != null && seo.getPayload() instanceof MIMEContainer) {
            MIMEContainer input = (MIMEContainer)seo.getPayload();
            ret = !"x-beakerx/empty".equals(input.getMime().asString());
        } else if (seo != null && !seo.getOutputdata().isEmpty()) {
            ret = true;
        }
        return ret;
    }

    public Message createBusyMessage(Message parentMessage) {
        return MessageCreator.getExecutionStateMessage(parentMessage, BUSY);
    }

    public Message createIdleMessage(Message parentMessage) {
        return MessageCreator.getExecutionStateMessage(parentMessage, IDLE);
    }

    private static Message getExecutionStateMessage(Message parentMessage, String state) {
        HashMap<String, String> map1 = new HashMap<String, String>(1);
        map1.put(EXECUTION_STATE, state);
        Message reply = MessageCreator.initMessage(JupyterMessages.STATUS, parentMessage);
        reply.setContent(map1);
        return reply;
    }
}

