/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.Display;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widget.MIMEDisplayMethodManager;
import com.twosigma.beakerx.widget.Output;
import com.twosigma.beakerx.widget.Widget;
import com.twosigma.beakerx.widget.WidgetDisplayMethodManager;
import java.util.List;

public final class OutputManager {
    private static OutputManager instance = new OutputManager(WidgetDisplayMethodManager.getInstance(), MIMEDisplayMethodManager.getInstance());
    private WidgetDisplayMethodManager widgetDisplayMethodManager;
    private MIMEDisplayMethodManager mimeDisplayMethodManager;
    private Output output;
    private Output stderr;
    private Output stdout;
    private Widget.WidgetDisplayMethodStrategy widgetDisplayMethodStrategy = new WidgetDisplayMethodStrategy();
    private Display.MIMEContainerDisplayMethodStrategy mimeContainerDisplayMethodStrategy = new MIMEContainerDisplayMethodStrategy();

    private OutputManager(WidgetDisplayMethodManager widgetDisplayMethodManager, MIMEDisplayMethodManager mimeDisplayMethodManager) {
        this.widgetDisplayMethodManager = widgetDisplayMethodManager;
        this.mimeDisplayMethodManager = mimeDisplayMethodManager;
    }

    public static Output setOutput(Output out) {
        OutputManager.instance.output = out;
        OutputManager.defineWidgetDisplayMethod();
        return OutputManager.instance.output;
    }

    public static Output setStandardError(Output out) {
        OutputManager.instance.stderr = out;
        return OutputManager.instance.stderr;
    }

    public static Output setStandardOutput(Output out) {
        OutputManager.instance.stdout = out;
        OutputManager.defineWidgetDisplayMethod();
        return OutputManager.instance.stdout;
    }

    public static void clearStderr() {
        if (OutputManager.instance.stderr != null) {
            OutputManager.instance.stderr.clearOutput();
        }
    }

    public static void clearStdout() {
        if (OutputManager.instance.stdout != null) {
            OutputManager.instance.stdout.clearOutput();
        }
    }

    public static void clearOutput() {
        if (OutputManager.instance.output != null) {
            OutputManager.instance.output.clearOutput();
        }
    }

    public static void clear() {
        OutputManager.clearOutput();
        OutputManager.clearStdout();
        OutputManager.clearStderr();
    }

    public static boolean sendStdout(String s) {
        if (OutputManager.instance.output != null || OutputManager.instance.stdout != null) {
            if (OutputManager.instance.output != null) {
                OutputManager.instance.output.sendStdout(s);
            }
            if (OutputManager.instance.stdout != null) {
                OutputManager.instance.stdout.sendStdout(s);
            }
            return true;
        }
        return false;
    }

    public static boolean sendStderr(String s) {
        if (OutputManager.instance.output != null || OutputManager.instance.stderr != null) {
            if (OutputManager.instance.output != null) {
                OutputManager.instance.output.sendStderr(s);
            }
            if (OutputManager.instance.stderr != null) {
                OutputManager.instance.stderr.sendStderr(s);
            }
            return true;
        }
        return false;
    }

    private static void defineWidgetDisplayMethod() {
        Output outputWidget = OutputManager.getOutput();
        if (outputWidget == null) {
            OutputManager.instance.widgetDisplayMethodManager.setDefaultDisplayMethod();
            OutputManager.instance.mimeDisplayMethodManager.setDefaultDisplayMethod();
        } else {
            OutputManager.instance.widgetDisplayMethodManager.defineDisplayMethod(OutputManager.instance.widgetDisplayMethodStrategy);
            OutputManager.instance.mimeDisplayMethodManager.defineDisplayMethod(OutputManager.instance.mimeContainerDisplayMethodStrategy);
        }
    }

    private static Output getOutput() {
        if (OutputManager.instance.output != null) {
            return OutputManager.instance.output;
        }
        if (OutputManager.instance.stdout != null) {
            return OutputManager.instance.stdout;
        }
        return null;
    }

    static class MIMEContainerDisplayMethodStrategy
    implements Display.MIMEContainerDisplayMethodStrategy {
        MIMEContainerDisplayMethodStrategy() {
        }

        @Override
        public void display(List<MIMEContainer> mimeContainers) {
            OutputManager.getOutput().display(mimeContainers);
        }
    }

    static class WidgetDisplayMethodStrategy
    implements Widget.WidgetDisplayMethodStrategy {
        WidgetDisplayMethodStrategy() {
        }

        @Override
        public void display(Widget widget) {
            OutputManager.getOutput().display(widget);
        }
    }
}

