/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.sql.BeakerInputVar;
import com.twosigma.beakerx.sql.BeakerParseResult;
import com.twosigma.beakerx.sql.ConnectionStringHolder;
import com.twosigma.beakerx.sql.DBConnectionException;
import com.twosigma.beakerx.sql.JDBCClient;
import com.twosigma.beakerx.sql.QueryParser;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class BeakerParser {
    public static final String DB_URI_VAR = "beakerDB";
    public static final String INPUTS_VAR = "inputs";
    public static final String OUTPUTS_VAR = "outputs";
    public static final String SQL_SELECT = "SELECT";
    public static final String SQL_FROM = "FROM";
    public static final String SQL_INTO = "INTO";
    public static final String VAR_VALUE_START = "${";
    public static final String VAR_VALUE_END = "}";
    public static final String NO_DATASOURCES_ERROR = "No datasource";
    protected final JDBCClient jdbcClient;
    private BeakerXClient client;
    private ConnectionStringHolder dbURI;
    private Map<String, String> inputs = new HashMap<String, String>();
    private Set<String> outputs = new HashSet<String>();
    private Map<String, ConnectionStringHolder> namedConnectionString;
    private ConnectionStringHolder defaultConnectionString;
    private List<BeakerParseResult> results = new ArrayList<BeakerParseResult>();

    public BeakerParser(String script, BeakerXClient client, ConnectionStringHolder defaultConnectionString, Map<String, ConnectionStringHolder> namedConnectionString, JDBCClient jdbcClient) throws IOException, DBConnectionException {
        this.client = client;
        this.jdbcClient = jdbcClient;
        this.defaultConnectionString = defaultConnectionString;
        this.namedConnectionString = namedConnectionString;
        this.parseVar(script);
        List<String> queries = QueryParser.split(script);
        if (queries != null && !queries.isEmpty()) {
            for (String query : queries) {
                BeakerParseResult result = new BeakerParseResult(query);
                this.parseSelectInto(result);
                this.parseInputParam(result);
                this.results.add(result);
            }
        }
    }

    private void parseInputParam(BeakerParseResult result) {
        Object sql = result.getResultQuery();
        String upper = ((String)sql).toUpperCase();
        int start = -1;
        int end = -1;
        do {
            if ((start = upper.indexOf(VAR_VALUE_START, end)) < 0) continue;
            end = upper.indexOf(VAR_VALUE_END, start);
            if (end < 0) break;
            String var = ((String)sql).substring(start + 2, end).trim();
            if (var == null || var.isEmpty()) continue;
            sql = ((String)sql).substring(0, start) + "?" + ((String)sql).substring(end + 1);
            upper = ((String)sql).toUpperCase();
            end = start + 1;
            BeakerInputVar inputVar = new BeakerInputVar(var);
            inputVar.setType(this.inputs.get(var));
            result.getInputVars().add(inputVar);
        } while (start >= 0);
        result.setResultQuery((String)sql);
    }

    private void parseSelectInto(BeakerParseResult result) {
        Object sql = result.getResultQuery();
        String upper = ((String)sql).toUpperCase();
        int select = -1;
        int from = -1;
        int into = -1;
        do {
            int end;
            int start;
            select = from;
            if ((select = upper.indexOf(SQL_SELECT, select)) < 0) continue;
            from = upper.indexOf(SQL_FROM, select);
            if (from < 0) break;
            into = upper.indexOf(SQL_INTO, select);
            if (into <= select || into >= from || (start = upper.indexOf(VAR_VALUE_START, into)) <= into || start >= from || (end = upper.indexOf(VAR_VALUE_END, into)) <= into || end >= from) continue;
            String var = ((String)sql).substring(start + 2, end);
            sql = ((String)sql).substring(0, into) + ((String)sql).substring(end + 1);
            upper = ((String)sql).toUpperCase();
            from = select;
            if (var == null || var.isEmpty()) continue;
            result.setSelectInto(true);
            result.setSelectIntoVar(var);
        } while (select >= 0);
        result.setResultQuery((String)sql);
    }

    private void parseVar(String script) throws IOException, DBConnectionException {
        ArrayList<String> vars = new ArrayList<String>();
        Scanner scanner = new Scanner(script);
        StringBuffer sb = new StringBuffer();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            line.trim();
            int commentIndex = line.indexOf("%%");
            if (commentIndex == -1 || !line.startsWith("%%")) continue;
            vars.add(line);
            if (line.indexOf(DB_URI_VAR) > 0) {
                String value = line.substring(line.indexOf(61) + 1).trim();
                int start = value.indexOf(VAR_VALUE_START);
                int end = value.indexOf(VAR_VALUE_END, start);
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    this.dbURI = new ConnectionStringHolder(value.substring(1, value.length() - 1), this.jdbcClient);
                    continue;
                }
                if (start >= 0 && end > 0) {
                    String var = value.substring(start + 2, end).trim();
                    this.dbURI = new ConnectionStringHolder(this.client.get(var).toString(), this.jdbcClient);
                    continue;
                }
                this.dbURI = this.namedConnectionString.get(value);
                if (this.dbURI != null) continue;
                throw new DBConnectionException(value, new SQLException("Named connection witn name " + value + " not found"));
            }
            if (line.indexOf(OUTPUTS_VAR) > 0) {
                String outLine = line.substring(line.indexOf(58) + 1).trim();
                for (String out : outLine.split(";")) {
                    this.outputs.add(out.trim());
                }
                continue;
            }
            if (line.indexOf(INPUTS_VAR) <= 0) continue;
            String inLine = line.substring(line.indexOf(58) + 1).trim();
            for (String in : inLine.split(";")) {
                int d = in.indexOf(47);
                if (d > 0) {
                    String var = in.substring(0, d).trim();
                    String type = in.substring(d + 1, in.length()).trim();
                    this.inputs.put(var, type);
                    continue;
                }
                this.inputs.put(in.trim(), null);
            }
        }
        if (this.dbURI == null) {
            if (this.defaultConnectionString == null) {
                throw new RuntimeException(NO_DATASOURCES_ERROR);
            }
            this.dbURI = this.defaultConnectionString;
        }
    }

    public ConnectionStringHolder getDbURI() {
        return this.dbURI;
    }

    public List<BeakerParseResult> getResults() {
        return this.results;
    }

    public void setResults(List<BeakerParseResult> results) {
        this.results = results;
    }

    public Map<String, String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, String> inputs) {
        this.inputs = inputs;
    }

    public Set<String> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Set<String> outputs) {
        this.outputs = outputs;
    }
}

