/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.autocomplete.db;

import com.twosigma.beakerx.sql.autocomplete.db.DbCache;
import com.twosigma.beakerx.sql.autocomplete.db.DbInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public abstract class DbExplorer
implements DbInfo {
    private DataSource ds;

    public DbExplorer(DataSource ds) {
        this.ds = ds;
    }

    private List<String> findTableNames(DbCache dbCache, Connection conn, String schemaName, String key) throws SQLException {
        List<String> ret = dbCache.getTableNames(conn, schemaName, key);
        if (ret != null) {
            return ret;
        }
        ret = this.queryTableNames(conn, schemaName, key);
        if (ret != null) {
            dbCache.putTableNames(conn, schemaName, key, ret);
            return ret;
        }
        return null;
    }

    @Override
    public List<String> getTableNames(DbCache dbCache, String schemaName, String key) {
        List<String> list;
        block9: {
            Connection conn = this.ds.getConnection();
            try {
                if (schemaName == null && (schemaName = conn.getSchema()) == null) {
                    schemaName = conn.getCatalog();
                }
                list = this.findTableNames(dbCache, conn, schemaName, key);
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            conn.close();
        }
        return list;
    }

    private List<String> findTableFieldNames(DbCache dbCache, Connection conn, String schemaName, String tableName, String key) throws SQLException {
        List<String> ret = dbCache.getTableFieldNames(conn, schemaName, tableName, key);
        if (ret != null) {
            return ret;
        }
        ret = this.queryFieldNames(conn, schemaName, tableName, key);
        if (ret != null) {
            dbCache.putTableFieldNames(conn, schemaName, tableName, key, ret);
            return ret;
        }
        return null;
    }

    @Override
    public List<String> getTableFieldNames(DbCache dbCache, String schemaName, String tableName, String key) {
        List<String> list;
        block9: {
            Connection conn = this.ds.getConnection();
            try {
                if (schemaName == null && (schemaName = conn.getSchema()) == null) {
                    schemaName = conn.getCatalog();
                }
                list = this.findTableFieldNames(dbCache, conn, schemaName, tableName, key);
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            conn.close();
        }
        return list;
    }

    public abstract List<String> queryTableNames(Connection var1, String var2, String var3) throws SQLException;

    public abstract List<String> queryFieldNames(Connection var1, String var2, String var3, String var4) throws SQLException;
}

