/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.evaluator;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.sql.ReadVariableException;
import com.twosigma.beakerx.sql.evaluator.SQLEvaluator;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SQLCodeRunner
implements Callable<TryResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)SQLCodeRunner.class.getName());
    private SQLEvaluator sqlEvaluator;
    private final EvaluationObject simpleEvaluationObject;
    private final BeakerXClient namespaceClient;

    SQLCodeRunner(SQLEvaluator sqlEvaluator, EvaluationObject seo, BeakerXClient namespaceClient) {
        this.sqlEvaluator = sqlEvaluator;
        this.simpleEvaluationObject = seo;
        this.namespaceClient = namespaceClient;
    }

    @Override
    public TryResult call() throws Exception {
        TryResult.CellError either;
        try {
            Object r = this.sqlEvaluator.executeQuery(this.simpleEvaluationObject.getExpression(), this.namespaceClient, this.sqlEvaluator.defaultConnectionString, this.sqlEvaluator.namedConnectionString);
            either = TryResult.createResult((Object)r);
        }
        catch (SQLException e) {
            either = TryResult.createError((String)this.createErrorMessage(e));
        }
        catch (ThreadDeath e) {
            either = TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
        }
        catch (ReadVariableException e) {
            either = TryResult.createError((String)e.getMessage());
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
            either = TryResult.createError((String)e.toString());
        }
        return this.sqlEvaluator.processResult((TryResult)either);
    }

    private String createErrorMessage(SQLException e) {
        Object err = e.toString();
        if (e.getCause() != null) {
            err = (String)err + ", " + e.getCause().toString();
        }
        return err;
    }
}

