/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.autocomplete;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.twosigma.beakerx.autocomplete.AutocompleteNode;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.client.fluent.Request;
import org.jetbrains.annotations.NotNull;

public class AutocompleteNodeHttpGet
extends AutocompleteNode {
    public static final String HTTPS_SEARCH_MAVEN_ORG_SOLRSEARCH_SELECT_Q_S_START_0_ROWS_20 = "https://search.maven.org/solrsearch/select?q=%s&start=0&rows=20";
    public static final String SPACE = "%20";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AutocompleteNodeHttpGet(String name, List<AutocompleteNode> children) {
        super(name, children);
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
    }

    public Optional<AutocompleteResult> findNextWord(String text, LinkedList<String> parts) {
        return Optional.empty();
    }

    public Optional<AutocompleteResult> matchToTheWord(String text, LinkedList<String> parts, String last) {
        try {
            Map result = this.getResult(parts, last);
            if (result.containsKey("response")) {
                Map responseFromSuggestion;
                Map fromSuggestion;
                Map response = (Map)result.get("response");
                if (response.containsKey("docs") && ((List)response.get("docs")).size() > 0) {
                    return this.createResult(text, parts, last, response);
                }
                Optional<String> suggestion = this.getSuggestion(result);
                if (suggestion.isPresent() && (fromSuggestion = this.getResult(new LinkedList<String>(), suggestion.get())).containsKey("response") && (responseFromSuggestion = (Map)fromSuggestion.get("response")).containsKey("docs") && ((List)responseFromSuggestion.get("docs")).size() > 0) {
                    return this.createResult(text, parts, last, responseFromSuggestion);
                }
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Optional<String> getSuggestion(Map result) {
        List suggestion;
        Map suggestionOption;
        List suggestions;
        Map spellcheck;
        if (result.containsKey("spellcheck") && (spellcheck = (Map)result.get("spellcheck")).containsKey("suggestions") && (suggestions = (List)spellcheck.get("suggestions")).size() > 1 && (suggestionOption = (Map)suggestions.get(1)).containsKey("suggestion") && (suggestion = (List)suggestionOption.get("suggestion")).size() > 0) {
            return Optional.of((String)suggestion.get(0));
        }
        return Optional.empty();
    }

    private Optional<AutocompleteResult> createResult(String text, LinkedList<String> parts, String last, Map response) {
        List docs = (List)response.get("docs");
        List collect = docs.stream().map(x -> {
            Map doc = (Map)x;
            return doc.get("g") + " " + doc.get("a") + " " + doc.get("latestVersion");
        }).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            return Optional.of(new AutocompleteResult(collect, text.length() - this.lengthOfCoordinates(parts, last)));
        }
        return Optional.empty();
    }

    private int lengthOfCoordinates(LinkedList<String> parts, String last) {
        return parts.stream().mapToInt(x -> x.length() + 1).sum() + last.length();
    }

    private Map getResult(LinkedList<String> parts, String last) throws IOException {
        String uri = this.getUrl(parts, last);
        String valueString = Request.Get((String)uri).execute().returnContent().asString();
        return this.fromJson(valueString);
    }

    private Map fromJson(String json) {
        try {
            return (Map)this.objectMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private String getUrl(LinkedList<String> parts, String last) {
        if (parts.size() == 2) {
            String encode = parts.get(0) + SPACE + parts.get(1) + SPACE + last;
            return String.format(HTTPS_SEARCH_MAVEN_ORG_SOLRSEARCH_SELECT_Q_S_START_0_ROWS_20, encode);
        }
        if (parts.size() == 1) {
            String encode = parts.get(0) + SPACE + last;
            return String.format(HTTPS_SEARCH_MAVEN_ORG_SOLRSEARCH_SELECT_Q_S_START_0_ROWS_20, encode);
        }
        if (parts.size() == 0) {
            String encode = last;
            return String.format(HTTPS_SEARCH_MAVEN_ORG_SOLRSEARCH_SELECT_Q_S_START_0_ROWS_20, encode);
        }
        return "";
    }
}

