/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Longs;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractLongAssert<S extends AbstractLongAssert<S>>
extends AbstractComparableAssert<S, Long>
implements NumberAssert<S, Long> {
    @VisibleForTesting
    Longs longs = Longs.instance();

    public AbstractLongAssert(Long actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualTo(long expected) {
        this.longs.assertEqual(this.info, this.actual, expected);
        return (S)((AbstractLongAssert)this.myself);
    }

    public S isNotEqualTo(long other) {
        this.longs.assertNotEqual(this.info, this.actual, other);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isZero() {
        this.longs.assertIsZero(this.info, (Number)this.actual);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNotZero() {
        this.longs.assertIsNotZero(this.info, (Number)this.actual);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isPositive() {
        this.longs.assertIsPositive(this.info, (Number)this.actual);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNegative() {
        this.longs.assertIsNegative(this.info, (Number)this.actual);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNotNegative() {
        this.longs.assertIsNotNegative(this.info, (Number)this.actual);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNotPositive() {
        this.longs.assertIsNotPositive(this.info, (Number)this.actual);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isLessThan(long other) {
        this.longs.assertLessThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(long other) {
        this.longs.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isGreaterThan(long other) {
        this.longs.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(long other) {
        this.longs.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isBetween(Long start, Long end) {
        this.longs.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isStrictlyBetween(Long start, Long end) {
        this.longs.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isCloseTo(long expected, Offset<Long> offset) {
        this.longs.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(long expected, Offset<Long> offset) {
        this.longs.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isCloseTo(Long expected, Offset<Long> offset) {
        this.longs.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(Long expected, Offset<Long> offset) {
        this.longs.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isCloseTo(Long expected, Percentage percentage) {
        this.longs.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(Long expected, Percentage percentage) {
        this.longs.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isCloseTo(long expected, Percentage percentage) {
        this.longs.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(long expected, Percentage percentage) {
        this.longs.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super Long> customComparator) {
        super.usingComparator(customComparator);
        this.longs = new Longs(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractLongAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.longs = Longs.instance();
        return (S)((AbstractLongAssert)this.myself);
    }
}

