"""
BeastX - Python Telegram Client Library
========================================

A powerful and feature-rich Python library for Telegram's MTProto API.

Credits:
    - Original Telethon library by Lonami: https://github.com/LonamiWebs/Telethon
    - BeastX Developer: t.me/GODMRUNAL
    - Channel: @BEASTX_BOTS
    - GitHub: github.com/beastx-python

Quick Start:
    >>> from beastx import TelegramClient, events
    >>> 
    >>> client = TelegramClient('session_name', api_id, api_hash)
    >>> 
    >>> @client.on(events.NewMessage(pattern='hello'))
    >>> async def handler(event):
    >>>     await event.respond('Hello from BeastX!')
    >>> 
    >>> client.start()
    >>> client.run_until_disconnected()

Installation:
    pip install beastx-python
"""

from .client.telegramclient import TelegramClient
from .network import connection
from .tl.custom import Button
from .tl import patched as _  # import for its side-effects
from . import version, events, utils, errors, types, functions, custom

__version__ = version.__version__
__author__ = 'GODMRUNAL (t.me/GODMRUNAL)'
__credits__ = 'Based on Telethon by Lonami - https://github.com/LonamiWebs/Telethon'
__license__ = 'MIT'
__github__ = 'https://github.com/beastx-python'
__channel__ = '@BEASTX_BOTS'

__all__ = [
    'TelegramClient', 'Button',
    'types', 'functions', 'custom', 'errors',
    'events', 'utils', 'connection'
]

import sys
from rich.console import Console
from rich.panel import Panel
from rich.text import Text

console = Console()

def _show_banner():
    """Display BeastX banner on import."""
    banner = Text()
    banner.append("BeastX ", style="bold cyan")
    banner.append(f"v{__version__}\n", style="bold green")
    banner.append("Telegram MTProto Client Library\n", style="dim")
    banner.append("\n", style="dim")
    banner.append("Developer: ", style="dim")
    banner.append("t.me/GODMRUNAL", style="bold yellow")
    banner.append(" | Channel: ", style="dim")
    banner.append("@BEASTX_BOTS\n", style="bold yellow")
    banner.append("Credits: ", style="dim")
    banner.append("Original Telethon by Lonami", style="italic blue")
    
    console.print(Panel(banner, border_style="cyan", padding=(1, 2)))

if not hasattr(sys, '_beastx_banner_shown'):
    _show_banner()
    sys._beastx_banner_shown = True
