"""
Simple Bot Example - BeastX
============================

A basic bot that responds to messages and commands.

Usage:
    1. Get your API credentials from https://my.telegram.org
    2. Replace api_id and api_hash below
    3. Run: python simple_bot.py
"""

from beastx import TelegramClient, events

# Replace with your credentials
api_id = 12345
api_hash = 'your_api_hash_here'
bot_token = '123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11'  # Optional: for bot account

# Create client
client = TelegramClient('bot_session', api_id, api_hash)


@client.on(events.NewMessage(pattern='/start'))
async def start_handler(event):
    """Handle /start command"""
    await event.respond(
        '**Welcome to BeastX Bot!** 🚀\n\n'
        'I am powered by BeastX library.\n\n'
        'Available commands:\n'
        '/help - Show help\n'
        '/about - About this bot\n'
        '/echo <text> - Echo your message'
    )


@client.on(events.NewMessage(pattern='/help'))
async def help_handler(event):
    """Handle /help command"""
    await event.respond(
        '**BeastX Bot Help** ℹ️\n\n'
        'This bot demonstrates BeastX features:\n'
        '• Event handlers\n'
        '• Message formatting\n'
        '• Command processing\n\n'
        'Channel: @BEASTX_BOTS\n'
        'Developer: t.me/GODMRUNAL'
    )


@client.on(events.NewMessage(pattern='/about'))
async def about_handler(event):
    """Handle /about command"""
    await event.respond(
        '**About BeastX** 📚\n\n'
        'BeastX is a Python library for Telegram MTProto API.\n\n'
        '✨ Based on Telethon by Lonami\n'
        '🔧 Developer: t.me/GODMRUNAL\n'
        '📢 Channel: @BEASTX_BOTS\n'
        '💻 GitHub: github.com/beastx-python'
    )


@client.on(events.NewMessage(pattern=r'/echo (.+)'))
async def echo_handler(event):
    """Echo the user's message"""
    text = event.pattern_match.group(1)
    await event.respond(f'You said: **{text}**')


@client.on(events.NewMessage(pattern='(?i)hello|hi'))
async def greeting_handler(event):
    """Respond to greetings"""
    await event.respond('Hello! 👋 How can I help you today?')


print('Starting BeastX Bot...')
print('Press Ctrl+C to stop')

# Start the bot
client.start(bot_token=bot_token)
client.run_until_disconnected()
