"""
Send Message Example - BeastX
==============================

Demonstrates how to send messages to users and groups.

Usage:
    python send_message.py
"""

from beastx import TelegramClient

# Your credentials
api_id = 12345
api_hash = 'your_api_hash_here'

client = TelegramClient('session', api_id, api_hash)


async def main():
    await client.start()
    
    # Send a simple message
    await client.send_message('me', 'Hello from BeastX! 🚀')
    
    # Send with markdown formatting
    await client.send_message('me', 
        '**Bold text**\n'
        '__Italic text__\n'
        '`Code text`\n'
        '[Link](https://github.com/beastx-python)'
    )
    
    # Send to a user by username
    await client.send_message('username', 'Hi there!')
    
    # Send to a user by ID
    await client.send_message(123456789, 'Message by ID')
    
    # Send to a group/channel
    await client.send_message(-100123456789, 'Group message')
    
    print('Messages sent successfully!')


with client:
    client.loop.run_until_completed(main())
