# coding: utf-8

"""
    Beckn Protocol Meta API

    This document contains all the meta API endpoints that are implemented by the network participants. The information returned from these endpoints typically contain cacheable information.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class Country(BaseModel):
    """
    Describes a country  # noqa: E501
    """
    name: Optional[StrictStr] = Field(default=None, description="Name of the country")
    code: Optional[StrictStr] = Field(default=None, description="Country code as per ISO 3166-1 and ISO 3166-2 format")
    __properties = ["name", "code"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Country:
        """Create an instance of Country from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Country:
        """Create an instance of Country from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Country.parse_obj(obj)

        _obj = Country.parse_obj({
            "name": obj.get("name"),
            "code": obj.get("code")
        })
        return _obj


