# coding: utf-8

"""
    Beckn Protocol Meta API

    This document contains all the meta API endpoints that are implemented by the network participants. The information returned from these endpoints typically contain cacheable information.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class Image(BaseModel):
    """
    Describes an image  # noqa: E501
    """
    url: Optional[StrictStr] = Field(default=None, description="URL to the image. This can be a data url or an remote url")
    size_type: Optional[StrictStr] = Field(default=None, description="The size of the image. The network policy can define the default dimensions of each type")
    width: Optional[StrictStr] = Field(default=None, description="Width of the image in pixels")
    height: Optional[StrictStr] = Field(default=None, description="Height of the image in pixels")
    __properties = ["url", "size_type", "width", "height"]

    @validator('size_type')
    def size_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('xs', 'sm', 'md', 'lg', 'xl', 'custom',):
            raise ValueError("must be one of enum values ('xs', 'sm', 'md', 'lg', 'xl', 'custom')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Image:
        """Create an instance of Image from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Image:
        """Create an instance of Image from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Image.parse_obj(obj)

        _obj = Image.parse_obj({
            "url": obj.get("url"),
            "size_type": obj.get("size_type"),
            "width": obj.get("width"),
            "height": obj.get("height")
        })
        return _obj


