# coding: utf-8

"""
    Beckn Protocol Meta API

    This document contains all the meta API endpoints that are implemented by the network participants. The information returned from these endpoints typically contain cacheable information.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, conlist
from meta.models.descriptor import Descriptor
from meta.models.tag import Tag

class TagGroup(BaseModel):
    """
    A collection of tag objects with group level attributes. For detailed documentation on the Tags and Tag Groups schema go to https://github.com/beckn/protocol-specifications/discussions/316  # noqa: E501
    """
    display: Optional[StrictBool] = Field(default=True, description="Indicates the display properties of the tag group. If display is set to false, then the group will not be displayed. If it is set to true, it should be displayed. However, group-level display properties can be overriden by individual tag-level display property. As this schema is purely for catalog display purposes, it is not recommended to send this value during search.")
    descriptor: Optional[Descriptor] = Field(default=None, description="Description of the TagGroup, can be used to store detailed information.")
    list: Optional[conlist(Tag)] = Field(default=None, description="An array of Tag objects listed under this group. This property can be set by BAPs during search to narrow the `search` and achieve more relevant results. When received during `on_search`, BAPs must render this list under the heading described by the `name` property of this schema.")
    __properties = ["display", "descriptor", "list"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TagGroup:
        """Create an instance of TagGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in list (list)
        _items = []
        if self.list:
            for _item in self.list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['list'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TagGroup:
        """Create an instance of TagGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TagGroup.parse_obj(obj)

        _obj = TagGroup.parse_obj({
            "display": obj.get("display") if obj.get("display") is not None else True,
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "list": [Tag.from_dict(_item) for _item in obj.get("list")] if obj.get("list") is not None else None
        })
        return _obj


