# coding: utf-8

"""
    Beckn Protocol Registry Infrastructure API

    This document contains the API specification for the Registry infrastructure of a beckn-enabled network. The Registry API forms the trust layer of beckn protocol. When implemented, they enable creation of an infrastructure that allow trusted transactions between network participants to take place by means of digital signature authentication. The core infrastructure is called the Network Registry or simply, Registry. Any network participant that is listed on the registry can be assumed to have successfully passed the certfication and compliance process of the network, and hence be trusted to transact with.

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr, validator
from registry.models.scalar import Scalar

class Circle(BaseModel):
    """
    Describes a circular region of a specified radius centered at a specified GPS coordinate.  # noqa: E501
    """
    gps: Optional[constr(strict=True)] = Field(default=None, description="Describes a GPS coordinate")
    radius: Optional[Scalar] = None
    __properties = ["gps", "radius"]

    @validator('gps')
    def gps_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?),\s*[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$", value):
            raise ValueError(r"must validate the regular expression /^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?),\s*[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Circle:
        """Create an instance of Circle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of radius
        if self.radius:
            _dict['radius'] = self.radius.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Circle:
        """Create an instance of Circle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Circle.parse_obj(obj)

        _obj = Circle.parse_obj({
            "gps": obj.get("gps"),
            "radius": Scalar.from_dict(obj.get("radius")) if obj.get("radius") is not None else None
        })
        return _obj


