# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.city import City
from transaction.models.organization import Organization
from transaction.models.state import State
from transaction.models.time import Time

class Billing(BaseModel):
    """
    Describes the billing details of an entity.<br>This has properties like name,organization,address,email,phone,time,tax_number, created_at,updated_at  # noqa: E501
    """
    name: Optional[StrictStr] = Field(default=None, description="Name of the billable entity")
    organization: Optional[Organization] = Field(default=None, description="Details of the organization being billed.")
    address: Optional[StrictStr] = Field(default=None, description="The address of the billable entity")
    state: Optional[State] = Field(default=None, description="The state where the billable entity resides. This is important for state-level tax calculation")
    city: Optional[City] = Field(default=None, description="The city where the billable entity resides.")
    email: Optional[StrictStr] = Field(default=None, description="Email address where the bill is sent to")
    phone: Optional[StrictStr] = Field(default=None, description="Phone number of the billable entity")
    time: Optional[Time] = Field(default=None, description="Details regarding the billing period")
    tax_id: Optional[StrictStr] = Field(default=None, description="ID of the billable entity as recognized by the taxation authority")
    __properties = ["name", "organization", "address", "state", "city", "email", "phone", "time", "tax_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Billing:
        """Create an instance of Billing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of city
        if self.city:
            _dict['city'] = self.city.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict['time'] = self.time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Billing:
        """Create an instance of Billing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Billing.parse_obj(obj)

        _obj = Billing.parse_obj({
            "name": obj.get("name"),
            "organization": Organization.from_dict(obj.get("organization")) if obj.get("organization") is not None else None,
            "address": obj.get("address"),
            "state": State.from_dict(obj.get("state")) if obj.get("state") is not None else None,
            "city": City.from_dict(obj.get("city")) if obj.get("city") is not None else None,
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "time": Time.from_dict(obj.get("time")) if obj.get("time") is not None else None,
            "tax_id": obj.get("tax_id")
        })
        return _obj


