# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from transaction.models.fee import Fee
from transaction.models.fulfillment_state import FulfillmentState
from transaction.models.media_file import MediaFile
from transaction.models.time import Time
from transaction.models.x_input import XInput

class CancellationTerm(BaseModel):
    """
    Describes the cancellation terms of an item or an order. This can be referenced at an item or order level. Item-level cancellation terms can override the terms at the order level.  # noqa: E501
    """
    fulfillment_state: Optional[FulfillmentState] = Field(default=None, description="The state of fulfillment during which this term is applicable.")
    reason_required: Optional[StrictBool] = Field(default=None, description="Indicates whether a reason is required to cancel the order")
    cancel_by: Optional[Time] = Field(default=None, description="Information related to the time of cancellation.")
    cancellation_fee: Optional[Fee] = None
    xinput: Optional[XInput] = None
    external_ref: Optional[MediaFile] = None
    __properties = ["fulfillment_state", "reason_required", "cancel_by", "cancellation_fee", "xinput", "external_ref"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CancellationTerm:
        """Create an instance of CancellationTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of fulfillment_state
        if self.fulfillment_state:
            _dict['fulfillment_state'] = self.fulfillment_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancel_by
        if self.cancel_by:
            _dict['cancel_by'] = self.cancel_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancellation_fee
        if self.cancellation_fee:
            _dict['cancellation_fee'] = self.cancellation_fee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of xinput
        if self.xinput:
            _dict['xinput'] = self.xinput.to_dict()
        # override the default output from pydantic by calling `to_dict()` of external_ref
        if self.external_ref:
            _dict['external_ref'] = self.external_ref.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CancellationTerm:
        """Create an instance of CancellationTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CancellationTerm.parse_obj(obj)

        _obj = CancellationTerm.parse_obj({
            "fulfillment_state": FulfillmentState.from_dict(obj.get("fulfillment_state")) if obj.get("fulfillment_state") is not None else None,
            "reason_required": obj.get("reason_required"),
            "cancel_by": Time.from_dict(obj.get("cancel_by")) if obj.get("cancel_by") is not None else None,
            "cancellation_fee": Fee.from_dict(obj.get("cancellation_fee")) if obj.get("cancellation_fee") is not None else None,
            "xinput": XInput.from_dict(obj.get("xinput")) if obj.get("xinput") is not None else None,
            "external_ref": MediaFile.from_dict(obj.get("external_ref")) if obj.get("external_ref") is not None else None
        })
        return _obj


