# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from transaction.models.descriptor import Descriptor
from transaction.models.fulfillment import Fulfillment
from transaction.models.offer import Offer
from transaction.models.payment import Payment
from transaction.models.provider import Provider

class Catalog(BaseModel):
    """
    Describes the products or services offered by a BPP. This is typically sent as the response to a search intent from a BAP. The payment terms, offers and terms of fulfillment supported by the BPP can also be included here. The BPP can show hierarchical nature of products/services in its catalog using the parent_category_id in categories. The BPP can also send a ttl (time to live) in the context which is the duration for which a BAP can cache the catalog and use the cached catalog.  <br>This has properties like bbp/descriptor,bbp/categories,bbp/fulfillments,bbp/payments,bbp/offers,bbp/providers and exp<br>This is used in the following situations.<br><ul><li>This is typically used in the discovery stage when the BPP sends the details of the products and services it offers as response to a search intent from the BAP. </li></ul>  # noqa: E501
    """
    descriptor: Optional[Descriptor] = None
    fulfillments: Optional[conlist(Fulfillment)] = Field(default=None, description="Fulfillment modes offered at the BPP level. This is used when a BPP itself offers fulfillments on behalf of the providers it has onboarded.")
    payments: Optional[conlist(Payment)] = Field(default=None, description="Payment terms offered by the BPP for all transactions. This can be overriden at the provider level.")
    offers: Optional[conlist(Offer)] = Field(default=None, description="Offers at the BPP-level. This is common across all providers onboarded by the BPP.")
    providers: Optional[conlist(Provider)] = None
    exp: Optional[datetime] = Field(default=None, description="Timestamp after which catalog will expire")
    ttl: Optional[StrictStr] = Field(default=None, description="Duration in seconds after which this catalog will expire")
    __properties = ["descriptor", "fulfillments", "payments", "offers", "providers", "exp", "ttl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Catalog:
        """Create an instance of Catalog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in fulfillments (list)
        _items = []
        if self.fulfillments:
            for _item in self.fulfillments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fulfillments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item in self.payments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in offers (list)
        _items = []
        if self.offers:
            for _item in self.offers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['offers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in providers (list)
        _items = []
        if self.providers:
            for _item in self.providers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['providers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Catalog:
        """Create an instance of Catalog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Catalog.parse_obj(obj)

        _obj = Catalog.parse_obj({
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "fulfillments": [Fulfillment.from_dict(_item) for _item in obj.get("fulfillments")] if obj.get("fulfillments") is not None else None,
            "payments": [Payment.from_dict(_item) for _item in obj.get("payments")] if obj.get("payments") is not None else None,
            "offers": [Offer.from_dict(_item) for _item in obj.get("offers")] if obj.get("offers") is not None else None,
            "providers": [Provider.from_dict(_item) for _item in obj.get("providers")] if obj.get("providers") is not None else None,
            "exp": obj.get("exp"),
            "ttl": obj.get("ttl")
        })
        return _obj


