# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from transaction.models.descriptor import Descriptor
from transaction.models.tag_group import TagGroup
from transaction.models.time import Time

class Category(BaseModel):
    """
    A label under which a collection of items can be grouped.  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="ID of the category")
    parent_category_id: Optional[StrictStr] = Field(default=None, description="ID of the category")
    descriptor: Optional[Descriptor] = None
    time: Optional[Time] = None
    ttl: Optional[Any] = None
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "parent_category_id", "descriptor", "time", "ttl", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Category:
        """Create an instance of Category from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict['time'] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # set to None if ttl (nullable) is None
        # and __fields_set__ contains the field
        if self.ttl is None and "ttl" in self.__fields_set__:
            _dict['ttl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Category:
        """Create an instance of Category from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Category.parse_obj(obj)

        _obj = Category.parse_obj({
            "id": obj.get("id"),
            "parent_category_id": obj.get("parent_category_id"),
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "time": Time.from_dict(obj.get("time")) if obj.get("time") is not None else None,
            "ttl": obj.get("ttl"),
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


