# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr

class Contact(BaseModel):
    """
    Describes the contact information of an entity  # noqa: E501
    """
    phone: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    jcard: Optional[Dict[str, Any]] = Field(default=None, description="A Jcard object as per draft-ietf-jcardcal-jcard-03 specification")
    __properties = ["phone", "email", "jcard"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Contact:
        """Create an instance of Contact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Contact:
        """Create an instance of Contact from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Contact.parse_obj(obj)

        _obj = Contact.parse_obj({
            "phone": obj.get("phone"),
            "email": obj.get("email"),
            "jcard": obj.get("jcard")
        })
        return _obj


