# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.location import Location

class Context(BaseModel):
    """
    Every API call in beckn protocol has a context. It provides a high-level overview to the receiver about the nature of the intended transaction. Typically, it is the BAP that sets the transaction context based on the consumer's location and action on their UI. But sometimes, during unsolicited callbacks, the BPP also sets the transaction context but it is usually the same as the context of a previous full-cycle, request-callback interaction between the BAP and the BPP. The context object contains four types of fields. <ol><li>Demographic information about the transaction using fields like `domain`, `country`, and `region`.</li><li>Addressing details like the sending and receiving platform's ID and API URL.</li><li>Interoperability information like the protocol version that implemented by the sender and,</li><li>Transaction details like the method being called at the receiver's endpoint, the transaction_id that represents an end-to-end user session at the BAP, a message ID to pair requests with callbacks, a timestamp to capture sending times, a ttl to specifiy the validity of the request, and a key to encrypt information if necessary.</li></ol> This object must be passed in every interaction between a BAP and a BPP. In HTTP/S implementations, it is not necessary to send the context during the synchronous response. However, in asynchronous protocols, the context must be sent during all interactions,  # noqa: E501
    """
    domain: Optional[Any] = Field(default=None, description="Domain code that is relevant to this transaction context")
    location: Optional[Location] = Field(default=None, description="The location where the transaction is intended to be fulfilled.")
    action: Optional[StrictStr] = Field(default=None, description="The Beckn protocol method being called by the sender and executed at the receiver.")
    version: Optional[StrictStr] = Field(default=None, description="Version of transaction protocol being used by the sender.")
    bap_id: Optional[StrictStr] = Field(default=None, description="Subscriber ID of the BAP")
    bap_uri: Optional[StrictStr] = Field(default=None, description="Subscriber URL of the BAP for accepting callbacks from BPPs.")
    bpp_id: Optional[StrictStr] = Field(default=None, description="Subscriber ID of the BPP")
    bpp_uri: Optional[StrictStr] = Field(default=None, description="Subscriber URL of the BPP for accepting calls from BAPs.")
    transaction_id: Optional[StrictStr] = Field(default=None, description="This is a unique value which persists across all API calls from `search` through `confirm`. This is done to indicate an active user session across multiple requests. The BPPs can use this value to push personalized recommendations, and dynamic offerings related to an ongoing transaction despite being unaware of the user active on the BAP.")
    message_id: Optional[StrictStr] = Field(default=None, description="This is a unique value which persists during a request / callback cycle. Since beckn protocol APIs are asynchronous, BAPs need a common value to match an incoming callback from a BPP to an earlier call. This value can also be used to ignore duplicate messages coming from the BPP. It is recommended to generate a fresh message_id for every new interaction. When sending unsolicited callbacks, BPPs must generate a new message_id.")
    timestamp: Optional[datetime] = Field(default=None, description="Time of request generation in RFC3339 format")
    key: Optional[StrictStr] = Field(default=None, description="The encryption public key of the sender")
    ttl: Optional[StrictStr] = Field(default=None, description="The duration in ISO8601 format after timestamp for which this message holds valid")
    __properties = ["domain", "location", "action", "version", "bap_id", "bap_uri", "bpp_id", "bpp_uri", "transaction_id", "message_id", "timestamp", "key", "ttl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Context:
        """Create an instance of Context from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # set to None if domain (nullable) is None
        # and __fields_set__ contains the field
        if self.domain is None and "domain" in self.__fields_set__:
            _dict['domain'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Context:
        """Create an instance of Context from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Context.parse_obj(obj)

        _obj = Context.parse_obj({
            "domain": obj.get("domain"),
            "location": Location.from_dict(obj.get("location")) if obj.get("location") is not None else None,
            "action": obj.get("action"),
            "version": obj.get("version"),
            "bap_id": obj.get("bap_id"),
            "bap_uri": obj.get("bap_uri"),
            "bpp_id": obj.get("bpp_id"),
            "bpp_uri": obj.get("bpp_uri"),
            "transaction_id": obj.get("transaction_id"),
            "message_id": obj.get("message_id"),
            "timestamp": obj.get("timestamp"),
            "key": obj.get("key"),
            "ttl": obj.get("ttl")
        })
        return _obj


