# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class Credential(BaseModel):
    """
    Describes a credential of an entity - Person or Organization  # noqa: E501
    """
    id: Optional[StrictStr] = None
    type: Optional[StrictStr] = 'VerifiableCredential'
    url: Optional[StrictStr] = Field(default=None, description="URL of the credential")
    __properties = ["id", "type", "url"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Credential:
        """Create an instance of Credential from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Credential:
        """Create an instance of Credential from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Credential.parse_obj(obj)

        _obj = Credential.parse_obj({
            "id": obj.get("id"),
            "type": obj.get("type") if obj.get("type") is not None else 'VerifiableCredential',
            "url": obj.get("url")
        })
        return _obj


