# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictStr, conlist
from transaction.models.descriptor_additional_desc import DescriptorAdditionalDesc
from transaction.models.image import Image
from transaction.models.media_file import MediaFile

class Descriptor(BaseModel):
    """
    Physical description of something.  # noqa: E501
    """
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    short_desc: Optional[StrictStr] = None
    long_desc: Optional[StrictStr] = None
    additional_desc: Optional[DescriptorAdditionalDesc] = None
    media: Optional[conlist(MediaFile)] = None
    images: Optional[conlist(Image)] = None
    __properties = ["name", "code", "short_desc", "long_desc", "additional_desc", "media", "images"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Descriptor:
        """Create an instance of Descriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of additional_desc
        if self.additional_desc:
            _dict['additional_desc'] = self.additional_desc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in media (list)
        _items = []
        if self.media:
            for _item in self.media:
                if _item:
                    _items.append(_item.to_dict())
            _dict['media'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Descriptor:
        """Create an instance of Descriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Descriptor.parse_obj(obj)

        _obj = Descriptor.parse_obj({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "short_desc": obj.get("short_desc"),
            "long_desc": obj.get("long_desc"),
            "additional_desc": DescriptorAdditionalDesc.from_dict(obj.get("additional_desc")) if obj.get("additional_desc") is not None else None,
            "media": [MediaFile.from_dict(_item) for _item in obj.get("media")] if obj.get("media") is not None else None,
            "images": [Image.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None
        })
        return _obj


