# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.media_file import MediaFile

class Domain(BaseModel):
    """
    Described the industry sector or sub-sector. The network policy should contain codes for all the industry sectors supported by the network. Domains can be created in varying levels of granularity. The granularity of a domain can be decided by the participants of the network. Too broad domains will result in irrelevant search broadcast calls to BPPs that don't have services supporting the domain. Too narrow domains will result in a large number of registry entries for each BPP. It is recommended that network facilitators actively collaborate with various working groups and network participants to carefully choose domain codes keeping in mind relevance, performance, and opportunity cost. It is recommended that networks choose broad domains like mobility, logistics, healthcare etc, and progressively granularize them as and when the number of network participants for each domain grows large.  # noqa: E501
    """
    name: Optional[StrictStr] = Field(default=None, description="Name of the domain")
    code: Optional[Any] = None
    additional_info: Optional[MediaFile] = Field(default=None, description="A url that contains addtional information about that domain.")
    __properties = ["name", "code", "additional_info"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Domain:
        """Create an instance of Domain from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of additional_info
        if self.additional_info:
            _dict['additional_info'] = self.additional_info.to_dict()
        # set to None if code (nullable) is None
        # and __fields_set__ contains the field
        if self.code is None and "code" in self.__fields_set__:
            _dict['code'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Domain:
        """Create an instance of Domain from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Domain.parse_obj(obj)

        _obj = Domain.parse_obj({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "additional_info": MediaFile.from_dict(obj.get("additional_info")) if obj.get("additional_info") is not None else None
        })
        return _obj


