# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr, validator
from transaction.models.price import Price

class Fee(BaseModel):
    """
    A fee applied on a particular entity  # noqa: E501
    """
    percentage: Optional[constr(strict=True)] = Field(default=None, description="Percentage of a value")
    amount: Optional[Price] = Field(default=None, description="A fixed value")
    __properties = ["percentage", "amount"]

    @validator('percentage')
    def percentage_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[+-]?([0-9]*[.])?[0-9]+", value):
            raise ValueError(r"must validate the regular expression /[+-]?([0-9]*[.])?[0-9]+/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Fee:
        """Create an instance of Fee from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Fee:
        """Create an instance of Fee from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Fee.parse_obj(obj)

        _obj = Fee.parse_obj({
            "percentage": obj.get("percentage"),
            "amount": Price.from_dict(obj.get("amount")) if obj.get("amount") is not None else None
        })
        return _obj


