# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.descriptor import Descriptor

class FulfillmentState(BaseModel):
    """
    Describes the state of fulfillment  # noqa: E501
    """
    descriptor: Optional[Descriptor] = None
    updated_at: Optional[datetime] = None
    updated_by: Optional[StrictStr] = Field(default=None, description="ID of entity which changed the state")
    __properties = ["descriptor", "updated_at", "updated_by"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FulfillmentState:
        """Create an instance of FulfillmentState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FulfillmentState:
        """Create an instance of FulfillmentState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FulfillmentState.parse_obj(obj)

        _obj = FulfillmentState.parse_obj({
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by")
        })
        return _obj


