# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from transaction.models.category import Category
from transaction.models.descriptor import Descriptor
from transaction.models.fulfillment import Fulfillment
from transaction.models.item import Item
from transaction.models.offer import Offer
from transaction.models.payment import Payment
from transaction.models.provider import Provider
from transaction.models.tag_group import TagGroup

class Intent(BaseModel):
    """
    The intent to buy or avail a product or a service. The BAP can declare the intent of the consumer containing <ul><li>What they want (A product, service, offer)</li><li>Who they want (A seller, service provider, agent etc)</li><li>Where they want it and where they want it from</li><li>When they want it (start and end time of fulfillment</li><li>How they want to pay for it</li></ul><br>This has properties like descriptor,provider,fulfillment,payment,category,offer,item,tags<br>This is typically used by the BAP to send the purpose of the user's search to the BPP. This will be used by the BPP to find products or services it offers that may match the user's intent.<br>For example, in Mobility, the mobility consumer declares a mobility intent. In this case, the mobility consumer declares information that describes various aspects of their journey like,<ul><li>Where would they like to begin their journey (intent.fulfillment.start.location)</li><li>Where would they like to end their journey (intent.fulfillment.end.location)</li><li>When would they like to begin their journey (intent.fulfillment.start.time)</li><li>When would they like to end their journey (intent.fulfillment.end.time)</li><li>Who is the transport service provider they would like to avail services from (intent.provider)</li><li>Who is traveling (This is not recommended in public networks) (intent.fulfillment.customer)</li><li>What kind of fare product would they like to purchase (intent.item)</li><li>What add-on services would they like to avail</li><li>What offers would they like to apply on their booking (intent.offer)</li><li>What category of services would they like to avail (intent.category)</li><li>What additional luggage are they carrying</li><li>How would they like to pay for their journey (intent.payment)</li></ul><br>For example, in health domain, a consumer declares the intent for a lab booking the describes various aspects of their booking like,<ul><li>Where would they like to get their scan/test done (intent.fulfillment.start.location)</li><li>When would they like to get their scan/test done (intent.fulfillment.start.time)</li><li>When would they like to get the results of their test/scan (intent.fulfillment.end.time)</li><li>Who is the service provider they would like to avail services from (intent.provider)</li><li>Who is getting the test/scan (intent.fulfillment.customer)</li><li>What kind of test/scan would they like to purchase (intent.item)</li><li>What category of services would they like to avail (intent.category)</li><li>How would they like to pay for their journey (intent.payment)</li></ul>  # noqa: E501
    """
    descriptor: Optional[Descriptor] = Field(default=None, description="A raw description of the search intent. Free text search strings, raw audio, etc can be sent in this object.")
    provider: Optional[Provider] = Field(default=None, description="The provider from which the customer wants to place to the order from")
    fulfillment: Optional[Fulfillment] = Field(default=None, description="Details on how the customer wants their order fulfilled")
    payment: Optional[Payment] = Field(default=None, description="Details on how the customer wants to pay for the order")
    category: Optional[Category] = Field(default=None, description="Details on the item category")
    offer: Optional[Offer] = Field(default=None, description="details on the offer the customer wants to avail")
    item: Optional[Item] = Field(default=None, description="Details of the item that the consumer wants to order")
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["descriptor", "provider", "fulfillment", "payment", "category", "offer", "item", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Intent:
        """Create an instance of Intent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fulfillment
        if self.fulfillment:
            _dict['fulfillment'] = self.fulfillment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment
        if self.payment:
            _dict['payment'] = self.payment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of category
        if self.category:
            _dict['category'] = self.category.to_dict()
        # override the default output from pydantic by calling `to_dict()` of offer
        if self.offer:
            _dict['offer'] = self.offer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of item
        if self.item:
            _dict['item'] = self.item.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Intent:
        """Create an instance of Intent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Intent.parse_obj(obj)

        _obj = Intent.parse_obj({
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "provider": Provider.from_dict(obj.get("provider")) if obj.get("provider") is not None else None,
            "fulfillment": Fulfillment.from_dict(obj.get("fulfillment")) if obj.get("fulfillment") is not None else None,
            "payment": Payment.from_dict(obj.get("payment")) if obj.get("payment") is not None else None,
            "category": Category.from_dict(obj.get("category")) if obj.get("category") is not None else None,
            "offer": Offer.from_dict(obj.get("offer")) if obj.get("offer") is not None else None,
            "item": Item.from_dict(obj.get("item")) if obj.get("item") is not None else None,
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


