# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from transaction.models.add_on import AddOn
from transaction.models.cancellation_term import CancellationTerm
from transaction.models.descriptor import Descriptor
from transaction.models.item_quantity import ItemQuantity
from transaction.models.organization import Organization
from transaction.models.price import Price
from transaction.models.refund_term import RefundTerm
from transaction.models.replacement_term import ReplacementTerm
from transaction.models.return_term import ReturnTerm
from transaction.models.tag_group import TagGroup
from transaction.models.time import Time
from transaction.models.x_input import XInput

class Item(BaseModel):
    """
    Describes a product or a service offered to the end consumer by the provider. In the mobility sector, it can represent a fare product like one way journey. In the logistics sector, it can represent the delivery service offering. In the retail domain it can represent a product like a grocery item.  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="ID of the item.")
    parent_item_id: Optional[StrictStr] = Field(default=None, description="ID of the item, this item is a variant of")
    parent_item_quantity: Optional[ItemQuantity] = Field(default=None, description="The number of units of the parent item this item is a multiple of")
    descriptor: Optional[Descriptor] = Field(default=None, description="Physical description of the item")
    creator: Optional[Organization] = Field(default=None, description="The creator of this item")
    price: Optional[Price] = Field(default=None, description="The price of this item, if it has intrinsic value")
    quantity: Optional[ItemQuantity] = Field(default=None, description="The selling quantity of the item")
    category_ids: Optional[conlist(StrictStr)] = Field(default=None, description="Categories this item can be listed under")
    fulfillment_ids: Optional[conlist(StrictStr)] = Field(default=None, description="Modes through which this item can be fulfilled")
    location_ids: Optional[conlist(StrictStr)] = Field(default=None, description="Provider Locations this item is available in")
    payment_ids: Optional[conlist(StrictStr)] = Field(default=None, description="Payment modalities through which this item can be ordered")
    add_ons: Optional[conlist(AddOn)] = None
    cancellation_terms: Optional[conlist(CancellationTerm)] = Field(default=None, description="Cancellation terms of this item")
    refund_terms: Optional[conlist(RefundTerm)] = Field(default=None, description="Refund terms of this item")
    replacement_terms: Optional[conlist(ReplacementTerm)] = Field(default=None, description="Terms that are applicable be met when this item is replaced")
    return_terms: Optional[conlist(ReturnTerm)] = Field(default=None, description="Terms that are applicable when this item is returned")
    xinput: Optional[XInput] = Field(default=None, description="Additional input required from the customer to purchase / avail this item")
    time: Optional[Time] = Field(default=None, description="Temporal attributes of this item. This property is used when the item exists on the catalog only for a limited period of time.")
    rateable: Optional[StrictBool] = Field(default=None, description="Whether this item can be rated")
    rating: Optional[StrictStr] = Field(default=None, description="The rating of the item")
    matched: Optional[StrictBool] = Field(default=None, description="Whether this item is an exact match of the request")
    related: Optional[StrictBool] = Field(default=None, description="Whether this item is a related item to the exactly matched item")
    recommended: Optional[StrictBool] = Field(default=None, description="Whether this item is a recommended item to a response")
    ttl: Optional[StrictStr] = Field(default=None, description="Time to live in seconds for an instance of this schema")
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "parent_item_id", "parent_item_quantity", "descriptor", "creator", "price", "quantity", "category_ids", "fulfillment_ids", "location_ids", "payment_ids", "add_ons", "cancellation_terms", "refund_terms", "replacement_terms", "return_terms", "xinput", "time", "rateable", "rating", "matched", "related", "recommended", "ttl", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Item:
        """Create an instance of Item from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of parent_item_quantity
        if self.parent_item_quantity:
            _dict['parent_item_quantity'] = self.parent_item_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of creator
        if self.creator:
            _dict['creator'] = self.creator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict['quantity'] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in add_ons (list)
        _items = []
        if self.add_ons:
            for _item in self.add_ons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['add_ons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cancellation_terms (list)
        _items = []
        if self.cancellation_terms:
            for _item in self.cancellation_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cancellation_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in refund_terms (list)
        _items = []
        if self.refund_terms:
            for _item in self.refund_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['refund_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in replacement_terms (list)
        _items = []
        if self.replacement_terms:
            for _item in self.replacement_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['replacement_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in return_terms (list)
        _items = []
        if self.return_terms:
            for _item in self.return_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['return_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of xinput
        if self.xinput:
            _dict['xinput'] = self.xinput.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict['time'] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Item:
        """Create an instance of Item from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Item.parse_obj(obj)

        _obj = Item.parse_obj({
            "id": obj.get("id"),
            "parent_item_id": obj.get("parent_item_id"),
            "parent_item_quantity": ItemQuantity.from_dict(obj.get("parent_item_quantity")) if obj.get("parent_item_quantity") is not None else None,
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "creator": Organization.from_dict(obj.get("creator")) if obj.get("creator") is not None else None,
            "price": Price.from_dict(obj.get("price")) if obj.get("price") is not None else None,
            "quantity": ItemQuantity.from_dict(obj.get("quantity")) if obj.get("quantity") is not None else None,
            "category_ids": obj.get("category_ids"),
            "fulfillment_ids": obj.get("fulfillment_ids"),
            "location_ids": obj.get("location_ids"),
            "payment_ids": obj.get("payment_ids"),
            "add_ons": [AddOn.from_dict(_item) for _item in obj.get("add_ons")] if obj.get("add_ons") is not None else None,
            "cancellation_terms": [CancellationTerm.from_dict(_item) for _item in obj.get("cancellation_terms")] if obj.get("cancellation_terms") is not None else None,
            "refund_terms": [RefundTerm.from_dict(_item) for _item in obj.get("refund_terms")] if obj.get("refund_terms") is not None else None,
            "replacement_terms": [ReplacementTerm.from_dict(_item) for _item in obj.get("replacement_terms")] if obj.get("replacement_terms") is not None else None,
            "return_terms": [ReturnTerm.from_dict(_item) for _item in obj.get("return_terms")] if obj.get("return_terms") is not None else None,
            "xinput": XInput.from_dict(obj.get("xinput")) if obj.get("xinput") is not None else None,
            "time": Time.from_dict(obj.get("time")) if obj.get("time") is not None else None,
            "rateable": obj.get("rateable"),
            "rating": obj.get("rating"),
            "matched": obj.get("matched"),
            "related": obj.get("related"),
            "recommended": obj.get("recommended"),
            "ttl": obj.get("ttl"),
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


