# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, conint
from transaction.models.scalar import Scalar

class ItemQuantityUnitized(BaseModel):
    """
    This represents the quantity available in a single unit of the item  # noqa: E501
    """
    count: Optional[conint(strict=True, le=1, ge=1)] = None
    measure: Optional[Scalar] = None
    __properties = ["count", "measure"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ItemQuantityUnitized:
        """Create an instance of ItemQuantityUnitized from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of measure
        if self.measure:
            _dict['measure'] = self.measure.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ItemQuantityUnitized:
        """Create an instance of ItemQuantityUnitized from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ItemQuantityUnitized.parse_obj(obj)

        _obj = ItemQuantityUnitized.parse_obj({
            "count": obj.get("count"),
            "measure": Scalar.from_dict(obj.get("measure")) if obj.get("measure") is not None else None
        })
        return _obj


