# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictStr, conlist
from transaction.models.descriptor import Descriptor
from transaction.models.tag_group import TagGroup
from transaction.models.time import Time

class Offer(BaseModel):
    """
    An offer associated with a catalog. This is typically used to promote a particular product and enable more purchases.  # noqa: E501
    """
    id: Optional[StrictStr] = None
    descriptor: Optional[Descriptor] = None
    location_ids: Optional[conlist(StrictStr)] = None
    category_ids: Optional[conlist(StrictStr)] = None
    item_ids: Optional[conlist(StrictStr)] = None
    time: Optional[Time] = None
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "descriptor", "location_ids", "category_ids", "item_ids", "time", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Offer:
        """Create an instance of Offer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of descriptor
        if self.descriptor:
            _dict['descriptor'] = self.descriptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict['time'] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Offer:
        """Create an instance of Offer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Offer.parse_obj(obj)

        _obj = Offer.parse_obj({
            "id": obj.get("id"),
            "descriptor": Descriptor.from_dict(obj.get("descriptor")) if obj.get("descriptor") is not None else None,
            "location_ids": obj.get("location_ids"),
            "category_ids": obj.get("category_ids"),
            "item_ids": obj.get("item_ids"),
            "time": Time.from_dict(obj.get("time")) if obj.get("time") is not None else None,
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


