# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from transaction.models.add_on import AddOn
from transaction.models.billing import Billing
from transaction.models.cancellation import Cancellation
from transaction.models.cancellation_term import CancellationTerm
from transaction.models.fulfillment import Fulfillment
from transaction.models.item import Item
from transaction.models.offer import Offer
from transaction.models.payment import Payment
from transaction.models.provider import Provider
from transaction.models.quotation import Quotation
from transaction.models.refund_term import RefundTerm
from transaction.models.replacement_term import ReplacementTerm
from transaction.models.return_term import ReturnTerm
from transaction.models.tag_group import TagGroup
from transaction.models.x_input import XInput

class Order(BaseModel):
    """
    Describes a legal purchase order. It contains the complete details of the legal contract created between the buyer and the seller.  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="Human-readable ID of the order. This is generated at the BPP layer. The BPP can either generate order id within its system or forward the order ID created at the provider level.")
    ref_order_ids: Optional[conlist(StrictStr)] = Field(default=None, description="A list of order IDs to link this order to previous orders.")
    status: Optional[StrictStr] = Field(default=None, description="Status of the order. Allowed values can be defined by the network policy")
    type: Optional[StrictStr] = Field(default='DEFAULT', description="This is used to indicate the type of order being created to BPPs. Sometimes orders can be linked to previous orders, like a replacement order in a retail domain. A follow-up consultation in healthcare domain. A single order part of a subscription order. The list of order types can be standardized at the network level.")
    provider: Optional[Provider] = Field(default=None, description="Details of the provider whose catalog items have been selected.")
    items: Optional[conlist(Item)] = Field(default=None, description="The items purchased / availed in this order")
    add_ons: Optional[conlist(AddOn)] = Field(default=None, description="The add-ons purchased / availed in this order")
    offers: Optional[conlist(Offer)] = Field(default=None, description="The offers applied in this order")
    billing: Optional[Billing] = Field(default=None, description="The billing details of this order")
    fulfillments: Optional[conlist(Fulfillment)] = Field(default=None, description="The fulfillments involved in completing this order")
    cancellation: Optional[Cancellation] = Field(default=None, description="The cancellation details of this order")
    cancellation_terms: Optional[conlist(CancellationTerm)] = Field(default=None, description="Cancellation terms of this item")
    refund_terms: Optional[conlist(RefundTerm)] = Field(default=None, description="Refund terms of this item")
    replacement_terms: Optional[conlist(ReplacementTerm)] = Field(default=None, description="Replacement terms of this item")
    return_terms: Optional[conlist(ReturnTerm)] = Field(default=None, description="Return terms of this item")
    quote: Optional[Quotation] = Field(default=None, description="The mutually agreed upon quotation for this order.")
    payments: Optional[conlist(Payment)] = Field(default=None, description="The terms of settlement for this order")
    created_at: Optional[datetime] = Field(default=None, description="The date-time of creation of this order")
    updated_at: Optional[datetime] = Field(default=None, description="The date-time of updated of this order")
    xinput: Optional[XInput] = Field(default=None, description="Additional input required from the customer to confirm this order")
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "ref_order_ids", "status", "type", "provider", "items", "add_ons", "offers", "billing", "fulfillments", "cancellation", "cancellation_terms", "refund_terms", "replacement_terms", "return_terms", "quote", "payments", "created_at", "updated_at", "xinput", "tags"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ACTIVE', 'COMPLETE', 'CANCELLED',):
            raise ValueError("must be one of enum values ('ACTIVE', 'COMPLETE', 'CANCELLED')")
        return value

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('DRAFT', 'DEFAULT',):
            raise ValueError("must be one of enum values ('DRAFT', 'DEFAULT')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Order:
        """Create an instance of Order from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in add_ons (list)
        _items = []
        if self.add_ons:
            for _item in self.add_ons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['add_ons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in offers (list)
        _items = []
        if self.offers:
            for _item in self.offers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['offers'] = _items
        # override the default output from pydantic by calling `to_dict()` of billing
        if self.billing:
            _dict['billing'] = self.billing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in fulfillments (list)
        _items = []
        if self.fulfillments:
            for _item in self.fulfillments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fulfillments'] = _items
        # override the default output from pydantic by calling `to_dict()` of cancellation
        if self.cancellation:
            _dict['cancellation'] = self.cancellation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cancellation_terms (list)
        _items = []
        if self.cancellation_terms:
            for _item in self.cancellation_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cancellation_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in refund_terms (list)
        _items = []
        if self.refund_terms:
            for _item in self.refund_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['refund_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in replacement_terms (list)
        _items = []
        if self.replacement_terms:
            for _item in self.replacement_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['replacement_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in return_terms (list)
        _items = []
        if self.return_terms:
            for _item in self.return_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['return_terms'] = _items
        # override the default output from pydantic by calling `to_dict()` of quote
        if self.quote:
            _dict['quote'] = self.quote.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item in self.payments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of xinput
        if self.xinput:
            _dict['xinput'] = self.xinput.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Order:
        """Create an instance of Order from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Order.parse_obj(obj)

        _obj = Order.parse_obj({
            "id": obj.get("id"),
            "ref_order_ids": obj.get("ref_order_ids"),
            "status": obj.get("status"),
            "type": obj.get("type") if obj.get("type") is not None else 'DEFAULT',
            "provider": Provider.from_dict(obj.get("provider")) if obj.get("provider") is not None else None,
            "items": [Item.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None,
            "add_ons": [AddOn.from_dict(_item) for _item in obj.get("add_ons")] if obj.get("add_ons") is not None else None,
            "offers": [Offer.from_dict(_item) for _item in obj.get("offers")] if obj.get("offers") is not None else None,
            "billing": Billing.from_dict(obj.get("billing")) if obj.get("billing") is not None else None,
            "fulfillments": [Fulfillment.from_dict(_item) for _item in obj.get("fulfillments")] if obj.get("fulfillments") is not None else None,
            "cancellation": Cancellation.from_dict(obj.get("cancellation")) if obj.get("cancellation") is not None else None,
            "cancellation_terms": [CancellationTerm.from_dict(_item) for _item in obj.get("cancellation_terms")] if obj.get("cancellation_terms") is not None else None,
            "refund_terms": [RefundTerm.from_dict(_item) for _item in obj.get("refund_terms")] if obj.get("refund_terms") is not None else None,
            "replacement_terms": [ReplacementTerm.from_dict(_item) for _item in obj.get("replacement_terms")] if obj.get("replacement_terms") is not None else None,
            "return_terms": [ReturnTerm.from_dict(_item) for _item in obj.get("return_terms")] if obj.get("return_terms") is not None else None,
            "quote": Quotation.from_dict(obj.get("quote")) if obj.get("quote") is not None else None,
            "payments": [Payment.from_dict(_item) for _item in obj.get("payments")] if obj.get("payments") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "xinput": XInput.from_dict(obj.get("xinput")) if obj.get("xinput") is not None else None,
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


