# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class PaymentParams(BaseModel):
    """
    PaymentParams
    """
    transaction_id: Optional[StrictStr] = Field(default=None, description="The reference transaction ID associated with a payment activity")
    amount: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    bank_code: Optional[StrictStr] = None
    bank_account_number: Optional[StrictStr] = None
    virtual_payment_address: Optional[StrictStr] = None
    source_bank_code: Optional[StrictStr] = None
    source_bank_account_number: Optional[StrictStr] = None
    source_virtual_payment_address: Optional[StrictStr] = None
    __properties = ["transaction_id", "amount", "currency", "bank_code", "bank_account_number", "virtual_payment_address", "source_bank_code", "source_bank_account_number", "source_virtual_payment_address"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaymentParams:
        """Create an instance of PaymentParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaymentParams:
        """Create an instance of PaymentParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaymentParams.parse_obj(obj)

        _obj = PaymentParams.parse_obj({
            "transaction_id": obj.get("transaction_id"),
            "amount": obj.get("amount"),
            "currency": obj.get("currency"),
            "bank_code": obj.get("bank_code"),
            "bank_account_number": obj.get("bank_account_number"),
            "virtual_payment_address": obj.get("virtual_payment_address"),
            "source_bank_code": obj.get("source_bank_code"),
            "source_bank_account_number": obj.get("source_bank_account_number"),
            "source_virtual_payment_address": obj.get("source_virtual_payment_address")
        })
        return _obj


