# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from transaction.models.credential import Credential
from transaction.models.image import Image
from transaction.models.language import Language
from transaction.models.skill import Skill
from transaction.models.tag_group import TagGroup

class Person(BaseModel):
    """
    Describes a person as any individual  # noqa: E501
    """
    id: Optional[StrictStr] = Field(default=None, description="Describes the identity of the person")
    url: Optional[StrictStr] = Field(default=None, description="Profile url of the person")
    name: Optional[StrictStr] = Field(default=None, description="the name of the person")
    image: Optional[Image] = None
    age: Optional[StrictStr] = Field(default=None, description="Age of the person")
    dob: Optional[date] = Field(default=None, description="Date of birth of the person")
    gender: Optional[StrictStr] = Field(default=None, description="Gender of something, typically a Person, but possibly also fictional characters, animals, etc. While Male and Female may be used, text strings are also acceptable for people who do not identify as a binary gender.Allowed values for this field can be published in the network policy")
    creds: Optional[conlist(Credential)] = None
    languages: Optional[conlist(Language)] = None
    skills: Optional[conlist(Skill)] = None
    tags: Optional[conlist(TagGroup)] = None
    __properties = ["id", "url", "name", "image", "age", "dob", "gender", "creds", "languages", "skills", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Person:
        """Create an instance of Person from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of image
        if self.image:
            _dict['image'] = self.image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in creds (list)
        _items = []
        if self.creds:
            for _item in self.creds:
                if _item:
                    _items.append(_item.to_dict())
            _dict['creds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in languages (list)
        _items = []
        if self.languages:
            for _item in self.languages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['languages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in skills (list)
        _items = []
        if self.skills:
            for _item in self.skills:
                if _item:
                    _items.append(_item.to_dict())
            _dict['skills'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Person:
        """Create an instance of Person from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Person.parse_obj(obj)

        _obj = Person.parse_obj({
            "id": obj.get("id"),
            "url": obj.get("url"),
            "name": obj.get("name"),
            "image": Image.from_dict(obj.get("image")) if obj.get("image") is not None else None,
            "age": obj.get("age"),
            "dob": obj.get("dob"),
            "gender": obj.get("gender"),
            "creds": [Credential.from_dict(_item) for _item in obj.get("creds")] if obj.get("creds") is not None else None,
            "languages": [Language.from_dict(_item) for _item in obj.get("languages")] if obj.get("languages") is not None else None,
            "skills": [Skill.from_dict(_item) for _item in obj.get("skills")] if obj.get("skills") is not None else None,
            "tags": [TagGroup.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


