# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from transaction.models.price import Price
from transaction.models.state import State
from transaction.models.time import Time

class RefundTerm(BaseModel):
    """
    Refund term of an item or an order  # noqa: E501
    """
    fulfillment_state: Optional[State] = Field(default=None, description="The state of fulfillment during which this term is applicable.")
    refund_eligible: Optional[StrictBool] = Field(default=None, description="Indicates if cancellation will result in a refund")
    refund_within: Optional[Time] = Field(default=None, description="Time within which refund will be processed after successful cancellation.")
    refund_amount: Optional[Price] = None
    __properties = ["fulfillment_state", "refund_eligible", "refund_within", "refund_amount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RefundTerm:
        """Create an instance of RefundTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of fulfillment_state
        if self.fulfillment_state:
            _dict['fulfillment_state'] = self.fulfillment_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refund_within
        if self.refund_within:
            _dict['refund_within'] = self.refund_within.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refund_amount
        if self.refund_amount:
            _dict['refund_amount'] = self.refund_amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RefundTerm:
        """Create an instance of RefundTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RefundTerm.parse_obj(obj)

        _obj = RefundTerm.parse_obj({
            "fulfillment_state": State.from_dict(obj.get("fulfillment_state")) if obj.get("fulfillment_state") is not None else None,
            "refund_eligible": obj.get("refund_eligible"),
            "refund_within": Time.from_dict(obj.get("refund_within")) if obj.get("refund_within") is not None else None,
            "refund_amount": Price.from_dict(obj.get("refund_amount")) if obj.get("refund_amount") is not None else None
        })
        return _obj


