# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class Region(BaseModel):
    """
    Describes an arbitrary region of space. The network policy should contain a published list of supported regions by the network.  # noqa: E501
    """
    dimensions: Optional[StrictStr] = Field(default=None, description="The number of dimensions that are used to describe any point inside that region. The most common dimensionality of a region is 2, that represents an area on a map. There are regions on the map that can be approximated to one-dimensional regions like roads, railway lines, or shipping lines. 3 dimensional regions are rarer, but are gaining popularity as flying drones are being adopted for various fulfillment services.")
    type: Optional[StrictStr] = Field(default=None, description="The type of region. This is used to specify the granularity of the region represented by this object. Various examples of two-dimensional region types are city, country, state, district, and so on. The network policy should contain a list of all possible region types supported by the network.")
    name: Optional[StrictStr] = Field(default=None, description="Name of the region as specified on the map where that region exists.")
    code: Optional[StrictStr] = Field(default=None, description="A standard code representing the region. This should be interpreted in the same way by all network participants.")
    boundary: Optional[StrictStr] = Field(default=None, description="A string representing the boundary of the region. One-dimensional regions are represented by polylines. Two-dimensional regions are represented by polygons, and three-dimensional regions can represented by polyhedra.")
    map_url: Optional[StrictStr] = Field(default=None, description="The url to the map of the region. This can be a globally recognized map or the one specified by the network policy.")
    __properties = ["dimensions", "type", "name", "code", "boundary", "map_url"]

    @validator('dimensions')
    def dimensions_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('1', '2', '3',):
            raise ValueError("must be one of enum values ('1', '2', '3')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Region:
        """Create an instance of Region from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Region:
        """Create an instance of Region from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Region.parse_obj(obj)

        _obj = Region.parse_obj({
            "dimensions": obj.get("dimensions"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "boundary": obj.get("boundary"),
            "map_url": obj.get("map_url")
        })
        return _obj


