# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from transaction.models.media_file import MediaFile
from transaction.models.state import State
from transaction.models.time import Time

class ReplacementTerm(BaseModel):
    """
    The replacement policy of an item or an order  # noqa: E501
    """
    fulfillment_state: Optional[State] = Field(default=None, description="The state of fulfillment during which this term is applicable.")
    replace_within: Optional[Time] = Field(default=None, description="Applicable only for buyer managed returns where the buyer has to replace the item before a certain date-time, failing which they will not be eligible for replacement")
    external_ref: Optional[MediaFile] = None
    __properties = ["fulfillment_state", "replace_within", "external_ref"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReplacementTerm:
        """Create an instance of ReplacementTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of fulfillment_state
        if self.fulfillment_state:
            _dict['fulfillment_state'] = self.fulfillment_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of replace_within
        if self.replace_within:
            _dict['replace_within'] = self.replace_within.to_dict()
        # override the default output from pydantic by calling `to_dict()` of external_ref
        if self.external_ref:
            _dict['external_ref'] = self.external_ref.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReplacementTerm:
        """Create an instance of ReplacementTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReplacementTerm.parse_obj(obj)

        _obj = ReplacementTerm.parse_obj({
            "fulfillment_state": State.from_dict(obj.get("fulfillment_state")) if obj.get("fulfillment_state") is not None else None,
            "replace_within": Time.from_dict(obj.get("replace_within")) if obj.get("replace_within") is not None else None,
            "external_ref": MediaFile.from_dict(obj.get("external_ref")) if obj.get("external_ref") is not None else None
        })
        return _obj


