# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.authorization import Authorization
from transaction.models.contact import Contact
from transaction.models.descriptor import Descriptor
from transaction.models.location import Location
from transaction.models.person import Person
from transaction.models.time import Time

class Stop(BaseModel):
    """
    A logical point in space and time during the fulfillment of an order.  # noqa: E501
    """
    id: Optional[StrictStr] = None
    parent_stop_id: Optional[StrictStr] = None
    location: Optional[Location] = Field(default=None, description="Location of the stop")
    type: Optional[StrictStr] = Field(default=None, description="The type of stop. Allowed values of this property can be defined by the network policy.")
    time: Optional[Time] = Field(default=None, description="Timings applicable at the stop.")
    instructions: Optional[Descriptor] = Field(default=None, description="Instructions that need to be followed at the stop")
    contact: Optional[Contact] = Field(default=None, description="Contact details of the stop")
    person: Optional[Person] = Field(default=None, description="The details of the person present at the stop")
    authorization: Optional[Authorization] = None
    __properties = ["id", "parent_stop_id", "location", "type", "time", "instructions", "contact", "person", "authorization"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Stop:
        """Create an instance of Stop from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict['time'] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instructions
        if self.instructions:
            _dict['instructions'] = self.instructions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict['person'] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorization
        if self.authorization:
            _dict['authorization'] = self.authorization.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Stop:
        """Create an instance of Stop from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Stop.parse_obj(obj)

        _obj = Stop.parse_obj({
            "id": obj.get("id"),
            "parent_stop_id": obj.get("parent_stop_id"),
            "location": Location.from_dict(obj.get("location")) if obj.get("location") is not None else None,
            "type": obj.get("type"),
            "time": Time.from_dict(obj.get("time")) if obj.get("time") is not None else None,
            "instructions": Descriptor.from_dict(obj.get("instructions")) if obj.get("instructions") is not None else None,
            "contact": Contact.from_dict(obj.get("contact")) if obj.get("contact") is not None else None,
            "person": Person.from_dict(obj.get("person")) if obj.get("person") is not None else None,
            "authorization": Authorization.from_dict(obj.get("authorization")) if obj.get("authorization") is not None else None
        })
        return _obj


