# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from transaction.models.schedule import Schedule
from transaction.models.time_range import TimeRange

class Time(BaseModel):
    """
    Describes time in its various forms. It can be a single point in time; duration; or a structured timetable of operations<br>This has properties like label, time stamp,duration,range, days, schedule  # noqa: E501
    """
    label: Optional[StrictStr] = None
    timestamp: Optional[datetime] = None
    duration: Optional[StrictStr] = Field(default=None, description="Describes duration as per ISO8601 format")
    range: Optional[TimeRange] = None
    days: Optional[StrictStr] = Field(default=None, description="comma separated values representing days of the week")
    schedule: Optional[Schedule] = None
    __properties = ["label", "timestamp", "duration", "range", "days", "schedule"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Time:
        """Create an instance of Time from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of range
        if self.range:
            _dict['range'] = self.range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Time:
        """Create an instance of Time from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Time.parse_obj(obj)

        _obj = Time.parse_obj({
            "label": obj.get("label"),
            "timestamp": obj.get("timestamp"),
            "duration": obj.get("duration"),
            "range": TimeRange.from_dict(obj.get("range")) if obj.get("range") is not None else None,
            "days": obj.get("days"),
            "schedule": Schedule.from_dict(obj.get("schedule")) if obj.get("schedule") is not None else None
        })
        return _obj


