# coding: utf-8

"""
    Beckn Protocol Core

    Beckn Core Transaction API specification

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from transaction.models.form import Form

class XInput(BaseModel):
    """
    Contains any additional or extended inputs required to confirm an order. This is typically a Form Input. Sometimes, selection of catalog elements is not enough for the BPP to confirm an order. For example, to confirm a flight ticket, the airline requires details of the passengers along with information on baggage, identity, in addition to the class of ticket. Similarly, a logistics company may require details on the nature of shipment in order to confirm the shipping. A recruiting firm may require additional details on the applicant in order to confirm a job application. For all such purposes, the BPP can choose to send this object attached to any object in the catalog that is required to be sent while placing the order. This object can typically be sent at an item level or at the order level. The item level XInput will override the Order level XInput as it indicates a special requirement of information for that particular item. Hence the BAP must render a separate form for the Item and another form at the Order level before confirmation.  # noqa: E501
    """
    form: Optional[Form] = None
    required: Optional[StrictBool] = Field(default=None, description="Indicates whether the form data is mandatorily required by the BPP to confirm the order.")
    __properties = ["form", "required"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> XInput:
        """Create an instance of XInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of form
        if self.form:
            _dict['form'] = self.form.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> XInput:
        """Create an instance of XInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return XInput.parse_obj(obj)

        _obj = XInput.parse_obj({
            "form": Form.from_dict(obj.get("form")) if obj.get("form") is not None else None,
            "required": obj.get("required")
        })
        return _obj


