from ctypes import c_uint16, c_uint32, c_uint64, c_uint8

BGFX_STATE_WRITE_G = c_uint64(0x0000000000000002).value
BGFX_STATE_WRITE_B = c_uint64(0x0000000000000004).value
BGFX_STATE_WRITE_A = c_uint64(0x0000000000000008).value
BGFX_STATE_WRITE_Z = c_uint64(0x0000004000000000).value
BGFX_STATE_WRITE_R = c_uint64(0x0000000000000001).value
BGFX_STATE_WRITE_RGB = 0 | BGFX_STATE_WRITE_R | BGFX_STATE_WRITE_G | BGFX_STATE_WRITE_B

BGFX_STATE_WRITE_MASK = (
    0 | BGFX_STATE_WRITE_RGB | BGFX_STATE_WRITE_A | BGFX_STATE_WRITE_Z
)

BGFX_STATE_DEPTH_TEST_LESS = c_uint64(0x0000000000000010).value
BGFX_STATE_DEPTH_TEST_LEQUAL = c_uint64(0x0000000000000020).value
BGFX_STATE_DEPTH_TEST_EQUAL = c_uint64(0x0000000000000030).value
BGFX_STATE_DEPTH_TEST_GEQUAL = c_uint64(0x0000000000000040).value
BGFX_STATE_DEPTH_TEST_GREATER = c_uint64(0x0000000000000050).value
BGFX_STATE_DEPTH_TEST_NOTEQUAL = c_uint64(0x0000000000000060).value
BGFX_STATE_DEPTH_TEST_NEVER = c_uint64(0x0000000000000070).value
BGFX_STATE_DEPTH_TEST_ALWAYS = c_uint64(0x00000000000).value
BGFX_STATE_DEPTH_TEST_SHIFT = 4
BGFX_STATE_DEPTH_TEST_MASK = c_uint64(0x00000000000000F0).value

BGFX_STATE_BLEND_ZERO = c_uint64(0x0000000000001000).value
BGFX_STATE_BLEND_ONE = c_uint64(0x0000000000002000).value
BGFX_STATE_BLEND_SRC_COLOR = c_uint64(0x0000000000003000).value
BGFX_STATE_BLEND_INV_SRC_COLOR = c_uint64(0x0000000000004000).value
BGFX_STATE_BLEND_SRC_ALPHA = c_uint64(0x0000000000005000).value
BGFX_STATE_BLEND_INV_SRC_ALPHA = c_uint64(0x0000000000006000).value
BGFX_STATE_BLEND_DST_ALPHA = c_uint64(0x0000000000007000).value
BGFX_STATE_BLEND_INV_DST_ALPHA = c_uint64(0x0000000000008000).value
BGFX_STATE_BLEND_DST_COLOR = c_uint64(0x0000000000009000).value
BGFX_STATE_BLEND_INV_DST_COLOR = c_uint64(0x000000000000A000).value
BGFX_STATE_BLEND_SRC_ALPHA_SAT = c_uint64(0x000000000000B000).value
BGFX_STATE_BLEND_FACTOR = c_uint64(0x000000000000C000).value
BGFX_STATE_BLEND_INV_FACTOR = c_uint64(0x000000000000D000).value
BGFX_STATE_BLEND_SHIFT = 12
BGFX_STATE_BLEND_MASK = c_uint64(0x000000000FFFF000).value

BGFX_STATE_BLEND_EQUATION_ADD = c_uint64(0x0000000000000000).value
BGFX_STATE_BLEND_EQUATION_SUB = c_uint64(0x0000000010000000).value
BGFX_STATE_BLEND_EQUATION_REVSUB = c_uint64(0x0000000020000000).value
BGFX_STATE_BLEND_EQUATION_MIN = c_uint64(0x0000000030000000).value
BGFX_STATE_BLEND_EQUATION_MAX = c_uint64(0x0000000040000000).value
BGFX_STATE_BLEND_EQUATION_SHIFT = 28
BGFX_STATE_BLEND_EQUATION_MASK = c_uint64(0x00000003F0000000).value

BGFX_STATE_CULL_CW = c_uint64(0x0000001000000000).value
BGFX_STATE_CULL_CCW = c_uint64(0x0000002000000000).value
BGFX_STATE_CULL_SHIFT = 36
BGFX_STATE_CULL_MASK = c_uint64(0x0000003000000000).value

BGFX_STATE_ALPHA_REF_SHIFT = 40
BGFX_STATE_ALPHA_REF_MASK = c_uint64(0x0000FF0000000000).value
BGFX_STATE_ALPHA_REF = lambda v: (
    (v << BGFX_STATE_ALPHA_REF_SHIFT) & BGFX_STATE_ALPHA_REF_MASK
)

BGFX_STATE_PT_TRISTRIP = c_uint64(0x0001000000000000).value
BGFX_STATE_PT_LINES = c_uint64(0x0002000000000000).value
BGFX_STATE_PT_LINESTRIP = c_uint64(0x0003000000000000).value
BGFX_STATE_PT_POINTS = c_uint64(0x0004000000000000).value
BGFX_STATE_PT_SHIFT = 48
BGFX_STATE_PT_MASK = c_uint64(0x0007000000000000).value

BGFX_STATE_POINT_SIZE_SHIFT = 52
BGFX_STATE_POINT_SIZE_MASK = c_uint64(0x00F0000000000000).value
BGFX_STATE_POINT_SIZE = lambda v: (
    (v << BGFX_STATE_POINT_SIZE_SHIFT) & BGFX_STATE_POINT_SIZE_MASK
)

BGFX_STATE_MSAA = c_uint64(0x0100000000000000).value
BGFX_STATE_LINEAA = c_uint64(0x0200000000000000).value
BGFX_STATE_CONSERVATIVE_RASTER = c_uint64(0x0400000000000000).value
BGFX_STATE_NONE = c_uint64(0x0000000000000000).value
BGFX_STATE_BLEND_INDEPENDENT = c_uint64(0x0000000400000000).value
BGFX_STATE_BLEND_ALPHA_TO_COVERAGE = c_uint64(0x0000000800000000).value
BGFX_STATE_DEFAULT = (
    0
    | BGFX_STATE_WRITE_RGB
    | BGFX_STATE_WRITE_A
    | BGFX_STATE_WRITE_Z
    | BGFX_STATE_DEPTH_TEST_LESS
    | BGFX_STATE_CULL_CW
    | BGFX_STATE_MSAA
)

BGFX_STATE_MASK = c_uint64(0xFFFFFFFFFFFFFFFF).value

BGFX_STATE_RESERVED_SHIFT = 61

BGFX_STATE_RESERVED_MASK = c_uint64(0xE000000000000000).value

BGFX_STENCIL_FUNC_REF_SHIFT = 0

BGFX_STENCIL_FUNC_REF_MASK = c_uint32(0x000000FF).value
BGFX_STENCIL_FUNC_REF = lambda v: (
    (v << BGFX_STENCIL_FUNC_REF_SHIFT) & BGFX_STENCIL_FUNC_REF_MASK
)

BGFX_STENCIL_FUNC_RMASK_SHIFT = 8

BGFX_STENCIL_FUNC_RMASK_MASK = c_uint32(0x0000FF00).value
BGFX_STENCIL_FUNC_RMASK = lambda v: (
    (v << BGFX_STENCIL_FUNC_RMASK_SHIFT) & BGFX_STENCIL_FUNC_RMASK_MASK
)

BGFX_STENCIL_NONE = c_uint32(0x00000000).value
BGFX_STENCIL_MASK = c_uint32(0xFFFFFFFF).value
BGFX_STENCIL_DEFAULT = c_uint32(0x00000000).value

BGFX_STENCIL_TEST_LESS = c_uint32(0x00010000).value
BGFX_STENCIL_TEST_LEQUAL = c_uint32(0x00020000).value
BGFX_STENCIL_TEST_EQUAL = c_uint32(0x00030000).value
BGFX_STENCIL_TEST_GEQUAL = c_uint32(0x00040000).value
BGFX_STENCIL_TEST_GREATER = c_uint32(0x00050000).value
BGFX_STENCIL_TEST_NOTEQUAL = c_uint32(0x00060000).value
BGFX_STENCIL_TEST_NEVER = c_uint32(0x00070000).value
BGFX_STENCIL_TEST_ALWAYS = c_uint32(0x00080000).value
BGFX_STENCIL_TEST_SHIFT = 16
BGFX_STENCIL_TEST_MASK = c_uint32(0x000F0000).value

BGFX_STENCIL_OP_FAIL_S_ZERO = c_uint32(0x00000000).value
BGFX_STENCIL_OP_FAIL_S_KEEP = c_uint32(0x00100000).value
BGFX_STENCIL_OP_FAIL_S_REPLACE = c_uint32(0x00200000).value
BGFX_STENCIL_OP_FAIL_S_INCR = c_uint32(0x00300000).value
BGFX_STENCIL_OP_FAIL_S_INCRSAT = c_uint32(0x00400000).value
BGFX_STENCIL_OP_FAIL_S_DECR = c_uint32(0x00500000).value
BGFX_STENCIL_OP_FAIL_S_DECRSAT = c_uint32(0x00600000).value
BGFX_STENCIL_OP_FAIL_S_INVERT = c_uint32(0x00700000).value
BGFX_STENCIL_OP_FAIL_S_SHIFT = 20
BGFX_STENCIL_OP_FAIL_S_MASK = c_uint32(0x00F00000).value

BGFX_STENCIL_OP_FAIL_Z_ZERO = c_uint32(0x00000000).value
BGFX_STENCIL_OP_FAIL_Z_KEEP = c_uint32(0x01000000).value
BGFX_STENCIL_OP_FAIL_Z_REPLACE = c_uint32(0x02000000).value
BGFX_STENCIL_OP_FAIL_Z_INCR = c_uint32(0x03000000).value
BGFX_STENCIL_OP_FAIL_Z_INCRSAT = c_uint32(0x04000000).value
BGFX_STENCIL_OP_FAIL_Z_DECR = c_uint32(0x05000000).value
BGFX_STENCIL_OP_FAIL_Z_DECRSAT = c_uint32(0x06000000).value
BGFX_STENCIL_OP_FAIL_Z_INVERT = c_uint32(0x07000000).value
BGFX_STENCIL_OP_FAIL_Z_SHIFT = 24
BGFX_STENCIL_OP_FAIL_Z_MASK = c_uint32(0x0F000000).value

BGFX_STENCIL_OP_PASS_Z_ZERO = c_uint32(0x00000000).value
BGFX_STENCIL_OP_PASS_Z_KEEP = c_uint32(0x10000000).value
BGFX_STENCIL_OP_PASS_Z_REPLACE = c_uint32(0x20000000).value
BGFX_STENCIL_OP_PASS_Z_INCR = c_uint32(0x30000000).value
BGFX_STENCIL_OP_PASS_Z_INCRSAT = c_uint32(0x40000000).value
BGFX_STENCIL_OP_PASS_Z_DECR = c_uint32(0x50000000).value
BGFX_STENCIL_OP_PASS_Z_DECRSAT = c_uint32(0x60000000).value
BGFX_STENCIL_OP_PASS_Z_INVERT = c_uint32(0x70000000).value
BGFX_STENCIL_OP_PASS_Z_SHIFT = 28
BGFX_STENCIL_OP_PASS_Z_MASK = c_uint32(0xF0000000).value

BGFX_CLEAR_NONE = c_uint16(0x0000).value
BGFX_CLEAR_COLOR = c_uint16(0x0001).value
BGFX_CLEAR_DEPTH = c_uint16(0x0002).value
BGFX_CLEAR_STENCIL = c_uint16(0x0004).value
BGFX_CLEAR_DISCARD_COLOR_0 = c_uint16(0x0008).value
BGFX_CLEAR_DISCARD_COLOR_1 = c_uint16(0x0010).value
BGFX_CLEAR_DISCARD_COLOR_2 = c_uint16(0x0020).value
BGFX_CLEAR_DISCARD_COLOR_3 = c_uint16(0x0040).value
BGFX_CLEAR_DISCARD_COLOR_4 = c_uint16(0x0080).value
BGFX_CLEAR_DISCARD_COLOR_5 = c_uint16(0x0100).value
BGFX_CLEAR_DISCARD_COLOR_6 = c_uint16(0x0200).value
BGFX_CLEAR_DISCARD_COLOR_7 = c_uint16(0x0400).value
BGFX_CLEAR_DISCARD_DEPTH = c_uint16(0x0800).value
BGFX_CLEAR_DISCARD_STENCIL = c_uint16(0x1000).value
BGFX_CLEAR_DISCARD_COLOR_MASK = (
    0
    | BGFX_CLEAR_DISCARD_COLOR_0
    | BGFX_CLEAR_DISCARD_COLOR_1
    | BGFX_CLEAR_DISCARD_COLOR_2
    | BGFX_CLEAR_DISCARD_COLOR_3
    | BGFX_CLEAR_DISCARD_COLOR_4
    | BGFX_CLEAR_DISCARD_COLOR_5
    | BGFX_CLEAR_DISCARD_COLOR_6
    | BGFX_CLEAR_DISCARD_COLOR_7
)

BGFX_CLEAR_DISCARD_MASK = (
    0
    | BGFX_CLEAR_DISCARD_COLOR_MASK
    | BGFX_CLEAR_DISCARD_DEPTH
    | BGFX_CLEAR_DISCARD_STENCIL
)

BGFX_DEBUG_NONE = c_uint32(0x00000000).value
BGFX_DEBUG_WIREFRAME = c_uint32(0x00000001).value
BGFX_DEBUG_IFH = c_uint32(0x00000002).value
BGFX_DEBUG_STATS = c_uint32(0x00000004).value
BGFX_DEBUG_TEXT = c_uint32(0x00000008).value
BGFX_DEBUG_PROFILER = c_uint32(0x00000010).value

BGFX_BUFFER_COMPUTE_FORMAT_8X1 = c_uint16(0x0001).value
BGFX_BUFFER_COMPUTE_FORMAT_8X2 = c_uint16(0x0002).value
BGFX_BUFFER_COMPUTE_FORMAT_8X4 = c_uint16(0x0003).value
BGFX_BUFFER_COMPUTE_FORMAT_16X1 = c_uint16(0x0004).value
BGFX_BUFFER_COMPUTE_FORMAT_16X2 = c_uint16(0x0005).value
BGFX_BUFFER_COMPUTE_FORMAT_16X4 = c_uint16(0x0006).value
BGFX_BUFFER_COMPUTE_FORMAT_32X1 = c_uint16(0x0007).value
BGFX_BUFFER_COMPUTE_FORMAT_32X2 = c_uint16(0x0008).value
BGFX_BUFFER_COMPUTE_FORMAT_32X4 = c_uint16(0x0009).value
BGFX_BUFFER_COMPUTE_FORMAT_SHIFT = 0

BGFX_BUFFER_COMPUTE_FORMAT_MASK = c_uint16(0x000F).value

BGFX_BUFFER_COMPUTE_TYPE_INT = c_uint16(0x0010).value
BGFX_BUFFER_COMPUTE_TYPE_UINT = c_uint16(0x0020).value
BGFX_BUFFER_COMPUTE_TYPE_FLOAT = c_uint16(0x0030).value
BGFX_BUFFER_COMPUTE_TYPE_SHIFT = 4

BGFX_BUFFER_COMPUTE_TYPE_MASK = c_uint16(0x0030).value

BGFX_BUFFER_NONE = c_uint16(0x0000).value
BGFX_BUFFER_COMPUTE_READ = c_uint16(0x0100).value
BGFX_BUFFER_COMPUTE_WRITE = c_uint16(0x0200).value
BGFX_BUFFER_DRAW_INDIRECT = c_uint16(0x0400).value
BGFX_BUFFER_ALLOW_RESIZE = c_uint16(0x0800).value
BGFX_BUFFER_INDEX32 = c_uint16(0x1000).value
BGFX_BUFFER_COMPUTE_READ_WRITE = (
    0 | BGFX_BUFFER_COMPUTE_READ | BGFX_BUFFER_COMPUTE_WRITE
)

BGFX_TEXTURE_NONE = c_uint64(0x0000000000000000).value
BGFX_TEXTURE_MSAA_SAMPLE = c_uint64(0x0000000800000000).value
BGFX_TEXTURE_RT = c_uint64(0x0000001000000000).value
BGFX_TEXTURE_COMPUTE_WRITE = c_uint64(0x0000100000000000).value
BGFX_TEXTURE_SRGB = c_uint64(0x0000200000000000).value
BGFX_TEXTURE_BLIT_DST = c_uint64(0x0000400000000000).value
BGFX_TEXTURE_READ_BACK = c_uint64(0x0000800000000000).value

BGFX_TEXTURE_RT_MSAA_X2 = c_uint64(0x0000002000000000).value
BGFX_TEXTURE_RT_MSAA_X4 = c_uint64(0x0000003000000000).value
BGFX_TEXTURE_RT_MSAA_X8 = c_uint64(0x0000004000000000).value
BGFX_TEXTURE_RT_MSAA_X16 = c_uint64(0x0000005000000000).value
BGFX_TEXTURE_RT_MSAA_SHIFT = 36

BGFX_TEXTURE_RT_MSAA_MASK = c_uint64(0x0000007000000000).value

BGFX_TEXTURE_RT_WRITE_ONLY = c_uint64(0x0000008000000000).value
BGFX_TEXTURE_RT_SHIFT = 36

BGFX_TEXTURE_RT_MASK = c_uint64(0x000000F000000000).value

BGFX_SAMPLER_U_MIRROR = c_uint32(0x00000001).value
BGFX_SAMPLER_U_CLAMP = c_uint32(0x00000002).value
BGFX_SAMPLER_U_BORDER = c_uint32(0x00000003).value
BGFX_SAMPLER_U_SHIFT = 0

BGFX_SAMPLER_U_MASK = c_uint32(0x00000003).value

BGFX_SAMPLER_V_MIRROR = c_uint32(0x00000004).value
BGFX_SAMPLER_V_CLAMP = c_uint32(0x00000008).value
BGFX_SAMPLER_V_BORDER = c_uint32(0x0000000C).value
BGFX_SAMPLER_V_SHIFT = 2

BGFX_SAMPLER_V_MASK = c_uint32(0x0000000C).value

BGFX_SAMPLER_W_MIRROR = c_uint32(0x00000010).value
BGFX_SAMPLER_W_CLAMP = c_uint32(0x00000020).value
BGFX_SAMPLER_W_BORDER = c_uint32(0x00000030).value
BGFX_SAMPLER_W_SHIFT = 4

BGFX_SAMPLER_W_MASK = c_uint32(0x00000030).value

BGFX_SAMPLER_MIN_POINT = c_uint32(0x00000040).value
BGFX_SAMPLER_MIN_ANISOTROPIC = c_uint32(0x00000080).value
BGFX_SAMPLER_MIN_SHIFT = 6

BGFX_SAMPLER_MIN_MASK = c_uint32(0x000000C0).value

BGFX_SAMPLER_MAG_POINT = c_uint32(0x00000100).value
BGFX_SAMPLER_MAG_ANISOTROPIC = c_uint32(0x00000200).value
BGFX_SAMPLER_MAG_SHIFT = 8

BGFX_SAMPLER_MAG_MASK = c_uint32(0x00000300).value

BGFX_SAMPLER_MIP_POINT = c_uint32(0x00000400).value
BGFX_SAMPLER_MIP_SHIFT = 10

BGFX_SAMPLER_MIP_MASK = c_uint32(0x00000400).value

BGFX_SAMPLER_COMPARE_LESS = c_uint32(0x00010000).value
BGFX_SAMPLER_COMPARE_LEQUAL = c_uint32(0x00020000).value
BGFX_SAMPLER_COMPARE_EQUAL = c_uint32(0x00030000).value
BGFX_SAMPLER_COMPARE_GEQUAL = c_uint32(0x00040000).value
BGFX_SAMPLER_COMPARE_GREATER = c_uint32(0x00050000).value
BGFX_SAMPLER_COMPARE_NOTEQUAL = c_uint32(0x00060000).value
BGFX_SAMPLER_COMPARE_NEVER = c_uint32(0x00070000).value
BGFX_SAMPLER_COMPARE_ALWAYS = c_uint32(0x00080000).value
BGFX_SAMPLER_COMPARE_SHIFT = 16

BGFX_SAMPLER_COMPARE_MASK = c_uint32(0x000F0000).value

BGFX_SAMPLER_BORDER_COLOR_SHIFT = 24

BGFX_SAMPLER_BORDER_COLOR_MASK = c_uint32(0x0F000000).value
BGFX_SAMPLER_BORDER_COLOR = lambda v: (
    c_uint32(v << BGFX_SAMPLER_BORDER_COLOR_SHIFT).value
    & BGFX_SAMPLER_BORDER_COLOR_MASK
)

BGFX_SAMPLER_RESERVED_SHIFT = 28

BGFX_SAMPLER_RESERVED_MASK = c_uint32(0xF0000000).value

BGFX_SAMPLER_NONE = c_uint32(0x00000000).value
BGFX_SAMPLER_SAMPLE_STENCIL = c_uint32(0x00100000).value
BGFX_SAMPLER_POINT = (
    0 | BGFX_SAMPLER_MIN_POINT | BGFX_SAMPLER_MAG_POINT | BGFX_SAMPLER_MIP_POINT
)

BGFX_SAMPLER_UVW_MIRROR = (
    0 | BGFX_SAMPLER_U_MIRROR | BGFX_SAMPLER_V_MIRROR | BGFX_SAMPLER_W_MIRROR
)

BGFX_SAMPLER_UVW_CLAMP = (
    0 | BGFX_SAMPLER_U_CLAMP | BGFX_SAMPLER_V_CLAMP | BGFX_SAMPLER_W_CLAMP
)

BGFX_SAMPLER_UVW_BORDER = (
    0 | BGFX_SAMPLER_U_BORDER | BGFX_SAMPLER_V_BORDER | BGFX_SAMPLER_W_BORDER
)

BGFX_SAMPLER_BITS_MASK = (
    0
    | BGFX_SAMPLER_U_MASK
    | BGFX_SAMPLER_V_MASK
    | BGFX_SAMPLER_W_MASK
    | BGFX_SAMPLER_MIN_MASK
    | BGFX_SAMPLER_MAG_MASK
    | BGFX_SAMPLER_MIP_MASK
    | BGFX_SAMPLER_COMPARE_MASK
)

BGFX_RESET_MSAA_X2 = c_uint32(0x00000010).value
BGFX_RESET_MSAA_X4 = c_uint32(0x00000020).value
BGFX_RESET_MSAA_X8 = c_uint32(0x00000030).value
BGFX_RESET_MSAA_X16 = c_uint32(0x00000040).value
BGFX_RESET_MSAA_SHIFT = 4

BGFX_RESET_MSAA_MASK = c_uint32(0x00000070).value

BGFX_RESET_NONE = c_uint32(0x00000000).value
BGFX_RESET_FULLSCREEN = c_uint32(0x00000001).value
BGFX_RESET_VSYNC = c_uint32(0x00000080).value
BGFX_RESET_MAXANISOTROPY = c_uint32(0x00000100).value
BGFX_RESET_CAPTURE = c_uint32(0x00000200).value
BGFX_RESET_FLUSH_AFTER_RENDER = c_uint32(0x00002000).value

BGFX_RESET_FLIP_AFTER_RENDER = c_uint32(0x00004000).value
BGFX_RESET_SRGB_BACKBUFFER = c_uint32(0x00008000).value
BGFX_RESET_HDR10 = c_uint32(0x00010000).value
BGFX_RESET_HIDPI = c_uint32(0x00020000).value
BGFX_RESET_DEPTH_CLAMP = c_uint32(0x00040000).value
BGFX_RESET_SUSPEND = c_uint32(0x00080000).value

BGFX_RESET_FULLSCREEN_SHIFT = 0

BGFX_RESET_FULLSCREEN_MASK = c_uint32(0x00000001).value

BGFX_RESET_RESERVED_SHIFT = 31
BGFX_RESET_RESERVED_MASK = c_uint32(0x80000000).value

BGFX_CAPS_ALPHA_TO_COVERAGE = c_uint64(0x0000000000000001).value
BGFX_CAPS_BLEND_INDEPENDENT = c_uint64(0x0000000000000002).value
BGFX_CAPS_COMPUTE = c_uint64(0x0000000000000004).value
BGFX_CAPS_CONSERVATIVE_RASTER = c_uint64(0x0000000000000008).value
BGFX_CAPS_DRAW_INDIRECT = c_uint64(0x0000000000000010).value
BGFX_CAPS_FRAGMENT_DEPTH = c_uint64(0x0000000000000020).value
BGFX_CAPS_FRAGMENT_ORDERING = c_uint64(0x0000000000000040).value
BGFX_CAPS_FRAMEBUFFER_RW = c_uint64(0x0000000000000080).value
BGFX_CAPS_GRAPHICS_DEBUGGER = c_uint64(0x0000000000000100).value
BGFX_CAPS_RESERVED = c_uint64(0x0000000000000200).value
BGFX_CAPS_HDR10 = c_uint64(0x0000000000000400).value
BGFX_CAPS_HIDPI = c_uint64(0x0000000000000800).value
BGFX_CAPS_INDEX32 = c_uint64(0x0000000000001000).value
BGFX_CAPS_INSTANCING = c_uint64(0x0000000000002000).value
BGFX_CAPS_OCCLUSION_QUERY = c_uint64(0x0000000000004000).value
BGFX_CAPS_RENDERER_MULTITHREADED = c_uint64(0x0000000000008000).value
BGFX_CAPS_SWAP_CHAIN = c_uint64(0x0000000000010000).value
BGFX_CAPS_TEXTURE_2D_ARRAY = c_uint64(0x0000000000020000).value
BGFX_CAPS_TEXTURE_3D = c_uint64(0x0000000000040000).value
BGFX_CAPS_TEXTURE_BLIT = c_uint64(0x0000000000080000).value
BGFX_CAPS_TEXTURE_COMPARE_RESERVED = c_uint64(0x0000000000100000).value
BGFX_CAPS_TEXTURE_COMPARE_LEQUAL = c_uint64(0x0000000000200000).value
BGFX_CAPS_TEXTURE_CUBE_ARRAY = c_uint64(0x0000000000400000).value
BGFX_CAPS_TEXTURE_DIRECT_ACCESS = c_uint64(0x0000000000800000).value
BGFX_CAPS_TEXTURE_READ_BACK = c_uint64(0x0000000001000000).value
BGFX_CAPS_VERTEX_ATTRIB_HALF = c_uint64(0x0000000002000000).value
BGFX_CAPS_VERTEX_ATTRIB_UINT10 = c_uint64(0x0000000004000000).value
BGFX_CAPS_VERTEX_ID = c_uint64(0x0000000008000000).value

BGFX_CAPS_TEXTURE_COMPARE_ALL = (
    0 | BGFX_CAPS_TEXTURE_COMPARE_RESERVED | BGFX_CAPS_TEXTURE_COMPARE_LEQUAL
)

BGFX_CAPS_FORMAT_TEXTURE_NONE = c_uint16(0x0000).value
BGFX_CAPS_FORMAT_TEXTURE_2D = c_uint16(0x0001).value
BGFX_CAPS_FORMAT_TEXTURE_2D_SRGB = c_uint16(0x0002).value
BGFX_CAPS_FORMAT_TEXTURE_2D_EMULATED = c_uint16(0x0004).value
BGFX_CAPS_FORMAT_TEXTURE_3D = c_uint16(0x0008).value
BGFX_CAPS_FORMAT_TEXTURE_3D_SRGB = c_uint16(0x0010).value
BGFX_CAPS_FORMAT_TEXTURE_3D_EMULATED = c_uint16(0x0020).value
BGFX_CAPS_FORMAT_TEXTURE_CUBE = c_uint16(0x0040).value
BGFX_CAPS_FORMAT_TEXTURE_CUBE_SRGB = c_uint16(0x0080).value
BGFX_CAPS_FORMAT_TEXTURE_CUBE_EMULATED = c_uint16(0x0100).value
BGFX_CAPS_FORMAT_TEXTURE_VERTEX = c_uint16(0x0200).value
BGFX_CAPS_FORMAT_TEXTURE_IMAGE = c_uint16(0x0400).value
BGFX_CAPS_FORMAT_TEXTURE_FRAMEBUFFER = c_uint16(0x0800).value
BGFX_CAPS_FORMAT_TEXTURE_FRAMEBUFFER_MSAA = c_uint16(0x1000).value
BGFX_CAPS_FORMAT_TEXTURE_MSAA = c_uint16(0x2000).value
BGFX_CAPS_FORMAT_TEXTURE_MIP_AUTOGEN = c_uint16(0x4000).value

BGFX_RESOLVE_NONE = c_uint8(0x00)
BGFX_RESOLVE_AUTO_GEN_MIPS = c_uint8(0x01)

BGFX_PCI_ID_NONE = c_uint16(0x0000).value
BGFX_PCI_ID_SOFTWARE_RASTERIZER = c_uint16(0x0001).value
BGFX_PCI_ID_AMD = c_uint16(0x1002).value
BGFX_PCI_ID_INTEL = c_uint16(0x8086).value
BGFX_PCI_ID_NVIDIA = c_uint16(0x10DE).value

BGFX_CUBE_MAP_POSITIVE_X = c_uint8(0x00)
BGFX_CUBE_MAP_NEGATIVE_X = c_uint8(0x01)
BGFX_CUBE_MAP_POSITIVE_Y = c_uint8(0x02)
BGFX_CUBE_MAP_NEGATIVE_Y = c_uint8(0x03)
BGFX_CUBE_MAP_POSITIVE_Z = c_uint8(0x04)
BGFX_CUBE_MAP_NEGATIVE_Z = c_uint8(0x05)

BGFX_STATE_BLEND_FUNC_SEPARATE = lambda _srcRGB, _dstRGB, _srcA, _dstA: (
    0 | (_srcRGB | (_dstRGB << 4)) | (_srcA | (_dstA << 4) << 8)
)
BGFX_STATE_BLEND_EQUATION_SEPARATE = lambda _equationRGB, _equationA: (
    _equationRGB | _equationA << 3
)
BGFX_STATE_BLEND_FUNC = lambda _src, _dst: BGFX_STATE_BLEND_FUNC_SEPARATE(
    _src, _dst, _src, _dst
)
BGFX_STATE_BLEND_EQUATION = lambda _equation: BGFX_STATE_BLEND_EQUATION_SEPARATE(
    _equation, _equation
)

BGFX_STATE_BLEND_ADD = 0 | BGFX_STATE_BLEND_FUNC(
    BGFX_STATE_BLEND_ONE, BGFX_STATE_BLEND_ONE
)

BGFX_STATE_BLEND_ALPHA = 0 | BGFX_STATE_BLEND_FUNC(
    BGFX_STATE_BLEND_SRC_ALPHA, BGFX_STATE_BLEND_INV_SRC_ALPHA
)

BGFX_STATE_BLEND_DARKEN = (
    0
    | BGFX_STATE_BLEND_FUNC(BGFX_STATE_BLEND_ONE, BGFX_STATE_BLEND_ONE)
    | BGFX_STATE_BLEND_EQUATION(BGFX_STATE_BLEND_EQUATION_MIN)
)

BGFX_STATE_BLEND_LIGHTEN = (
    0
    | BGFX_STATE_BLEND_FUNC(BGFX_STATE_BLEND_ONE, BGFX_STATE_BLEND_ONE)
    | BGFX_STATE_BLEND_EQUATION(BGFX_STATE_BLEND_EQUATION_MAX)
)

BGFX_STATE_BLEND_MULTIPLY = 0 | BGFX_STATE_BLEND_FUNC(
    BGFX_STATE_BLEND_DST_COLOR, BGFX_STATE_BLEND_ZERO
)

BGFX_STATE_BLEND_NORMAL = 0 | BGFX_STATE_BLEND_FUNC(
    BGFX_STATE_BLEND_ONE, BGFX_STATE_BLEND_INV_SRC_ALPHA
)

BGFX_STATE_BLEND_SCREEN = 0 | BGFX_STATE_BLEND_FUNC(
    BGFX_STATE_BLEND_ONE, BGFX_STATE_BLEND_INV_SRC_COLOR
)

BGFX_STATE_BLEND_LINEAR_BURN = (
    0
    | BGFX_STATE_BLEND_FUNC(BGFX_STATE_BLEND_DST_COLOR, BGFX_STATE_BLEND_INV_DST_COLOR)
    | BGFX_STATE_BLEND_EQUATION(BGFX_STATE_BLEND_EQUATION_SUB)
)

BGFX_STATE_BLEND_FUNC_RT_x = lambda _src, _dst: 0 | (
    ((_src) >> BGFX_STATE_BLEND_SHIFT) | (((_dst) >> BGFX_STATE_BLEND_SHIFT) << 4)
)

BGFX_STATE_BLEND_FUNC_RT_xE = (
    lambda _src, _dst, _equation: 0
    | BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst)
    | (((_equation) >> BGFX_STATE_BLEND_EQUATION_SHIFT) << 8)
)

BGFX_STATE_BLEND_FUNC_RT_1 = lambda _src, _dst: (
    BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 0
)
BGFX_STATE_BLEND_FUNC_RT_2 = lambda _src, _dst: (
    BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 11
)
BGFX_STATE_BLEND_FUNC_RT_3 = lambda _src, _dst: (
    BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 22
)

BGFX_STATE_BLEND_FUNC_RT_1E = lambda _src, _dst, _equation: (
    BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 0
)
BGFX_STATE_BLEND_FUNC_RT_2E = lambda _src, _dst, _equation: (
    BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 11
)
BGFX_STATE_BLEND_FUNC_RT_3E = lambda _src, _dst, _equation: (
    BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 22
)
