# coding: utf-8

"""
    BIMData API

    BIMData API documentation  # noqa: E501

    OpenAPI spec version: v1
    Contact: contact@bimdata.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bimdata_api_client.api_client import ApiClient


class CheckplanApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_checker(self, cloud_pk, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """create_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_checker(cloud_pk, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_checker_with_http_info(cloud_pk, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
        else:
            (data) = self.create_checker_with_http_info(cloud_pk, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
            return data

    def create_checker_with_http_info(self, cloud_pk, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """create_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_checker_with_http_info(cloud_pk, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'ifc_checker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_checker" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_checker`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_checker`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_checker`")  # noqa: E501
        # verify the required parameter 'ifc_checker' is set
        if ('ifc_checker' not in local_var_params or
                local_var_params['ifc_checker'] is None):
            raise ValueError("Missing the required parameter `ifc_checker` when calling `create_checker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ifc_checker' in local_var_params:
            body_params = local_var_params['ifc_checker']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IfcChecker',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_checker_result(self, checker_pk, cloud_pk, ifc_pk, project_pk, checker_result, **kwargs):  # noqa: E501
        """create_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_checker_result(checker_pk, cloud_pk, ifc_pk, project_pk, checker_result, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param CheckerResult checker_result: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_checker_result_with_http_info(checker_pk, cloud_pk, ifc_pk, project_pk, checker_result, **kwargs)  # noqa: E501
        else:
            (data) = self.create_checker_result_with_http_info(checker_pk, cloud_pk, ifc_pk, project_pk, checker_result, **kwargs)  # noqa: E501
            return data

    def create_checker_result_with_http_info(self, checker_pk, cloud_pk, ifc_pk, project_pk, checker_result, **kwargs):  # noqa: E501
        """create_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_checker_result_with_http_info(checker_pk, cloud_pk, ifc_pk, project_pk, checker_result, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param CheckerResult checker_result: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['checker_pk', 'cloud_pk', 'ifc_pk', 'project_pk', 'checker_result']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_checker_result" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'checker_pk' is set
        if ('checker_pk' not in local_var_params or
                local_var_params['checker_pk'] is None):
            raise ValueError("Missing the required parameter `checker_pk` when calling `create_checker_result`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_checker_result`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_checker_result`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_checker_result`")  # noqa: E501
        # verify the required parameter 'checker_result' is set
        if ('checker_result' not in local_var_params or
                local_var_params['checker_result'] is None):
            raise ValueError("Missing the required parameter `checker_result` when calling `create_checker_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checker_pk' in local_var_params:
            path_params['checker_pk'] = local_var_params['checker_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'checker_result' in local_var_params:
            body_params = local_var_params['checker_result']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{checker_pk}/result', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckerResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_checkplan(self, cloud_pk, project_pk, check_plan, **kwargs):  # noqa: E501
        """create_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_checkplan(cloud_pk, project_pk, check_plan, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param CheckPlan check_plan: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_checkplan_with_http_info(cloud_pk, project_pk, check_plan, **kwargs)  # noqa: E501
        else:
            (data) = self.create_checkplan_with_http_info(cloud_pk, project_pk, check_plan, **kwargs)  # noqa: E501
            return data

    def create_checkplan_with_http_info(self, cloud_pk, project_pk, check_plan, **kwargs):  # noqa: E501
        """create_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_checkplan_with_http_info(cloud_pk, project_pk, check_plan, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param CheckPlan check_plan: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk', 'check_plan']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_checkplan" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_checkplan`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_checkplan`")  # noqa: E501
        # verify the required parameter 'check_plan' is set
        if ('check_plan' not in local_var_params or
                local_var_params['check_plan'] is None):
            raise ValueError("Missing the required parameter `check_plan` when calling `create_checkplan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'check_plan' in local_var_params:
            body_params = local_var_params['check_plan']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckPlan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_rule(self, check_plan_pk, cloud_pk, project_pk, ruleset_pk, rule, **kwargs):  # noqa: E501
        """create_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_rule(check_plan_pk, cloud_pk, project_pk, ruleset_pk, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :param Rule rule: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_rule_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset_pk, rule, **kwargs)  # noqa: E501
        else:
            (data) = self.create_rule_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset_pk, rule, **kwargs)  # noqa: E501
            return data

    def create_rule_with_http_info(self, check_plan_pk, cloud_pk, project_pk, ruleset_pk, rule, **kwargs):  # noqa: E501
        """create_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_rule_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset_pk, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :param Rule rule: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'project_pk', 'ruleset_pk', 'rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `create_rule`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_rule`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_rule`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `create_rule`")  # noqa: E501
        # verify the required parameter 'rule' is set
        if ('rule' not in local_var_params or
                local_var_params['rule'] is None):
            raise ValueError("Missing the required parameter `rule` when calling `create_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule' in local_var_params:
            body_params = local_var_params['rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Rule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_rule_component(self, check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs):  # noqa: E501
        """create_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_rule_component(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, rule_component, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :param RuleComponent rule_component: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_rule_component_with_http_info(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs)  # noqa: E501
        else:
            (data) = self.create_rule_component_with_http_info(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs)  # noqa: E501
            return data

    def create_rule_component_with_http_info(self, check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs):  # noqa: E501
        """create_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_rule_component_with_http_info(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, rule_component, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :param RuleComponent rule_component: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'project_pk', 'rule_pk', 'ruleset_pk', 'rule_component']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_rule_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `create_rule_component`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_rule_component`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_pk' is set
        if ('rule_pk' not in local_var_params or
                local_var_params['rule_pk'] is None):
            raise ValueError("Missing the required parameter `rule_pk` when calling `create_rule_component`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `create_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_component' is set
        if ('rule_component' not in local_var_params or
                local_var_params['rule_component'] is None):
            raise ValueError("Missing the required parameter `rule_component` when calling `create_rule_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'rule_pk' in local_var_params:
            path_params['rule_pk'] = local_var_params['rule_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_component' in local_var_params:
            body_params = local_var_params['rule_component']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{rule_pk}/rulecomponent', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleComponent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ruleset(self, check_plan_pk, cloud_pk, project_pk, ruleset, **kwargs):  # noqa: E501
        """create_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ruleset(check_plan_pk, cloud_pk, project_pk, ruleset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param Ruleset ruleset: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ruleset_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ruleset_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset, **kwargs)  # noqa: E501
            return data

    def create_ruleset_with_http_info(self, check_plan_pk, cloud_pk, project_pk, ruleset, **kwargs):  # noqa: E501
        """create_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ruleset_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param Ruleset ruleset: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'project_pk', 'ruleset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ruleset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `create_ruleset`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_ruleset`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_ruleset`")  # noqa: E501
        # verify the required parameter 'ruleset' is set
        if ('ruleset' not in local_var_params or
                local_var_params['ruleset'] is None):
            raise ValueError("Missing the required parameter `ruleset` when calling `create_ruleset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ruleset' in local_var_params:
            body_params = local_var_params['ruleset']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ruleset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_checker(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checker(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_checker_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_checker" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_checker`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_checker`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_checker`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_checker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_checker_result(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checker_result(checker_pk, cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_checker_result_with_http_info(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['checker_pk', 'cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_checker_result" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'checker_pk' is set
        if ('checker_pk' not in local_var_params or
                local_var_params['checker_pk'] is None):
            raise ValueError("Missing the required parameter `checker_pk` when calling `delete_checker_result`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_checker_result`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_checker_result`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_checker_result`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_checker_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checker_pk' in local_var_params:
            path_params['checker_pk'] = local_var_params['checker_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{checker_pk}/result/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_checkplan(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checkplan(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_checkplan_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_checkplan_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_checkplan_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checkplan_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_checkplan" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_checkplan`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_checkplan`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_checkplan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_rule(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs):  # noqa: E501
        """delete_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs)  # noqa: E501
            return data

    def delete_rule_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs):  # noqa: E501
        """delete_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'ruleset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `delete_rule`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_rule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_rule`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_rule`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `delete_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_rule_component(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs):  # noqa: E501
        """delete_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_component(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs)  # noqa: E501
            return data

    def delete_rule_component_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs):  # noqa: E501
        """delete_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'rule_pk', 'ruleset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_rule_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `delete_rule_component`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_rule_component`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_rule_component`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_pk' is set
        if ('rule_pk' not in local_var_params or
                local_var_params['rule_pk'] is None):
            raise ValueError("Missing the required parameter `rule_pk` when calling `delete_rule_component`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `delete_rule_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'rule_pk' in local_var_params:
            path_params['rule_pk'] = local_var_params['rule_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{rule_pk}/rulecomponent/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ruleset(self, check_plan_pk, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ruleset(check_plan_pk, cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_ruleset_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ruleset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `delete_ruleset`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_ruleset`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_ruleset`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_ruleset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_checker(self, cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """full_update_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_checker(cloud_pk, id, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
            return data

    def full_update_checker_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """full_update_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'ifc_checker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_checker" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_checker`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_checker`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_checker`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_checker`")  # noqa: E501
        # verify the required parameter 'ifc_checker' is set
        if ('ifc_checker' not in local_var_params or
                local_var_params['ifc_checker'] is None):
            raise ValueError("Missing the required parameter `ifc_checker` when calling `full_update_checker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ifc_checker' in local_var_params:
            body_params = local_var_params['ifc_checker']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IfcChecker',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_checker_result(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs):  # noqa: E501
        """full_update_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_checker_result(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param CheckerResult checker_result: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs)  # noqa: E501
            return data

    def full_update_checker_result_with_http_info(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs):  # noqa: E501
        """full_update_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param CheckerResult checker_result: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['checker_pk', 'cloud_pk', 'id', 'ifc_pk', 'project_pk', 'checker_result']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_checker_result" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'checker_pk' is set
        if ('checker_pk' not in local_var_params or
                local_var_params['checker_pk'] is None):
            raise ValueError("Missing the required parameter `checker_pk` when calling `full_update_checker_result`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_checker_result`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_checker_result`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_checker_result`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_checker_result`")  # noqa: E501
        # verify the required parameter 'checker_result' is set
        if ('checker_result' not in local_var_params or
                local_var_params['checker_result'] is None):
            raise ValueError("Missing the required parameter `checker_result` when calling `full_update_checker_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checker_pk' in local_var_params:
            path_params['checker_pk'] = local_var_params['checker_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'checker_result' in local_var_params:
            body_params = local_var_params['checker_result']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{checker_pk}/result/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckerResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_checkplan(self, cloud_pk, id, project_pk, check_plan, **kwargs):  # noqa: E501
        """full_update_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_checkplan(cloud_pk, id, project_pk, check_plan, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :param CheckPlan check_plan: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_checkplan_with_http_info(cloud_pk, id, project_pk, check_plan, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_checkplan_with_http_info(cloud_pk, id, project_pk, check_plan, **kwargs)  # noqa: E501
            return data

    def full_update_checkplan_with_http_info(self, cloud_pk, id, project_pk, check_plan, **kwargs):  # noqa: E501
        """full_update_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_checkplan_with_http_info(cloud_pk, id, project_pk, check_plan, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :param CheckPlan check_plan: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'check_plan']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_checkplan" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_checkplan`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_checkplan`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_checkplan`")  # noqa: E501
        # verify the required parameter 'check_plan' is set
        if ('check_plan' not in local_var_params or
                local_var_params['check_plan'] is None):
            raise ValueError("Missing the required parameter `check_plan` when calling `full_update_checkplan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'check_plan' in local_var_params:
            body_params = local_var_params['check_plan']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckPlan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_rule(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs):  # noqa: E501
        """full_update_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_rule(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :param Rule rule: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs)  # noqa: E501
            return data

    def full_update_rule_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs):  # noqa: E501
        """full_update_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :param Rule rule: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'ruleset_pk', 'rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `full_update_rule`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_rule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_rule`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_rule`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `full_update_rule`")  # noqa: E501
        # verify the required parameter 'rule' is set
        if ('rule' not in local_var_params or
                local_var_params['rule'] is None):
            raise ValueError("Missing the required parameter `rule` when calling `full_update_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule' in local_var_params:
            body_params = local_var_params['rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Rule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_rule_component(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs):  # noqa: E501
        """full_update_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_rule_component(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :param RuleComponent rule_component: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs)  # noqa: E501
            return data

    def full_update_rule_component_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs):  # noqa: E501
        """full_update_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :param RuleComponent rule_component: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'rule_pk', 'ruleset_pk', 'rule_component']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_rule_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `full_update_rule_component`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_rule_component`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_rule_component`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_pk' is set
        if ('rule_pk' not in local_var_params or
                local_var_params['rule_pk'] is None):
            raise ValueError("Missing the required parameter `rule_pk` when calling `full_update_rule_component`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `full_update_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_component' is set
        if ('rule_component' not in local_var_params or
                local_var_params['rule_component'] is None):
            raise ValueError("Missing the required parameter `rule_component` when calling `full_update_rule_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'rule_pk' in local_var_params:
            path_params['rule_pk'] = local_var_params['rule_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_component' in local_var_params:
            body_params = local_var_params['rule_component']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{rule_pk}/rulecomponent/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleComponent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_ruleset(self, check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs):  # noqa: E501
        """full_update_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ruleset(check_plan_pk, cloud_pk, id, project_pk, ruleset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :param Ruleset ruleset: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs)  # noqa: E501
            return data

    def full_update_ruleset_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs):  # noqa: E501
        """full_update_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :param Ruleset ruleset: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'ruleset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_ruleset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `full_update_ruleset`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_ruleset`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_ruleset`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_ruleset`")  # noqa: E501
        # verify the required parameter 'ruleset' is set
        if ('ruleset' not in local_var_params or
                local_var_params['ruleset'] is None):
            raise ValueError("Missing the required parameter `ruleset` when calling `full_update_ruleset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ruleset' in local_var_params:
            body_params = local_var_params['ruleset']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ruleset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_checker(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checker(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_checker_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checker" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_checker`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_checker`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_checker`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_checker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IfcChecker',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_checker_result(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checker_result(checker_pk, cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_checker_result_with_http_info(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['checker_pk', 'cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checker_result" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'checker_pk' is set
        if ('checker_pk' not in local_var_params or
                local_var_params['checker_pk'] is None):
            raise ValueError("Missing the required parameter `checker_pk` when calling `get_checker_result`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_checker_result`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_checker_result`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_checker_result`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_checker_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checker_pk' in local_var_params:
            path_params['checker_pk'] = local_var_params['checker_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{checker_pk}/result/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckerResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_checker_results(self, checker_pk, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checker_results  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checker_results(checker_pk, cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[CheckerResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checker_results_with_http_info(checker_pk, cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checker_results_with_http_info(checker_pk, cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_checker_results_with_http_info(self, checker_pk, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checker_results  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checker_results_with_http_info(checker_pk, cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[CheckerResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['checker_pk', 'cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checker_results" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'checker_pk' is set
        if ('checker_pk' not in local_var_params or
                local_var_params['checker_pk'] is None):
            raise ValueError("Missing the required parameter `checker_pk` when calling `get_checker_results`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_checker_results`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_checker_results`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_checker_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checker_pk' in local_var_params:
            path_params['checker_pk'] = local_var_params['checker_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{checker_pk}/result', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CheckerResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_checkers(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checkers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkers(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[IfcChecker]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checkers_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checkers_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_checkers_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_checkers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkers_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[IfcChecker]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checkers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_checkers`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_checkers`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_checkers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IfcChecker]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_checkplan(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkplan(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checkplan_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checkplan_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_checkplan_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkplan_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checkplan" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_checkplan`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_checkplan`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_checkplan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckPlan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_checkplans(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_checkplans  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkplans(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[CheckPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checkplans_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checkplans_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_checkplans_with_http_info(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_checkplans  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkplans_with_http_info(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[CheckPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checkplans" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_checkplans`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_checkplans`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CheckPlan]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs)  # noqa: E501
            return data

    def get_rule_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'ruleset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `get_rule`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_rule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_rule`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_rule`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `get_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Rule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_component(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_component(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs)  # noqa: E501
            return data

    def get_rule_component_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'rule_pk', 'ruleset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `get_rule_component`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_rule_component`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_rule_component`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_pk' is set
        if ('rule_pk' not in local_var_params or
                local_var_params['rule_pk'] is None):
            raise ValueError("Missing the required parameter `rule_pk` when calling `get_rule_component`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `get_rule_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'rule_pk' in local_var_params:
            path_params['rule_pk'] = local_var_params['rule_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{rule_pk}/rulecomponent/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleComponent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_components(self, check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rule_components  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_components(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :return: list[RuleComponent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_components_with_http_info(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_components_with_http_info(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, **kwargs)  # noqa: E501
            return data

    def get_rule_components_with_http_info(self, check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rule_components  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_components_with_http_info(check_plan_pk, cloud_pk, project_pk, rule_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :return: list[RuleComponent]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'project_pk', 'rule_pk', 'ruleset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule_components" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `get_rule_components`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_rule_components`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_rule_components`")  # noqa: E501
        # verify the required parameter 'rule_pk' is set
        if ('rule_pk' not in local_var_params or
                local_var_params['rule_pk'] is None):
            raise ValueError("Missing the required parameter `rule_pk` when calling `get_rule_components`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `get_rule_components`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'rule_pk' in local_var_params:
            path_params['rule_pk'] = local_var_params['rule_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{rule_pk}/rulecomponent', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RuleComponent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rules(self, check_plan_pk, cloud_pk, project_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rules  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rules(check_plan_pk, cloud_pk, project_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :return: list[Rule]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rules_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rules_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset_pk, **kwargs)  # noqa: E501
            return data

    def get_rules_with_http_info(self, check_plan_pk, cloud_pk, project_pk, ruleset_pk, **kwargs):  # noqa: E501
        """get_rules  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rules_with_http_info(check_plan_pk, cloud_pk, project_pk, ruleset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :return: list[Rule]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'project_pk', 'ruleset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `get_rules`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_rules`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_rules`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `get_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Rule]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ruleset(self, check_plan_pk, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ruleset(check_plan_pk, cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ruleset_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ruleset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `get_ruleset`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ruleset`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ruleset`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ruleset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ruleset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rulesets(self, check_plan_pk, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_rulesets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rulesets(check_plan_pk, cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[Ruleset]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rulesets_with_http_info(check_plan_pk, cloud_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rulesets_with_http_info(check_plan_pk, cloud_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_rulesets_with_http_info(self, check_plan_pk, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_rulesets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rulesets_with_http_info(check_plan_pk, cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :return: list[Ruleset]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rulesets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `get_rulesets`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_rulesets`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_rulesets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Ruleset]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def launch_new_check(self, cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """launch_new_check  # noqa: E501

        Starts a new check in the checker  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.launch_new_check(cloud_pk, id, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.launch_new_check_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
        else:
            (data) = self.launch_new_check_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
            return data

    def launch_new_check_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """launch_new_check  # noqa: E501

        Starts a new check in the checker  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.launch_new_check_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'ifc_checker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method launch_new_check" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `launch_new_check`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `launch_new_check`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `launch_new_check`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `launch_new_check`")  # noqa: E501
        # verify the required parameter 'ifc_checker' is set
        if ('ifc_checker' not in local_var_params or
                local_var_params['ifc_checker'] is None):
            raise ValueError("Missing the required parameter `ifc_checker` when calling `launch_new_check`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ifc_checker' in local_var_params:
            body_params = local_var_params['ifc_checker']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{id}/launch-check', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_checker(self, cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """update_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_checker(cloud_pk, id, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
        else:
            (data) = self.update_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs)  # noqa: E501
            return data

    def update_checker_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, ifc_checker, **kwargs):  # noqa: E501
        """update_checker  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_checker_with_http_info(cloud_pk, id, ifc_pk, project_pk, ifc_checker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc checker. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param IfcChecker ifc_checker: (required)
        :return: IfcChecker
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'ifc_checker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_checker" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_checker`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_checker`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_checker`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_checker`")  # noqa: E501
        # verify the required parameter 'ifc_checker' is set
        if ('ifc_checker' not in local_var_params or
                local_var_params['ifc_checker'] is None):
            raise ValueError("Missing the required parameter `ifc_checker` when calling `update_checker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ifc_checker' in local_var_params:
            body_params = local_var_params['ifc_checker']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IfcChecker',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_checker_result(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs):  # noqa: E501
        """update_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_checker_result(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param CheckerResult checker_result: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs)  # noqa: E501
        else:
            (data) = self.update_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs)  # noqa: E501
            return data

    def update_checker_result_with_http_info(self, checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, **kwargs):  # noqa: E501
        """update_checker_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_checker_result_with_http_info(checker_pk, cloud_pk, id, ifc_pk, project_pk, checker_result, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this checker result. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param CheckerResult checker_result: (required)
        :return: CheckerResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['checker_pk', 'cloud_pk', 'id', 'ifc_pk', 'project_pk', 'checker_result']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_checker_result" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'checker_pk' is set
        if ('checker_pk' not in local_var_params or
                local_var_params['checker_pk'] is None):
            raise ValueError("Missing the required parameter `checker_pk` when calling `update_checker_result`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_checker_result`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_checker_result`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_checker_result`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_checker_result`")  # noqa: E501
        # verify the required parameter 'checker_result' is set
        if ('checker_result' not in local_var_params or
                local_var_params['checker_result'] is None):
            raise ValueError("Missing the required parameter `checker_result` when calling `update_checker_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checker_pk' in local_var_params:
            path_params['checker_pk'] = local_var_params['checker_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'checker_result' in local_var_params:
            body_params = local_var_params['checker_result']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/checker/{checker_pk}/result/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckerResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_checkplan(self, cloud_pk, id, project_pk, check_plan, **kwargs):  # noqa: E501
        """update_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_checkplan(cloud_pk, id, project_pk, check_plan, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :param CheckPlan check_plan: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_checkplan_with_http_info(cloud_pk, id, project_pk, check_plan, **kwargs)  # noqa: E501
        else:
            (data) = self.update_checkplan_with_http_info(cloud_pk, id, project_pk, check_plan, **kwargs)  # noqa: E501
            return data

    def update_checkplan_with_http_info(self, cloud_pk, id, project_pk, check_plan, **kwargs):  # noqa: E501
        """update_checkplan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_checkplan_with_http_info(cloud_pk, id, project_pk, check_plan, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this check plan. (required)
        :param str project_pk: (required)
        :param CheckPlan check_plan: (required)
        :return: CheckPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'check_plan']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_checkplan" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_checkplan`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_checkplan`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_checkplan`")  # noqa: E501
        # verify the required parameter 'check_plan' is set
        if ('check_plan' not in local_var_params or
                local_var_params['check_plan'] is None):
            raise ValueError("Missing the required parameter `check_plan` when calling `update_checkplan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'check_plan' in local_var_params:
            body_params = local_var_params['check_plan']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckPlan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_rule(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs):  # noqa: E501
        """update_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_rule(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :param Rule rule: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs)  # noqa: E501
        else:
            (data) = self.update_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs)  # noqa: E501
            return data

    def update_rule_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, **kwargs):  # noqa: E501
        """update_rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_rule_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset_pk, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule. (required)
        :param str project_pk: (required)
        :param str ruleset_pk: (required)
        :param Rule rule: (required)
        :return: Rule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'ruleset_pk', 'rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `update_rule`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_rule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_rule`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_rule`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `update_rule`")  # noqa: E501
        # verify the required parameter 'rule' is set
        if ('rule' not in local_var_params or
                local_var_params['rule'] is None):
            raise ValueError("Missing the required parameter `rule` when calling `update_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule' in local_var_params:
            body_params = local_var_params['rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Rule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_rule_component(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs):  # noqa: E501
        """update_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_rule_component(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :param RuleComponent rule_component: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs)  # noqa: E501
        else:
            (data) = self.update_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs)  # noqa: E501
            return data

    def update_rule_component_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, **kwargs):  # noqa: E501
        """update_rule_component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_rule_component_with_http_info(check_plan_pk, cloud_pk, id, project_pk, rule_pk, ruleset_pk, rule_component, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this rule component. (required)
        :param str project_pk: (required)
        :param str rule_pk: (required)
        :param str ruleset_pk: (required)
        :param RuleComponent rule_component: (required)
        :return: RuleComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'rule_pk', 'ruleset_pk', 'rule_component']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_rule_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `update_rule_component`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_rule_component`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_rule_component`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_pk' is set
        if ('rule_pk' not in local_var_params or
                local_var_params['rule_pk'] is None):
            raise ValueError("Missing the required parameter `rule_pk` when calling `update_rule_component`")  # noqa: E501
        # verify the required parameter 'ruleset_pk' is set
        if ('ruleset_pk' not in local_var_params or
                local_var_params['ruleset_pk'] is None):
            raise ValueError("Missing the required parameter `ruleset_pk` when calling `update_rule_component`")  # noqa: E501
        # verify the required parameter 'rule_component' is set
        if ('rule_component' not in local_var_params or
                local_var_params['rule_component'] is None):
            raise ValueError("Missing the required parameter `rule_component` when calling `update_rule_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'rule_pk' in local_var_params:
            path_params['rule_pk'] = local_var_params['rule_pk']  # noqa: E501
        if 'ruleset_pk' in local_var_params:
            path_params['ruleset_pk'] = local_var_params['ruleset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_component' in local_var_params:
            body_params = local_var_params['rule_component']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{ruleset_pk}/rule/{rule_pk}/rulecomponent/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleComponent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ruleset(self, check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs):  # noqa: E501
        """update_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ruleset(check_plan_pk, cloud_pk, id, project_pk, ruleset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :param Ruleset ruleset: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs)  # noqa: E501
            return data

    def update_ruleset_with_http_info(self, check_plan_pk, cloud_pk, id, project_pk, ruleset, **kwargs):  # noqa: E501
        """update_ruleset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ruleset_with_http_info(check_plan_pk, cloud_pk, id, project_pk, ruleset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_plan_pk: (required)
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ruleset. (required)
        :param str project_pk: (required)
        :param Ruleset ruleset: (required)
        :return: Ruleset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['check_plan_pk', 'cloud_pk', 'id', 'project_pk', 'ruleset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ruleset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_plan_pk' is set
        if ('check_plan_pk' not in local_var_params or
                local_var_params['check_plan_pk'] is None):
            raise ValueError("Missing the required parameter `check_plan_pk` when calling `update_ruleset`")  # noqa: E501
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_ruleset`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_ruleset`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_ruleset`")  # noqa: E501
        # verify the required parameter 'ruleset' is set
        if ('ruleset' not in local_var_params or
                local_var_params['ruleset'] is None):
            raise ValueError("Missing the required parameter `ruleset` when calling `update_ruleset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_plan_pk' in local_var_params:
            path_params['check_plan_pk'] = local_var_params['check_plan_pk']  # noqa: E501
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ruleset' in local_var_params:
            body_params = local_var_params['ruleset']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/checkplan/{check_plan_pk}/ruleset/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ruleset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
