# coding: utf-8

"""
    BIMData API

    BIMData API documentation  # noqa: E501

    OpenAPI spec version: v1
    Contact: contact@bimdata.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bimdata_api_client.api_client import ApiClient


class IfcApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def bulk_delete_ifc_classifications(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_classifications  # noqa: E501

                     Delete relation between filtered classifications (eg. /classifications?name=untec) and all ifc's elements.             No classification will be deleted on this endpoint, only the relation between ifc's elements and their classification.           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_classifications(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_delete_ifc_classifications_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_delete_ifc_classifications_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def bulk_delete_ifc_classifications_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_classifications  # noqa: E501

                     Delete relation between filtered classifications (eg. /classifications?name=untec) and all ifc's elements.             No classification will be deleted on this endpoint, only the relation between ifc's elements and their classification.           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_classifications_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_delete_ifc_classifications" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_delete_ifc_classifications`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_delete_ifc_classifications`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_delete_ifc_classifications`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/classification/list_destroy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_delete_ifc_properties(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_properties  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_properties(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_delete_ifc_properties_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_delete_ifc_properties_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def bulk_delete_ifc_properties_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_properties  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_properties_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_delete_ifc_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_delete_ifc_properties`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_delete_ifc_properties`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_delete_ifc_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property/bulk_destroy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_delete_ifc_property_definitions(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_property_definitions  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_property_definitions(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_delete_ifc_property_definitions_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_delete_ifc_property_definitions_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def bulk_delete_ifc_property_definitions_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_property_definitions  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_property_definitions_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_delete_ifc_property_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_delete_ifc_property_definitions`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_delete_ifc_property_definitions`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_delete_ifc_property_definitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertydefinition/bulk_destroy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_delete_ifc_units(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_units  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_units(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_delete_ifc_units_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_delete_ifc_units_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def bulk_delete_ifc_units_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_ifc_units  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_ifc_units_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_delete_ifc_units" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_delete_ifc_units`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_delete_ifc_units`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_delete_ifc_units`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/unit/bulk_destroy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_delete_property_set(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_property_set  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_property_set(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_delete_property_set_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_delete_property_set_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def bulk_delete_property_set_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_delete_property_set  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_delete_property_set_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_delete_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_delete_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_delete_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_delete_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset/bulk_destroy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_full_update_elements(self, cloud_pk, ifc_pk, project_pk, element, **kwargs):  # noqa: E501
        """bulk_full_update_elements  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_full_update_elements(cloud_pk, ifc_pk, project_pk, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Element] element: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_full_update_elements_with_http_info(cloud_pk, ifc_pk, project_pk, element, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_full_update_elements_with_http_info(cloud_pk, ifc_pk, project_pk, element, **kwargs)  # noqa: E501
            return data

    def bulk_full_update_elements_with_http_info(self, cloud_pk, ifc_pk, project_pk, element, **kwargs):  # noqa: E501
        """bulk_full_update_elements  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_full_update_elements_with_http_info(cloud_pk, ifc_pk, project_pk, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Element] element: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'element']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_full_update_elements" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_full_update_elements`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_full_update_elements`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_full_update_elements`")  # noqa: E501
        # verify the required parameter 'element' is set
        if ('element' not in local_var_params or
                local_var_params['element'] is None):
            raise ValueError("Missing the required parameter `element` when calling `bulk_full_update_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'element' in local_var_params:
            body_params = local_var_params['element']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/bulk_update', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Element]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_full_update_ifc_property(self, cloud_pk, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """bulk_full_update_ifc_property  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_full_update_ifc_property(cloud_pk, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ModelProperty] model_property: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_full_update_ifc_property_with_http_info(cloud_pk, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_full_update_ifc_property_with_http_info(cloud_pk, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
            return data

    def bulk_full_update_ifc_property_with_http_info(self, cloud_pk, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """bulk_full_update_ifc_property  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_full_update_ifc_property_with_http_info(cloud_pk, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ModelProperty] model_property: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'model_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_full_update_ifc_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_full_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_full_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_full_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'model_property' is set
        if ('model_property' not in local_var_params or
                local_var_params['model_property'] is None):
            raise ValueError("Missing the required parameter `model_property` when calling `bulk_full_update_ifc_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_property' in local_var_params:
            body_params = local_var_params['model_property']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property/bulk_update', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ModelProperty]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_remove_classifications_of_element(self, cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_remove_classifications_of_element  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_remove_classifications_of_element(cloud_pk, element_uuid, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_remove_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_remove_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def bulk_remove_classifications_of_element_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_remove_classifications_of_element  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_remove_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_remove_classifications_of_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_remove_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `bulk_remove_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_remove_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_remove_classifications_of_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/classification/bulk_destroy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_remove_elements_from_classification(self, cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_remove_elements_from_classification  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_remove_elements_from_classification(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_classification_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_remove_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_remove_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def bulk_remove_elements_from_classification_with_http_info(self, cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """bulk_remove_elements_from_classification  # noqa: E501

                 Bulk delete.         You should send a list of ids in the body.         These ids (or relations with these ids in case of many-to-many relation deletion) will be deleted       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_remove_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_classification_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_classification_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_remove_elements_from_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_remove_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'ifc_classification_pk' is set
        if ('ifc_classification_pk' not in local_var_params or
                local_var_params['ifc_classification_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_classification_pk` when calling `bulk_remove_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_remove_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_remove_elements_from_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_classification_pk' in local_var_params:
            path_params['ifc_classification_pk'] = local_var_params['ifc_classification_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/classification/{ifc_classification_pk}/element/bulk_destroy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_update_elements(self, cloud_pk, ifc_pk, project_pk, element, **kwargs):  # noqa: E501
        """bulk_update_elements  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_update_elements(cloud_pk, ifc_pk, project_pk, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Element] element: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_update_elements_with_http_info(cloud_pk, ifc_pk, project_pk, element, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_update_elements_with_http_info(cloud_pk, ifc_pk, project_pk, element, **kwargs)  # noqa: E501
            return data

    def bulk_update_elements_with_http_info(self, cloud_pk, ifc_pk, project_pk, element, **kwargs):  # noqa: E501
        """bulk_update_elements  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_update_elements_with_http_info(cloud_pk, ifc_pk, project_pk, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Element] element: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'element']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_update_elements" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_update_elements`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_update_elements`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_update_elements`")  # noqa: E501
        # verify the required parameter 'element' is set
        if ('element' not in local_var_params or
                local_var_params['element'] is None):
            raise ValueError("Missing the required parameter `element` when calling `bulk_update_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'element' in local_var_params:
            body_params = local_var_params['element']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/bulk_update', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Element]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bulk_update_ifc_property(self, cloud_pk, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """bulk_update_ifc_property  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_update_ifc_property(cloud_pk, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ModelProperty] model_property: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bulk_update_ifc_property_with_http_info(cloud_pk, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
        else:
            (data) = self.bulk_update_ifc_property_with_http_info(cloud_pk, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
            return data

    def bulk_update_ifc_property_with_http_info(self, cloud_pk, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """bulk_update_ifc_property  # noqa: E501

                 Bulk update.         Similar to update, but the body should be a list of objects to patch or put         The response will be a list (in the same order) of updated objects or of errors if any         If at least one update succeeded, the status code will be 200. If every update failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bulk_update_ifc_property_with_http_info(cloud_pk, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ModelProperty] model_property: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'model_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_update_ifc_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `bulk_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `bulk_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `bulk_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'model_property' is set
        if ('model_property' not in local_var_params or
                local_var_params['model_property'] is None):
            raise ValueError("Missing the required parameter `model_property` when calling `bulk_update_ifc_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_property' in local_var_params:
            body_params = local_var_params['model_property']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property/bulk_update', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ModelProperty]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_classification_element_relations(self, cloud_pk, ifc_pk, project_pk, element_classification_relation, **kwargs):  # noqa: E501
        """create_classification_element_relations  # noqa: E501

                     create association between existing classification and existing element           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_classification_element_relations(cloud_pk, ifc_pk, project_pk, element_classification_relation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ElementClassificationRelation] element_classification_relation: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_classification_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, element_classification_relation, **kwargs)  # noqa: E501
        else:
            (data) = self.create_classification_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, element_classification_relation, **kwargs)  # noqa: E501
            return data

    def create_classification_element_relations_with_http_info(self, cloud_pk, ifc_pk, project_pk, element_classification_relation, **kwargs):  # noqa: E501
        """create_classification_element_relations  # noqa: E501

                     create association between existing classification and existing element           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_classification_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, element_classification_relation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ElementClassificationRelation] element_classification_relation: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'element_classification_relation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_classification_element_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_classification_element_relations`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_classification_element_relations`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_classification_element_relations`")  # noqa: E501
        # verify the required parameter 'element_classification_relation' is set
        if ('element_classification_relation' not in local_var_params or
                local_var_params['element_classification_relation'] is None):
            raise ValueError("Missing the required parameter `element_classification_relation` when calling `create_classification_element_relations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'element_classification_relation' in local_var_params:
            body_params = local_var_params['element_classification_relation']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/classification-element', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_classifications_of_element(self, cloud_pk, element_uuid, ifc_pk, project_pk, classification, **kwargs):  # noqa: E501
        """create_classifications_of_element  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_classifications_of_element(cloud_pk, element_uuid, ifc_pk, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Classification] classification: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, classification, **kwargs)  # noqa: E501
        else:
            (data) = self.create_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, classification, **kwargs)  # noqa: E501
            return data

    def create_classifications_of_element_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, classification, **kwargs):  # noqa: E501
        """create_classifications_of_element  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, classification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Classification] classification: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'classification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_classifications_of_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `create_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'classification' is set
        if ('classification' not in local_var_params or
                local_var_params['classification'] is None):
            raise ValueError("Missing the required parameter `classification` when calling `create_classifications_of_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'classification' in local_var_params:
            body_params = local_var_params['classification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/classification', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Classification]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_element(self, cloud_pk, ifc_pk, project_pk, element, **kwargs):  # noqa: E501
        """create_element  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element(cloud_pk, ifc_pk, project_pk, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Element] element: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_element_with_http_info(cloud_pk, ifc_pk, project_pk, element, **kwargs)  # noqa: E501
        else:
            (data) = self.create_element_with_http_info(cloud_pk, ifc_pk, project_pk, element, **kwargs)  # noqa: E501
            return data

    def create_element_with_http_info(self, cloud_pk, ifc_pk, project_pk, element, **kwargs):  # noqa: E501
        """create_element  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_with_http_info(cloud_pk, ifc_pk, project_pk, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Element] element: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'element']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_element`")  # noqa: E501
        # verify the required parameter 'element' is set
        if ('element' not in local_var_params or
                local_var_params['element'] is None):
            raise ValueError("Missing the required parameter `element` when calling `create_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'element' in local_var_params:
            body_params = local_var_params['element']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Element]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_element_property_set(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """create_element_property_set  # noqa: E501

                 Create an property_set that will be automatically linked to the element       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set(cloud_pk, element_uuid, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertySet property_set: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_element_property_set_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
        else:
            (data) = self.create_element_property_set_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
            return data

    def create_element_property_set_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """create_element_property_set  # noqa: E501

                 Create an property_set that will be automatically linked to the element       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertySet property_set: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'property_set']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_element_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_element_property_set`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `create_element_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_element_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_element_property_set`")  # noqa: E501
        # verify the required parameter 'property_set' is set
        if ('property_set' not in local_var_params or
                local_var_params['property_set'] is None):
            raise ValueError("Missing the required parameter `property_set` when calling `create_element_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_set' in local_var_params:
            body_params = local_var_params['property_set']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_element_property_set_property(self, cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, model_property, **kwargs):  # noqa: E501
        """create_element_property_set_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set_property(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :param ModelProperty model_property: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_element_property_set_property_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, model_property, **kwargs)  # noqa: E501
        else:
            (data) = self.create_element_property_set_property_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, model_property, **kwargs)  # noqa: E501
            return data

    def create_element_property_set_property_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, model_property, **kwargs):  # noqa: E501
        """create_element_property_set_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set_property_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :param ModelProperty model_property: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'propertyset_pk', 'model_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_element_property_set_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `create_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `create_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'model_property' is set
        if ('model_property' not in local_var_params or
                local_var_params['model_property'] is None):
            raise ValueError("Missing the required parameter `model_property` when calling `create_element_property_set_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_property' in local_var_params:
            body_params = local_var_params['model_property']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_element_property_set_property_definition(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, property_definition, **kwargs):  # noqa: E501
        """create_element_property_set_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set_property_definition(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :param PropertyDefinition property_definition: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, property_definition, **kwargs)  # noqa: E501
        else:
            (data) = self.create_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, property_definition, **kwargs)  # noqa: E501
            return data

    def create_element_property_set_property_definition_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, property_definition, **kwargs):  # noqa: E501
        """create_element_property_set_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :param PropertyDefinition property_definition: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'property_pk', 'propertyset_pk', 'property_definition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_element_property_set_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `create_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `create_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `create_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'property_definition' is set
        if ('property_definition' not in local_var_params or
                local_var_params['property_definition'] is None):
            raise ValueError("Missing the required parameter `property_definition` when calling `create_element_property_set_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_definition' in local_var_params:
            body_params = local_var_params['property_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertyDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_element_property_set_property_definition_unit(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, unit, **kwargs):  # noqa: E501
        """create_element_property_set_property_definition_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set_property_definition_unit(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :param Unit unit: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, unit, **kwargs)  # noqa: E501
        else:
            (data) = self.create_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, unit, **kwargs)  # noqa: E501
            return data

    def create_element_property_set_property_definition_unit_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, unit, **kwargs):  # noqa: E501
        """create_element_property_set_property_definition_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :param Unit unit: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'property_pk', 'propertydefinition_pk', 'propertyset_pk', 'unit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_element_property_set_property_definition_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'propertydefinition_pk' is set
        if ('propertydefinition_pk' not in local_var_params or
                local_var_params['propertydefinition_pk'] is None):
            raise ValueError("Missing the required parameter `propertydefinition_pk` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'unit' is set
        if ('unit' not in local_var_params or
                local_var_params['unit'] is None):
            raise ValueError("Missing the required parameter `unit` when calling `create_element_property_set_property_definition_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertydefinition_pk' in local_var_params:
            path_params['propertydefinition_pk'] = local_var_params['propertydefinition_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit' in local_var_params:
            body_params = local_var_params['unit']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition/{propertydefinition_pk}/unit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Unit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ifc_property_definition(self, cloud_pk, ifc_pk, project_pk, property_definition, **kwargs):  # noqa: E501
        """create_ifc_property_definition  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ifc_property_definition(cloud_pk, ifc_pk, project_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[PropertyDefinition] property_definition: (required)
        :return: list[PropertyDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ifc_property_definition_with_http_info(cloud_pk, ifc_pk, project_pk, property_definition, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ifc_property_definition_with_http_info(cloud_pk, ifc_pk, project_pk, property_definition, **kwargs)  # noqa: E501
            return data

    def create_ifc_property_definition_with_http_info(self, cloud_pk, ifc_pk, project_pk, property_definition, **kwargs):  # noqa: E501
        """create_ifc_property_definition  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ifc_property_definition_with_http_info(cloud_pk, ifc_pk, project_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[PropertyDefinition] property_definition: (required)
        :return: list[PropertyDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'property_definition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ifc_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'property_definition' is set
        if ('property_definition' not in local_var_params or
                local_var_params['property_definition'] is None):
            raise ValueError("Missing the required parameter `property_definition` when calling `create_ifc_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_definition' in local_var_params:
            body_params = local_var_params['property_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertydefinition', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PropertyDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ifc_unit(self, cloud_pk, ifc_pk, project_pk, unit, **kwargs):  # noqa: E501
        """create_ifc_unit  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ifc_unit(cloud_pk, ifc_pk, project_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Unit] unit: (required)
        :return: list[Unit]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ifc_unit_with_http_info(cloud_pk, ifc_pk, project_pk, unit, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ifc_unit_with_http_info(cloud_pk, ifc_pk, project_pk, unit, **kwargs)  # noqa: E501
            return data

    def create_ifc_unit_with_http_info(self, cloud_pk, ifc_pk, project_pk, unit, **kwargs):  # noqa: E501
        """create_ifc_unit  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ifc_unit_with_http_info(cloud_pk, ifc_pk, project_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Unit] unit: (required)
        :return: list[Unit]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'unit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ifc_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_ifc_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_ifc_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_ifc_unit`")  # noqa: E501
        # verify the required parameter 'unit' is set
        if ('unit' not in local_var_params or
                local_var_params['unit'] is None):
            raise ValueError("Missing the required parameter `unit` when calling `create_ifc_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit' in local_var_params:
            body_params = local_var_params['unit']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/unit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Unit]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_property_set(self, cloud_pk, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """create_property_set  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_property_set(cloud_pk, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[PropertySet] property_set: (required)
        :return: list[PropertySet]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_property_set_with_http_info(cloud_pk, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
        else:
            (data) = self.create_property_set_with_http_info(cloud_pk, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
            return data

    def create_property_set_with_http_info(self, cloud_pk, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """create_property_set  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors          If classification created already exists, it will just be added to item's classifications and will not be duplicated       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_property_set_with_http_info(cloud_pk, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[PropertySet] property_set: (required)
        :return: list[PropertySet]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'property_set']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_property_set`")  # noqa: E501
        # verify the required parameter 'property_set' is set
        if ('property_set' not in local_var_params or
                local_var_params['property_set'] is None):
            raise ValueError("Missing the required parameter `property_set` when calling `create_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_set' in local_var_params:
            body_params = local_var_params['property_set']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PropertySet]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_property_set_element_relations(self, cloud_pk, ifc_pk, project_pk, element_property_set_relation, **kwargs):  # noqa: E501
        """create_property_set_element_relations  # noqa: E501

                     create association between existing classification and existing element           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_property_set_element_relations(cloud_pk, ifc_pk, project_pk, element_property_set_relation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ElementPropertySetRelation] element_property_set_relation: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_property_set_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, element_property_set_relation, **kwargs)  # noqa: E501
        else:
            (data) = self.create_property_set_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, element_property_set_relation, **kwargs)  # noqa: E501
            return data

    def create_property_set_element_relations_with_http_info(self, cloud_pk, ifc_pk, project_pk, element_property_set_relation, **kwargs):  # noqa: E501
        """create_property_set_element_relations  # noqa: E501

                     create association between existing classification and existing element           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_property_set_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, element_property_set_relation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[ElementPropertySetRelation] element_property_set_relation: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'element_property_set_relation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_property_set_element_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_property_set_element_relations`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_property_set_element_relations`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_property_set_element_relations`")  # noqa: E501
        # verify the required parameter 'element_property_set_relation' is set
        if ('element_property_set_relation' not in local_var_params or
                local_var_params['element_property_set_relation'] is None):
            raise ValueError("Missing the required parameter `element_property_set_relation` when calling `create_property_set_element_relations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'element_property_set_relation' in local_var_params:
            body_params = local_var_params['element_property_set_relation']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset-element', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_raw_elements(self, cloud_pk, ifc_pk, project_pk, raw_elements, **kwargs):  # noqa: E501
        """create_raw_elements  # noqa: E501

                 You can use the same optimized structure to post multiple elements ,property_sets, properties, definitions and units at once.         If the structure is malformed, an error 500 without more explaination will be returned           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_raw_elements(cloud_pk, ifc_pk, project_pk, raw_elements, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param RawElements raw_elements: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_raw_elements_with_http_info(cloud_pk, ifc_pk, project_pk, raw_elements, **kwargs)  # noqa: E501
        else:
            (data) = self.create_raw_elements_with_http_info(cloud_pk, ifc_pk, project_pk, raw_elements, **kwargs)  # noqa: E501
            return data

    def create_raw_elements_with_http_info(self, cloud_pk, ifc_pk, project_pk, raw_elements, **kwargs):  # noqa: E501
        """create_raw_elements  # noqa: E501

                 You can use the same optimized structure to post multiple elements ,property_sets, properties, definitions and units at once.         If the structure is malformed, an error 500 without more explaination will be returned           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_raw_elements_with_http_info(cloud_pk, ifc_pk, project_pk, raw_elements, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param RawElements raw_elements: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'raw_elements']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_raw_elements" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_raw_elements`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_raw_elements`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_raw_elements`")  # noqa: E501
        # verify the required parameter 'raw_elements' is set
        if ('raw_elements' not in local_var_params or
                local_var_params['raw_elements'] is None):
            raise ValueError("Missing the required parameter `raw_elements` when calling `create_raw_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'raw_elements' in local_var_params:
            body_params = local_var_params['raw_elements']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_space(self, cloud_pk, ifc_pk, project_pk, space, **kwargs):  # noqa: E501
        """create_space  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_space(cloud_pk, ifc_pk, project_pk, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Space] space: (required)
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_space_with_http_info(cloud_pk, ifc_pk, project_pk, space, **kwargs)  # noqa: E501
        else:
            (data) = self.create_space_with_http_info(cloud_pk, ifc_pk, project_pk, space, **kwargs)  # noqa: E501
            return data

    def create_space_with_http_info(self, cloud_pk, ifc_pk, project_pk, space, **kwargs):  # noqa: E501
        """create_space  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_space_with_http_info(cloud_pk, ifc_pk, project_pk, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Space] space: (required)
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_space`")  # noqa: E501
        # verify the required parameter 'space' is set
        if ('space' not in local_var_params or
                local_var_params['space'] is None):
            raise ValueError("Missing the required parameter `space` when calling `create_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'space' in local_var_params:
            body_params = local_var_params['space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/space', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Space]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_zone(self, cloud_pk, ifc_pk, project_pk, zone, **kwargs):  # noqa: E501
        """create_zone  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_zone(cloud_pk, ifc_pk, project_pk, zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Zone] zone: (required)
        :return: list[Zone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_zone_with_http_info(cloud_pk, ifc_pk, project_pk, zone, **kwargs)  # noqa: E501
        else:
            (data) = self.create_zone_with_http_info(cloud_pk, ifc_pk, project_pk, zone, **kwargs)  # noqa: E501
            return data

    def create_zone_with_http_info(self, cloud_pk, ifc_pk, project_pk, zone, **kwargs):  # noqa: E501
        """create_zone  # noqa: E501

                 Bulk create available.         You can either post an object or a list of objects.         Is you post a list, the response will be a list (in the same order) of created objects or of errors if any         If at least one create succeeded, the status code will be 201. If every create failed, the status code we'll be 400 with the list of errors       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_zone_with_http_info(cloud_pk, ifc_pk, project_pk, zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param list[Zone] zone: (required)
        :return: list[Zone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_zone" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_zone`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_zone`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_zone`")  # noqa: E501
        # verify the required parameter 'zone' is set
        if ('zone' not in local_var_params or
                local_var_params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `create_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone' in local_var_params:
            body_params = local_var_params['zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Zone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_zone_space(self, cloud_pk, ifc_pk, project_pk, zone_pk, zone_space, **kwargs):  # noqa: E501
        """create_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_zone_space(cloud_pk, ifc_pk, project_pk, zone_pk, zone_space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :param ZoneSpace zone_space: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_zone_space_with_http_info(cloud_pk, ifc_pk, project_pk, zone_pk, zone_space, **kwargs)  # noqa: E501
        else:
            (data) = self.create_zone_space_with_http_info(cloud_pk, ifc_pk, project_pk, zone_pk, zone_space, **kwargs)  # noqa: E501
            return data

    def create_zone_space_with_http_info(self, cloud_pk, ifc_pk, project_pk, zone_pk, zone_space, **kwargs):  # noqa: E501
        """create_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_zone_space_with_http_info(cloud_pk, ifc_pk, project_pk, zone_pk, zone_space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :param ZoneSpace zone_space: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'zone_pk', 'zone_space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_zone_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `create_zone_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `create_zone_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `create_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_pk' is set
        if ('zone_pk' not in local_var_params or
                local_var_params['zone_pk'] is None):
            raise ValueError("Missing the required parameter `zone_pk` when calling `create_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_space' is set
        if ('zone_space' not in local_var_params or
                local_var_params['zone_space'] is None):
            raise ValueError("Missing the required parameter `zone_space` when calling `create_zone_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'zone_pk' in local_var_params:
            path_params['zone_pk'] = local_var_params['zone_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone_space' in local_var_params:
            body_params = local_var_params['zone_space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{zone_pk}/space', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ZoneSpace',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_element(self, cloud_pk, ifc_pk, project_pk, uuid, **kwargs):  # noqa: E501
        """delete_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_element(cloud_pk, ifc_pk, project_pk, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, **kwargs)  # noqa: E501
            return data

    def delete_element_with_http_info(self, cloud_pk, ifc_pk, project_pk, uuid, **kwargs):  # noqa: E501
        """delete_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_element`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if ('uuid' not in local_var_params or
                local_var_params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ifc(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ifc_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ifc_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_ifc_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """delete_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ifc" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_ifc`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_ifc`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_ifc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ifc_property(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc_property(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_ifc_property_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ifc_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_ifc_property`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_ifc_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_ifc_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_ifc_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ifc_property_definition(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc_property_definition(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_ifc_property_definition_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ifc_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_ifc_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertydefinition/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ifc_unit(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc_unit(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_ifc_unit_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ifc_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_ifc_unit`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_ifc_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_ifc_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_ifc_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/unit/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_property_set(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_property_set(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_property_set_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_property_set`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_space(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_space(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/space/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_zone(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zone(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def delete_zone_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """delete_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_zone" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_zone`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_zone`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_zone`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_zone_space(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs):  # noqa: E501
        """delete_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zone_space(cloud_pk, id, ifc_pk, project_pk, zone_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs)  # noqa: E501
            return data

    def delete_zone_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs):  # noqa: E501
        """delete_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'zone_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_zone_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `delete_zone_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_zone_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `delete_zone_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `delete_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_pk' is set
        if ('zone_pk' not in local_var_params or
                local_var_params['zone_pk'] is None):
            raise ValueError("Missing the required parameter `zone_pk` when calling `delete_zone_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'zone_pk' in local_var_params:
            path_params['zone_pk'] = local_var_params['zone_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{zone_pk}/space/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_element(self, cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs):  # noqa: E501
        """full_update_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_element(cloud_pk, ifc_pk, project_pk, uuid, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :param Element element: (required)
        :return: Element
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs)  # noqa: E501
            return data

    def full_update_element_with_http_info(self, cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs):  # noqa: E501
        """full_update_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :param Element element: (required)
        :return: Element
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'uuid', 'element']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_element`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if ('uuid' not in local_var_params or
                local_var_params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `full_update_element`")  # noqa: E501
        # verify the required parameter 'element' is set
        if ('element' not in local_var_params or
                local_var_params['element'] is None):
            raise ValueError("Missing the required parameter `element` when calling `full_update_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'element' in local_var_params:
            body_params = local_var_params['element']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Element',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_ifc(self, cloud_pk, id, project_pk, ifc, **kwargs):  # noqa: E501
        """full_update_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc(cloud_pk, id, project_pk, ifc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :param Ifc ifc: (required)
        :return: Ifc
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_ifc_with_http_info(cloud_pk, id, project_pk, ifc, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_ifc_with_http_info(cloud_pk, id, project_pk, ifc, **kwargs)  # noqa: E501
            return data

    def full_update_ifc_with_http_info(self, cloud_pk, id, project_pk, ifc, **kwargs):  # noqa: E501
        """full_update_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc_with_http_info(cloud_pk, id, project_pk, ifc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :param Ifc ifc: (required)
        :return: Ifc
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'ifc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_ifc" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_ifc`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_ifc`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_ifc`")  # noqa: E501
        # verify the required parameter 'ifc' is set
        if ('ifc' not in local_var_params or
                local_var_params['ifc'] is None):
            raise ValueError("Missing the required parameter `ifc` when calling `full_update_ifc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ifc' in local_var_params:
            body_params = local_var_params['ifc']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ifc',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_ifc_property(self, cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """full_update_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc_property(cloud_pk, id, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param ModelProperty model_property: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
            return data

    def full_update_ifc_property_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """full_update_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param ModelProperty model_property: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'model_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_ifc_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_ifc_property`")  # noqa: E501
        # verify the required parameter 'model_property' is set
        if ('model_property' not in local_var_params or
                local_var_params['model_property'] is None):
            raise ValueError("Missing the required parameter `model_property` when calling `full_update_ifc_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_property' in local_var_params:
            body_params = local_var_params['model_property']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_ifc_property_definition(self, cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs):  # noqa: E501
        """full_update_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc_property_definition(cloud_pk, id, ifc_pk, project_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertyDefinition property_definition: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs)  # noqa: E501
            return data

    def full_update_ifc_property_definition_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs):  # noqa: E501
        """full_update_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertyDefinition property_definition: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'property_definition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_ifc_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'property_definition' is set
        if ('property_definition' not in local_var_params or
                local_var_params['property_definition'] is None):
            raise ValueError("Missing the required parameter `property_definition` when calling `full_update_ifc_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_definition' in local_var_params:
            body_params = local_var_params['property_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertydefinition/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertyDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_ifc_unit(self, cloud_pk, id, ifc_pk, project_pk, unit, **kwargs):  # noqa: E501
        """full_update_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc_unit(cloud_pk, id, ifc_pk, project_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Unit unit: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, unit, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, unit, **kwargs)  # noqa: E501
            return data

    def full_update_ifc_unit_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, unit, **kwargs):  # noqa: E501
        """full_update_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Unit unit: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'unit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_ifc_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'unit' is set
        if ('unit' not in local_var_params or
                local_var_params['unit'] is None):
            raise ValueError("Missing the required parameter `unit` when calling `full_update_ifc_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit' in local_var_params:
            body_params = local_var_params['unit']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/unit/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Unit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_property_set(self, cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """full_update_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_property_set(cloud_pk, id, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertySet property_set: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
            return data

    def full_update_property_set_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """full_update_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertySet property_set: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'property_set']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_property_set`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_property_set`")  # noqa: E501
        # verify the required parameter 'property_set' is set
        if ('property_set' not in local_var_params or
                local_var_params['property_set'] is None):
            raise ValueError("Missing the required parameter `property_set` when calling `full_update_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_set' in local_var_params:
            body_params = local_var_params['property_set']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertySet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_space(self, cloud_pk, id, ifc_pk, project_pk, space, **kwargs):  # noqa: E501
        """full_update_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_space(cloud_pk, id, ifc_pk, project_pk, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Space space: (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, space, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, space, **kwargs)  # noqa: E501
            return data

    def full_update_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, space, **kwargs):  # noqa: E501
        """full_update_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Space space: (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_space`")  # noqa: E501
        # verify the required parameter 'space' is set
        if ('space' not in local_var_params or
                local_var_params['space'] is None):
            raise ValueError("Missing the required parameter `space` when calling `full_update_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'space' in local_var_params:
            body_params = local_var_params['space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/space/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_zone(self, cloud_pk, id, ifc_pk, project_pk, zone, **kwargs):  # noqa: E501
        """full_update_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_zone(cloud_pk, id, ifc_pk, project_pk, zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Zone zone: (required)
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone, **kwargs)  # noqa: E501
            return data

    def full_update_zone_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, zone, **kwargs):  # noqa: E501
        """full_update_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Zone zone: (required)
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_zone" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_zone`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_zone`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_zone`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_zone`")  # noqa: E501
        # verify the required parameter 'zone' is set
        if ('zone' not in local_var_params or
                local_var_params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `full_update_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone' in local_var_params:
            body_params = local_var_params['zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def full_update_zone_space(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs):  # noqa: E501
        """full_update_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_zone_space(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :param ZoneSpace zone_space: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.full_update_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs)  # noqa: E501
        else:
            (data) = self.full_update_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs)  # noqa: E501
            return data

    def full_update_zone_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs):  # noqa: E501
        """full_update_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.full_update_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :param ZoneSpace zone_space: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'zone_pk', 'zone_space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method full_update_zone_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `full_update_zone_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `full_update_zone_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `full_update_zone_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `full_update_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_pk' is set
        if ('zone_pk' not in local_var_params or
                local_var_params['zone_pk'] is None):
            raise ValueError("Missing the required parameter `zone_pk` when calling `full_update_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_space' is set
        if ('zone_space' not in local_var_params or
                local_var_params['zone_space'] is None):
            raise ValueError("Missing the required parameter `zone_space` when calling `full_update_zone_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'zone_pk' in local_var_params:
            path_params['zone_pk'] = local_var_params['zone_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone_space' in local_var_params:
            body_params = local_var_params['zone_space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{zone_pk}/space/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ZoneSpace',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_classifications_of_element(self, cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_classifications_of_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classifications_of_element(cloud_pk, element_uuid, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_classifications_of_element_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_classifications_of_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classifications_of_element_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classifications_of_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_classifications_of_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_classifications_of_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/classification', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Classification]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element(self, cloud_pk, ifc_pk, project_pk, uuid, **kwargs):  # noqa: E501
        """get_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element(cloud_pk, ifc_pk, project_pk, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :return: Element
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, **kwargs)  # noqa: E501
            return data

    def get_element_with_http_info(self, cloud_pk, ifc_pk, project_pk, uuid, **kwargs):  # noqa: E501
        """get_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :return: Element
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if ('uuid' not in local_var_params or
                local_var_params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Element',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_set(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_element_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set(cloud_pk, element_uuid, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property set. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_set_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_set_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_set_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_element_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property set. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_set`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_set`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_element_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertySet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_set_properties(self, cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_properties(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_set_properties_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_set_properties_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_set_properties_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_properties_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_set_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_set_properties`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_set_properties`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_set_properties`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_set_properties`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `get_element_property_set_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ModelProperty]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_set_property(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_set_property_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_set_property_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_set_property_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_set_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `get_element_property_set_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_set_property_definition(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definition(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property definition. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_set_property_definition_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property definition. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk', 'property_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_set_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `get_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `get_element_property_set_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertyDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_set_property_definition_unit(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definition_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definition_unit(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this unit. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_set_property_definition_unit_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definition_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this unit. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk', 'property_pk', 'propertydefinition_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_set_property_definition_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'propertydefinition_pk' is set
        if ('propertydefinition_pk' not in local_var_params or
                local_var_params['propertydefinition_pk'] is None):
            raise ValueError("Missing the required parameter `propertydefinition_pk` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `get_element_property_set_property_definition_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertydefinition_pk' in local_var_params:
            path_params['propertydefinition_pk'] = local_var_params['propertydefinition_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition/{propertydefinition_pk}/unit/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Unit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_set_property_definition_units(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definition_units  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definition_units(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :return: list[Unit]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_set_property_definition_units_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_set_property_definition_units_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_set_property_definition_units_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definition_units  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definition_units_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :return: list[Unit]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'property_pk', 'propertydefinition_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_set_property_definition_units" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_set_property_definition_units`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_set_property_definition_units`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_set_property_definition_units`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_set_property_definition_units`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `get_element_property_set_property_definition_units`")  # noqa: E501
        # verify the required parameter 'propertydefinition_pk' is set
        if ('propertydefinition_pk' not in local_var_params or
                local_var_params['propertydefinition_pk'] is None):
            raise ValueError("Missing the required parameter `propertydefinition_pk` when calling `get_element_property_set_property_definition_units`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `get_element_property_set_property_definition_units`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertydefinition_pk' in local_var_params:
            path_params['propertydefinition_pk'] = local_var_params['propertydefinition_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition/{propertydefinition_pk}/unit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Unit]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_set_property_definitions(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definitions(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :return: list[PropertyDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_set_property_definitions_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_set_property_definitions_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_set_property_definitions_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs):  # noqa: E501
        """get_element_property_set_property_definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_set_property_definitions_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, property_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :return: list[PropertyDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk', 'property_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_set_property_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_set_property_definitions`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_set_property_definitions`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_set_property_definitions`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_set_property_definitions`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `get_element_property_set_property_definitions`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `get_element_property_set_property_definitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PropertyDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_property_sets(self, cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_element_property_sets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_sets(cloud_pk, element_uuid, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[PropertySet]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_element_property_sets_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_property_sets_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_element_property_sets_with_http_info(self, cloud_pk, element_uuid, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_element_property_sets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_element_property_sets_with_http_info(cloud_pk, element_uuid, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[PropertySet]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_property_sets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_element_property_sets`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `get_element_property_sets`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_element_property_sets`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_element_property_sets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PropertySet]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_elements(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elements(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str type: Filter the returned list by type
        :param str classification: Filter the returned list by classification
        :param str classification__notation: Filter the returned list by classification__notation
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_elements_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_elements_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_elements_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elements_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str type: Filter the returned list by type
        :param str classification: Filter the returned list by classification
        :param str classification__notation: Filter the returned list by classification__notation
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'type', 'classification', 'classification__notation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_elements" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_elements`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_elements`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'classification' in local_var_params:
            query_params.append(('classification', local_var_params['classification']))  # noqa: E501
        if 'classification__notation' in local_var_params:
            query_params.append(('classification__notation', local_var_params['classification__notation']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Element]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_elements_from_classification(self, cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_elements_from_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elements_from_classification(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_classification_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_elements_from_classification_with_http_info(self, cloud_pk, ifc_classification_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_elements_from_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_classification_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Element]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_classification_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_elements_from_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'ifc_classification_pk' is set
        if ('ifc_classification_pk' not in local_var_params or
                local_var_params['ifc_classification_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_classification_pk` when calling `get_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_elements_from_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_classification_pk' in local_var_params:
            path_params['ifc_classification_pk'] = local_var_params['ifc_classification_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/classification/{ifc_classification_pk}/element', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Element]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: Ifc
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: Ifc
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ifc',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_bvh(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_bvh  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the bvh file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_bvh(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_bvh_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_bvh_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_bvh_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_bvh  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the bvh file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_bvh_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_bvh" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_bvh`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_bvh`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_bvh`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}/bvh', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_classifications(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_classifications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_classifications(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_classifications_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_classifications_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_classifications_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_classifications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_classifications_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Classification]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_classifications" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_classifications`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_ifc_classifications`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_classifications`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/classification', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Classification]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_gltf(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_gltf  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the gltf file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_gltf(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_gltf_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_gltf_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_gltf_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_gltf  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the gltf file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_gltf_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_gltf" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_gltf`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_gltf`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_gltf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}/gltf', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_map(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_map  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the map file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_map(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_map_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_map_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_map_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_map  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the map file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_map_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_map" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_map`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_map`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}/map', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_properties(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_properties(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_properties_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_properties_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_properties_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_properties_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[ModelProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_properties`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_ifc_properties`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ModelProperty]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_property(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_property(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_property_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_property`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_ifc_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_property_definition(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_property_definition(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_property_definition_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertydefinition/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertyDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_property_definitions(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_property_definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_property_definitions(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[PropertyDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_property_definitions_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_property_definitions_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_property_definitions_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_property_definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_property_definitions_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[PropertyDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_property_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_property_definitions`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_ifc_property_definitions`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_property_definitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertydefinition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PropertyDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_structure(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_structure  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the structure file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_structure(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_structure_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_structure_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_structure_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_structure  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the structure file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_structure_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_structure" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_structure`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_structure`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_structure`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}/structure', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_systems(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_systems  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the system file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_systems(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_systems_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_systems_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_systems_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """get_ifc_systems  # noqa: E501

                 DEPRECATED: Now, retrieve the file url in the ifc object itself         Returns the system file           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_systems_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_systems" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_systems`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_systems`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_systems`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}/systems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_unit(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_unit(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_unit_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_unit`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ifc_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_ifc_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/unit/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Unit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifc_units(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_units  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_units(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Unit]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifc_units_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifc_units_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifc_units_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifc_units  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifc_units_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Unit]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifc_units" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifc_units`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_ifc_units`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifc_units`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/unit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Unit]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ifcs(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifcs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifcs(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str status: Filter the returned list by status
        :return: list[Ifc]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ifcs_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ifcs_with_http_info(cloud_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_ifcs_with_http_info(self, cloud_pk, project_pk, **kwargs):  # noqa: E501
        """get_ifcs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ifcs_with_http_info(cloud_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str project_pk: (required)
        :param str status: Filter the returned list by status
        :return: list[Ifc]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'project_pk', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ifcs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_ifcs`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_ifcs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []
        if 'status' in local_var_params:
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Ifc]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_property_set(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_property_set(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_property_set_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_property_set`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertySet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_property_sets(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_property_sets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_property_sets(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[PropertySet]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_property_sets_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_property_sets_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_property_sets_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_property_sets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_property_sets_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[PropertySet]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_property_sets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_property_sets`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_property_sets`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_property_sets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PropertySet]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_elements(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_raw_elements  # noqa: E501

                 Returns elements ,property_sets, properties, definitions and units in a optimized structure           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_elements(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str type: Filter the returned list by type
        :param str classification: Filter the returned list by classification
        :param str classification__notation: Filter the returned list by classification__notation
        :return: RawElements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_elements_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_elements_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_raw_elements_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_raw_elements  # noqa: E501

                 Returns elements ,property_sets, properties, definitions and units in a optimized structure           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_elements_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str type: Filter the returned list by type
        :param str classification: Filter the returned list by classification
        :param str classification__notation: Filter the returned list by classification__notation
        :return: RawElements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'type', 'classification', 'classification__notation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_elements" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_raw_elements`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_raw_elements`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_raw_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'classification' in local_var_params:
            query_params.append(('classification', local_var_params['classification']))  # noqa: E501
        if 'classification__notation' in local_var_params:
            query_params.append(('classification__notation', local_var_params['classification__notation']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/raw', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RawElements',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_space(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_space(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/space/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_spaces(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_spaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_spaces(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_spaces_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_spaces_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_spaces_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_spaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_spaces_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_spaces" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_spaces`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_spaces`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_spaces`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/space', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Space]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_zone(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zone(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_zone_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zone" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_zone`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_zone`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_zone`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_zone_space(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs):  # noqa: E501
        """get_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zone_space(cloud_pk, id, ifc_pk, project_pk, zone_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs)  # noqa: E501
            return data

    def get_zone_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, **kwargs):  # noqa: E501
        """get_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'zone_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zone_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_zone_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_zone_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_zone_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_pk' is set
        if ('zone_pk' not in local_var_params or
                local_var_params['zone_pk'] is None):
            raise ValueError("Missing the required parameter `zone_pk` when calling `get_zone_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'zone_pk' in local_var_params:
            path_params['zone_pk'] = local_var_params['zone_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{zone_pk}/space/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ZoneSpace',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_zone_spaces(self, cloud_pk, ifc_pk, project_pk, zone_pk, **kwargs):  # noqa: E501
        """get_zone_spaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zone_spaces(cloud_pk, ifc_pk, project_pk, zone_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :return: list[ZoneSpace]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_zone_spaces_with_http_info(cloud_pk, ifc_pk, project_pk, zone_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_zone_spaces_with_http_info(cloud_pk, ifc_pk, project_pk, zone_pk, **kwargs)  # noqa: E501
            return data

    def get_zone_spaces_with_http_info(self, cloud_pk, ifc_pk, project_pk, zone_pk, **kwargs):  # noqa: E501
        """get_zone_spaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zone_spaces_with_http_info(cloud_pk, ifc_pk, project_pk, zone_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :return: list[ZoneSpace]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'zone_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zone_spaces" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_zone_spaces`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_zone_spaces`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_zone_spaces`")  # noqa: E501
        # verify the required parameter 'zone_pk' is set
        if ('zone_pk' not in local_var_params or
                local_var_params['zone_pk'] is None):
            raise ValueError("Missing the required parameter `zone_pk` when calling `get_zone_spaces`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'zone_pk' in local_var_params:
            path_params['zone_pk'] = local_var_params['zone_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{zone_pk}/space', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ZoneSpace]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_zones(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_zones  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zones(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str color: Filter the returned list by color
        :return: list[Zone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_zones_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.get_zones_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def get_zones_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """get_zones  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zones_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str color: Filter the returned list by color
        :return: list[Zone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'color']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zones" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `get_zones`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `get_zones`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `get_zones`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []
        if 'color' in local_var_params:
            query_params.append(('color', local_var_params['color']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Zone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_classification_element_relations(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """list_classification_element_relations  # noqa: E501

                     list association between classifications and elements           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_classification_element_relations(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[ElementClassificationRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_classification_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.list_classification_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def list_classification_element_relations_with_http_info(self, cloud_pk, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """list_classification_element_relations  # noqa: E501

                     list association between classifications and elements           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_classification_element_relations_with_http_info(cloud_pk, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: list[ElementClassificationRelation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_classification_element_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `list_classification_element_relations`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `list_classification_element_relations`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `list_classification_element_relations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/classification-element', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ElementClassificationRelation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_classification_of_element(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """remove_classification_of_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_classification_of_element(cloud_pk, element_uuid, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_classification_of_element_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_classification_of_element_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def remove_classification_of_element_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """remove_classification_of_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_classification_of_element_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this classification. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_classification_of_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `remove_classification_of_element`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `remove_classification_of_element`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_classification_of_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `remove_classification_of_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `remove_classification_of_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/classification/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_element_property_set(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """remove_element_property_set  # noqa: E501

                 Delete the relation between the element and the property set. Does not delete any object       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set(cloud_pk, element_uuid, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property set. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_element_property_set_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_element_property_set_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs)  # noqa: E501
            return data

    def remove_element_property_set_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, **kwargs):  # noqa: E501
        """remove_element_property_set  # noqa: E501

                 Delete the relation between the element and the property set. Does not delete any object       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property set. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_element_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `remove_element_property_set`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `remove_element_property_set`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_element_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `remove_element_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `remove_element_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_element_property_set_property(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs):  # noqa: E501
        """remove_element_property_set_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set_property(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_element_property_set_property_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_element_property_set_property_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def remove_element_property_set_property_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, **kwargs):  # noqa: E501
        """remove_element_property_set_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set_property_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str propertyset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_element_property_set_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `remove_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `remove_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `remove_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `remove_element_property_set_property`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `remove_element_property_set_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_element_property_set_property_definition(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs):  # noqa: E501
        """remove_element_property_set_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set_property_definition(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property definition. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def remove_element_property_set_property_definition_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, **kwargs):  # noqa: E501
        """remove_element_property_set_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set_property_definition_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this property definition. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertyset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk', 'property_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_element_property_set_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `remove_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `remove_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `remove_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `remove_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `remove_element_property_set_property_definition`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `remove_element_property_set_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_element_property_set_property_definition_unit(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs):  # noqa: E501
        """remove_element_property_set_property_definition_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set_property_definition_unit(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this unit. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs)  # noqa: E501
            return data

    def remove_element_property_set_property_definition_unit_with_http_info(self, cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, **kwargs):  # noqa: E501
        """remove_element_property_set_property_definition_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_element_property_set_property_definition_unit_with_http_info(cloud_pk, element_uuid, id, ifc_pk, project_pk, property_pk, propertydefinition_pk, propertyset_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str element_uuid: (required)
        :param int id: A unique integer value identifying this unit. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str property_pk: (required)
        :param str propertydefinition_pk: (required)
        :param str propertyset_pk: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'element_uuid', 'id', 'ifc_pk', 'project_pk', 'property_pk', 'propertydefinition_pk', 'propertyset_pk']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_element_property_set_property_definition_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'element_uuid' is set
        if ('element_uuid' not in local_var_params or
                local_var_params['element_uuid'] is None):
            raise ValueError("Missing the required parameter `element_uuid` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'property_pk' is set
        if ('property_pk' not in local_var_params or
                local_var_params['property_pk'] is None):
            raise ValueError("Missing the required parameter `property_pk` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'propertydefinition_pk' is set
        if ('propertydefinition_pk' not in local_var_params or
                local_var_params['propertydefinition_pk'] is None):
            raise ValueError("Missing the required parameter `propertydefinition_pk` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501
        # verify the required parameter 'propertyset_pk' is set
        if ('propertyset_pk' not in local_var_params or
                local_var_params['propertyset_pk'] is None):
            raise ValueError("Missing the required parameter `propertyset_pk` when calling `remove_element_property_set_property_definition_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'element_uuid' in local_var_params:
            path_params['element_uuid'] = local_var_params['element_uuid']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'property_pk' in local_var_params:
            path_params['property_pk'] = local_var_params['property_pk']  # noqa: E501
        if 'propertydefinition_pk' in local_var_params:
            path_params['propertydefinition_pk'] = local_var_params['propertydefinition_pk']  # noqa: E501
        if 'propertyset_pk' in local_var_params:
            path_params['propertyset_pk'] = local_var_params['propertyset_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{element_uuid}/propertyset/{propertyset_pk}/property/{property_pk}/propertydefinition/{propertydefinition_pk}/unit/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_elements_from_classification(self, cloud_pk, ifc_classification_pk, ifc_pk, project_pk, uuid, **kwargs):  # noqa: E501
        """remove_elements_from_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_elements_from_classification(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_classification_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, uuid, **kwargs)  # noqa: E501
            return data

    def remove_elements_from_classification_with_http_info(self, cloud_pk, ifc_classification_pk, ifc_pk, project_pk, uuid, **kwargs):  # noqa: E501
        """remove_elements_from_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_elements_from_classification_with_http_info(cloud_pk, ifc_classification_pk, ifc_pk, project_pk, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_classification_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_classification_pk', 'ifc_pk', 'project_pk', 'uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_elements_from_classification" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `remove_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'ifc_classification_pk' is set
        if ('ifc_classification_pk' not in local_var_params or
                local_var_params['ifc_classification_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_classification_pk` when calling `remove_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `remove_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `remove_elements_from_classification`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if ('uuid' not in local_var_params or
                local_var_params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `remove_elements_from_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_classification_pk' in local_var_params:
            path_params['ifc_classification_pk'] = local_var_params['ifc_classification_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/classification/{ifc_classification_pk}/element/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_element(self, cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs):  # noqa: E501
        """update_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_element(cloud_pk, ifc_pk, project_pk, uuid, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :param Element element: (required)
        :return: Element
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs)  # noqa: E501
        else:
            (data) = self.update_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs)  # noqa: E501
            return data

    def update_element_with_http_info(self, cloud_pk, ifc_pk, project_pk, uuid, element, **kwargs):  # noqa: E501
        """update_element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_element_with_http_info(cloud_pk, ifc_pk, project_pk, uuid, element, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str uuid: IFC element or element type UUID (required)
        :param Element element: (required)
        :return: Element
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'ifc_pk', 'project_pk', 'uuid', 'element']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_element`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_element`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_element`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if ('uuid' not in local_var_params or
                local_var_params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `update_element`")  # noqa: E501
        # verify the required parameter 'element' is set
        if ('element' not in local_var_params or
                local_var_params['element'] is None):
            raise ValueError("Missing the required parameter `element` when calling `update_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'element' in local_var_params:
            body_params = local_var_params['element']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/element/{uuid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Element',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ifc(self, cloud_pk, id, project_pk, ifc, **kwargs):  # noqa: E501
        """update_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc(cloud_pk, id, project_pk, ifc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :param Ifc ifc: (required)
        :return: Ifc
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ifc_with_http_info(cloud_pk, id, project_pk, ifc, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ifc_with_http_info(cloud_pk, id, project_pk, ifc, **kwargs)  # noqa: E501
            return data

    def update_ifc_with_http_info(self, cloud_pk, id, project_pk, ifc, **kwargs):  # noqa: E501
        """update_ifc  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_with_http_info(cloud_pk, id, project_pk, ifc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :param Ifc ifc: (required)
        :return: Ifc
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'ifc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ifc" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_ifc`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_ifc`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_ifc`")  # noqa: E501
        # verify the required parameter 'ifc' is set
        if ('ifc' not in local_var_params or
                local_var_params['ifc'] is None):
            raise ValueError("Missing the required parameter `ifc` when calling `update_ifc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ifc' in local_var_params:
            body_params = local_var_params['ifc']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ifc',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ifc_files(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """update_ifc_files  # noqa: E501

                 Patch ifc files (gltf, structure, svg, etc)           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_files(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :param file structure_file:
        :param file systems_file:
        :param file map_file:
        :param file gltf_file:
        :param file bvh_tree_file:
        :return: IfcFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ifc_files_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ifc_files_with_http_info(cloud_pk, id, project_pk, **kwargs)  # noqa: E501
            return data

    def update_ifc_files_with_http_info(self, cloud_pk, id, project_pk, **kwargs):  # noqa: E501
        """update_ifc_files  # noqa: E501

                 Patch ifc files (gltf, structure, svg, etc)           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_files_with_http_info(cloud_pk, id, project_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this ifc. (required)
        :param str project_pk: (required)
        :param file structure_file:
        :param file systems_file:
        :param file map_file:
        :param file gltf_file:
        :param file bvh_tree_file:
        :return: IfcFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'project_pk', 'structure_file', 'systems_file', 'map_file', 'gltf_file', 'bvh_tree_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ifc_files" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_ifc_files`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_ifc_files`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_ifc_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'structure_file' in local_var_params:
            local_var_files['structure_file'] = local_var_params['structure_file']  # noqa: E501
        if 'systems_file' in local_var_params:
            local_var_files['systems_file'] = local_var_params['systems_file']  # noqa: E501
        if 'map_file' in local_var_params:
            local_var_files['map_file'] = local_var_params['map_file']  # noqa: E501
        if 'gltf_file' in local_var_params:
            local_var_files['gltf_file'] = local_var_params['gltf_file']  # noqa: E501
        if 'bvh_tree_file' in local_var_params:
            local_var_files['bvh_tree_file'] = local_var_params['bvh_tree_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{id}/files', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IfcFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ifc_property(self, cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """update_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_property(cloud_pk, id, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param ModelProperty model_property: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs)  # noqa: E501
            return data

    def update_ifc_property_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, model_property, **kwargs):  # noqa: E501
        """update_ifc_property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_property_with_http_info(cloud_pk, id, ifc_pk, project_pk, model_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param ModelProperty model_property: (required)
        :return: ModelProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'model_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ifc_property" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_ifc_property`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_ifc_property`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_ifc_property`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_ifc_property`")  # noqa: E501
        # verify the required parameter 'model_property' is set
        if ('model_property' not in local_var_params or
                local_var_params['model_property'] is None):
            raise ValueError("Missing the required parameter `model_property` when calling `update_ifc_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_property' in local_var_params:
            body_params = local_var_params['model_property']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/property/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ifc_property_definition(self, cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs):  # noqa: E501
        """update_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_property_definition(cloud_pk, id, ifc_pk, project_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertyDefinition property_definition: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs)  # noqa: E501
            return data

    def update_ifc_property_definition_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, property_definition, **kwargs):  # noqa: E501
        """update_ifc_property_definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_property_definition_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertyDefinition property_definition: (required)
        :return: PropertyDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'property_definition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ifc_property_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_ifc_property_definition`")  # noqa: E501
        # verify the required parameter 'property_definition' is set
        if ('property_definition' not in local_var_params or
                local_var_params['property_definition'] is None):
            raise ValueError("Missing the required parameter `property_definition` when calling `update_ifc_property_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_definition' in local_var_params:
            body_params = local_var_params['property_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertydefinition/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertyDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ifc_unit(self, cloud_pk, id, ifc_pk, project_pk, unit, **kwargs):  # noqa: E501
        """update_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_unit(cloud_pk, id, ifc_pk, project_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Unit unit: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, unit, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, unit, **kwargs)  # noqa: E501
            return data

    def update_ifc_unit_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, unit, **kwargs):  # noqa: E501
        """update_ifc_unit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ifc_unit_with_http_info(cloud_pk, id, ifc_pk, project_pk, unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Unit unit: (required)
        :return: Unit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'unit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ifc_unit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_ifc_unit`")  # noqa: E501
        # verify the required parameter 'unit' is set
        if ('unit' not in local_var_params or
                local_var_params['unit'] is None):
            raise ValueError("Missing the required parameter `unit` when calling `update_ifc_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit' in local_var_params:
            body_params = local_var_params['unit']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/unit/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Unit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_property_set(self, cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """update_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_property_set(cloud_pk, id, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertySet property_set: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
        else:
            (data) = self.update_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs)  # noqa: E501
            return data

    def update_property_set_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, property_set, **kwargs):  # noqa: E501
        """update_property_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_property_set_with_http_info(cloud_pk, id, ifc_pk, project_pk, property_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param str id: (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param PropertySet property_set: (required)
        :return: PropertySet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'property_set']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_property_set" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_property_set`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_property_set`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_property_set`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_property_set`")  # noqa: E501
        # verify the required parameter 'property_set' is set
        if ('property_set' not in local_var_params or
                local_var_params['property_set'] is None):
            raise ValueError("Missing the required parameter `property_set` when calling `update_property_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'property_set' in local_var_params:
            body_params = local_var_params['property_set']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/propertyset/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PropertySet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_space(self, cloud_pk, id, ifc_pk, project_pk, space, **kwargs):  # noqa: E501
        """update_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_space(cloud_pk, id, ifc_pk, project_pk, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Space space: (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, space, **kwargs)  # noqa: E501
        else:
            (data) = self.update_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, space, **kwargs)  # noqa: E501
            return data

    def update_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, space, **kwargs):  # noqa: E501
        """update_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Space space: (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_space`")  # noqa: E501
        # verify the required parameter 'space' is set
        if ('space' not in local_var_params or
                local_var_params['space'] is None):
            raise ValueError("Missing the required parameter `space` when calling `update_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'space' in local_var_params:
            body_params = local_var_params['space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/space/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_zone(self, cloud_pk, id, ifc_pk, project_pk, zone, **kwargs):  # noqa: E501
        """update_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_zone(cloud_pk, id, ifc_pk, project_pk, zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Zone zone: (required)
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone, **kwargs)  # noqa: E501
        else:
            (data) = self.update_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone, **kwargs)  # noqa: E501
            return data

    def update_zone_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, zone, **kwargs):  # noqa: E501
        """update_zone  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_zone_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this zone. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param Zone zone: (required)
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_zone" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_zone`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_zone`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_zone`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_zone`")  # noqa: E501
        # verify the required parameter 'zone' is set
        if ('zone' not in local_var_params or
                local_var_params['zone'] is None):
            raise ValueError("Missing the required parameter `zone` when calling `update_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone' in local_var_params:
            body_params = local_var_params['zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_zone_space(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs):  # noqa: E501
        """update_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_zone_space(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :param ZoneSpace zone_space: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs)  # noqa: E501
        else:
            (data) = self.update_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs)  # noqa: E501
            return data

    def update_zone_space_with_http_info(self, cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, **kwargs):  # noqa: E501
        """update_zone_space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_zone_space_with_http_info(cloud_pk, id, ifc_pk, project_pk, zone_pk, zone_space, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pk: (required)
        :param int id: A unique integer value identifying this space. (required)
        :param str ifc_pk: (required)
        :param str project_pk: (required)
        :param str zone_pk: (required)
        :param ZoneSpace zone_space: (required)
        :return: ZoneSpace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['cloud_pk', 'id', 'ifc_pk', 'project_pk', 'zone_pk', 'zone_space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_zone_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cloud_pk' is set
        if ('cloud_pk' not in local_var_params or
                local_var_params['cloud_pk'] is None):
            raise ValueError("Missing the required parameter `cloud_pk` when calling `update_zone_space`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_zone_space`")  # noqa: E501
        # verify the required parameter 'ifc_pk' is set
        if ('ifc_pk' not in local_var_params or
                local_var_params['ifc_pk'] is None):
            raise ValueError("Missing the required parameter `ifc_pk` when calling `update_zone_space`")  # noqa: E501
        # verify the required parameter 'project_pk' is set
        if ('project_pk' not in local_var_params or
                local_var_params['project_pk'] is None):
            raise ValueError("Missing the required parameter `project_pk` when calling `update_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_pk' is set
        if ('zone_pk' not in local_var_params or
                local_var_params['zone_pk'] is None):
            raise ValueError("Missing the required parameter `zone_pk` when calling `update_zone_space`")  # noqa: E501
        # verify the required parameter 'zone_space' is set
        if ('zone_space' not in local_var_params or
                local_var_params['zone_space'] is None):
            raise ValueError("Missing the required parameter `zone_space` when calling `update_zone_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pk' in local_var_params:
            path_params['cloud_pk'] = local_var_params['cloud_pk']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'ifc_pk' in local_var_params:
            path_params['ifc_pk'] = local_var_params['ifc_pk']  # noqa: E501
        if 'project_pk' in local_var_params:
            path_params['project_pk'] = local_var_params['project_pk']  # noqa: E501
        if 'zone_pk' in local_var_params:
            path_params['zone_pk'] = local_var_params['zone_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone_space' in local_var_params:
            body_params = local_var_params['zone_space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/cloud/{cloud_pk}/project/{project_pk}/ifc/{ifc_pk}/zone/{zone_pk}/space/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ZoneSpace',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
