from typing import TypeVar, Generic, Any

from bfp_rs import ByteStream, Version

T = TypeVar("T")

class Array(Generic[T]):
    """
    """

    @classmethod
    def to_bytes(cls, value: list[T]) -> bytes: ...

    @classmethod
    def from_stream(cls, value: ByteStream, ver: Version = Version(0)) -> list[T]: ...

    @classmethod
    def from_file(cls, filepath: str) -> list[T]: ...

    @classmethod
    def from_bytes(cls, bytes_: bytes, ver: Version = Version(0)) -> list[T]: ...

    @classmethod
    def to_file(cls, filepath: str, value: list[T]): ...

    @classmethod
    def __class_getitem__(cls, item: Any) -> type: ...

class Array8(Array[T], Generic[T]): ...
class Array16(Array[T], Generic[T]): ...
class Array32(Array[T], Generic[T]): ...
class Array64(Array[T], Generic[T]): ...
class Array128(Array[T], Generic[T]): ...
