from typing import Type, TypeVar, Generic

from bfp_rs import ByteStream, Version, BaseStruct
from bfp_rs.types.le import Option

T = TypeVar("T", bound = BaseStruct | Option)

class StackedAttrArray(Generic[T]):
    """
    """

    @classmethod
    def to_bytes(cls, value: list[T]) -> bytes: ...

    @classmethod
    def from_stream(cls, value: ByteStream, ver: Version = Version(0)) -> list[T]: ...

    @classmethod
    def from_file(cls, filepath: str) -> list[T]: ...

    @classmethod
    def from_bytes(cls, bytes_: bytes, ver: Version = Version(0)) -> list[T]: ...

    @classmethod
    def to_file(cls, filepath: str, value: list[T]): ...

    @classmethod
    def __class_getitem__(cls, item: Type[BaseStruct] | Type[Option]) -> type: ...

class StackedAttrArray8(StackedAttrArray[T], Generic[T]): ...
class StackedAttrArray16(StackedAttrArray[T], Generic[T]): ...
class StackedAttrArray32(StackedAttrArray[T], Generic[T]): ...
class StackedAttrArray64(StackedAttrArray[T], Generic[T]): ...
class StackedAttrArray128(StackedAttrArray[T], Generic[T]): ...
