from typing import TypeVar, Generic, Any

from bfp_rs import ByteStream, Version

T = TypeVar("T")

class StackedArray(Generic[T]):
    """
    """

    @classmethod
    def to_bytes(cls, value: list[list[T]]) -> bytes: ...

    @classmethod
    def from_stream(cls, value: ByteStream, ver: Version = Version(0)) -> list[list[T]]: ...

    @classmethod
    def from_file(cls, filepath: str) -> list[list[T]]: ...

    @classmethod
    def from_bytes(cls, bytes_: bytes, ver: Version = Version(0)) -> list[list[T]]: ...

    @classmethod
    def to_file(cls, filepath: str, value: list[list[T]]): ...

    @classmethod
    def __class_getitem__(cls, item: Any) -> type: ...

class StackedArray8(StackedArray[T], Generic[T]): ...
class StackedArray16(StackedArray[T], Generic[T]): ...
class StackedArray32(StackedArray[T], Generic[T]): ...
class StackedArray64(StackedArray[T], Generic[T]): ...
class StackedArray128(StackedArray[T], Generic[T]): ...
