#pragma once

#include <string>
#include <vector>
#include "extracted_string.hpp"
#include <unordered_set>

using namespace std;

#define WINDOW_SIZE 11

// Quick way of checking if a character value is displayable ascii
static bool is_displayable_ascii[0x100] =
	/*          0     1     2     3        4     5     6     7        8     9     A     B        C     D     E     F     */
	/* 0x00 */ {false,false,false,false,   false,false,false,false,   false,true ,true ,false,   false,true ,false,false,
	/* 0x10 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0x20 */  true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,
	/* 0x30 */  true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,
	/* 0x40 */  true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,
	/* 0x50 */  true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,
	/* 0x60 */  true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,
	/* 0x70 */  true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,true ,   true ,true ,true ,false,
	/* 0x80 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0x90 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0xA0 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0xB0 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0xC0 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0xD0 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0xE0 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false,
	/* 0xF0 */  false,false,false,false,   false,false,false,false,   false,false,false,false,   false,false,false,false};

// Maps the first 12 bits of a unicode character to the language group in Unicode BMP Plane0. Zero denotes not a valid language. See python code below.
// See ./../Tools/unicode_language_groups.py for the python code that generated this table.
static char bmp_12bits_to_group[0xFFF] = {
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	6,6,6,6,6,6,6,6,6,6,2,2,2,2,2,2,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,2,2,2,2,2,2,2,2,9,9,9,9,9,9,9,9,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,8,8,8,8,8,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,9,9,6,6,6,6,6,6,6,6,6,2,2,2,2,2,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,4,4,4,4,4,4,4,2,2,2,2,9,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,2,2,0,0,0,0,0,0,0,0,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,0,12,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,0,0,0,0,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,2,2,5,5,5,5,5,5,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,0,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,9,9,9,7,7,9,9,9,9,9,9,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,5,5,5,1,1,1,1,8,8,8,8,8,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,7,2,7,7,7,7,3,3,3,3,3,3,3,3,3,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
};

// List of common UNICODE characters seen at least once in CommonCrawl
// https://stackoverflow.com/questions/22184624/unicode-character-usage-statistics
// https://docs.google.com/spreadsheet/ccc?key=0AjHWiIkH6KdCdDd1TnppTnZub1k2MTNhV05xdk5yUXc&usp=sharing
// Note exclude 0xfeff byte order marker.
static std::unordered_set<char16_t> is_seen_commoncrawl({
		0x20,0x65,0x61,0x69,0x6f,0x74,0x6e,0x72,0x73,0xa,0x6c,0x64,0x63,0x75,0x68,0x6d,0xfffd,0x67,0x70,0x66,0x79,0x62,0x2e,0x30,0xa0,0x53,0x76,0x77,0x31,0x41,0x6b,0x32,0x2c,0x2d,0x43,0x54,0x45,0x4d,0x50,0x49,0x52,0x44,0x4c,0x42,0x33,0x4e,0x29,0x28,0x35,0x46,0x3a,0x4f,0x48,0x34,0x47,0x39,0x7a,0x57,0x78,0x56,0x36,0x2f,0x55,0x38,0xd,0x37,0x6a,0x4b,0x27,0x7c,0x4a,0xe9,0x71,0x59,0x30fc,0x306e,0x26,0x22,0x43e,0x430,0x438,0x435,0x3d,0x21,0x442,0x3e,0x3f,0x43d,0x51,0x30f3,0x5a,0x3044,0x441,0x30b9,0x306b,0x5b,0x30c8,0x5d,0x58,0x440,0x5f,0x24,0x3092,0x3002,0xfc,0x3059,0x308b,0x627,0x3001,0x3066,0x2a,0x30a4,0xe4,0x3057,0x43b,0x43a,0x306f,0x3b,0x432,0xa3,0x3067,0x25,0xf3,0x2b,0x307e,0xe1,0x305f,0x3068,0xf6,0x306a,0x304c,0x30c3,0x644,0x30af,0x30fb,0x30ea,0x43c,0x54c1,0x30e9,0x30eb,0x30a2,0x43f,0xe0,0x434,0x3000,0xed,0x30bf,0x304a,0x23,0x2019,0x30ab,0x3064,0x3053,0x308a,0x304b,0x30ec,0x645,0x44f,0x443,0x44c,0x64a,0x65e5,0x44b,0x30d3,0x3c,0x30d5,0x3089,0xbb,0x648,0x3063,0x3082,0x30b0,0x5d9,0x30b3,0x431,0x20ac,0x3046,0x304f,0x308c,0xa9,0x3055,0x631,0x5186,0x30de,0x30e5,0x5546,0x30d7,0x30e1,0xe8,0x30b7,0xff1a,0x7d,0x2013,0x7b,0x437,0x433,0x2022,0x6708,0x5e74,0x439,0x3060,0x30c6,0x672c,0x30c9,0x3093,0x62a,0x3042,0x661f,0x639,0x646,0x5d5,0x3061,0x131,0x25ba,0x30b5,0x898b,0x30b8,0x304d,0x4eba,0xe7,0x30d0,0x30e0,0x30a3,0x420,0x30c1,0x30ed,0x300c,0x300d,0x6599,0x6587,0x30df,0x40,0x628,0x4e2d,0x5de,0xf1,0x5e8,0x421,0xfa,0x65b0,0x7684,0x447,0xff09,0x7528,0xff08,0x4e00,0x3088,0x62f,0x446,0xf4,0x30ad,0x4f1a,0x307f,0x103,0x3051,0x203a,0x5c,0x5927,0x305b,0x629,0x30aa,0x5dc,0xff01,0x8005,0x633,0x15f,0x95,0x201c,0x4f5c,0xffe5,0x3054,0x5408,0x3081,0x5831,0xe5,0x647,0x2026,0x6700,0x10d,0xea,0x30a8,0x201d,0x60c5,0xb7,0x9001,0x142,0x30d6,0x445,0x5d1,0xdf,0x30a6,0x884c,0x308f,0x3079,0x30cb,0x5d4,0x41f,0x51fa,0x4e07,0x3048,0x5206,0x4ef6,0x643,0x5185,0x305d,0x641,0x30ba,0x5ea,0x642,0x436,0x3b1,0x7121,0x30c7,0x30bd,0x3084,0x30e7,0x41a,0xee,0x30da,0x4e0a,0x5165,0x5834,0x30bb,0x2014,0x3069,0x6642,0x6210,0x691c,0x30e3,0x65b9,0x30c0,0x30ca,0x412,0x30d9,0x30dd,0x66f8,0x5728,0x95a2,0x901a,0x5d0,0x41e,0x30c4,0x7d22,0x683c,0x7e,0x7269,0x444,0xe2,0x30d1,0x30d4,0x81ea,0x448,0x5eab,0xff0c,0x4ee5,0x5e97,0x56fd,0x30db,0x4fa1,0x44e,0x5dd,0xff5e,0x3b9,0x767b,0x33a1,0x6ce8,0x62c,0x8cb7,0x9593,0x80fd,0x6295,0xff06,0x5ba2,0x6c17,0xff1f,0x91d1,0x30ae,0x697d,0x5e9,0x62d,0x30a7,0x914d,0x5bb6,0xc774,0x5b50,0x4e0b,0x5e0,0x9,0x6a2a,0x3010,0x634,0x8a73,0x3011,0x3078,0x3b5,0x3bf,0x9332,0x69d8,0x5b9a,0x30ef,0x17e,0x6d5c,0xab,0x30ac,0x624b,0x119,0x5e2,0x5e6,0x653e,0x7d04,0x11f,0x521d,0x751f,0x5b66,0x793e,0x3bd,0x5c0f,0x5730,0x524d,0x8981,0x98f2,0x6570,0x30a1,0x161,0x53d6,0x30e6,0x5e4,0xdc,0x636,0x4f53,0x984c,0x308d,0xb0,0x30cd,0xe3,0x410,0x7a3f,0x7d30,0x3058,0x41d,0x449,0x767a,0x4ed8,0x6709,0x5d7,0x30b4,0x54e1,0x30b1,0x30b2,0x753b,0x7406,0x637,0x90e8,0x8457,0x15b,0x500b,0x640,0x5229,0x96c6,0x9023,0x635,0x301c,0x30dc,0x5168,0x7248,0x30d8,0x17c,0x5e,0x4fbf,0x591a,0x96fb,0x4ea4,0x60,0x5e1,0x540d,0x65c5,0x163,0x4e8b,0x7279,0x63a2,0x98df,0x4e0d,0x8003,0x53f0,0xb2e4,0xff11,0x8fbc,0xff5c,0x8ca9,0x5d3,0x8868,0xc3,0xb294,0x571f,0x97f3,0x25a0,0x5ba4,0xae,0x611f,0x8a18,0x5d2,0x53c2,0x5f97,0x89a7,0x6211,0x5177,0x8a9e,0x793a,0x52a0,0x4fe1,0x52d5,0x8aad,0x99c5,0x4ed6,0x63db,0x5c4b,0x529b,0x4f4d,0x418,0x305a,0x623,0x53ef,0x7d9a,0x3c4,0x58f2,0x304e,0x6027,0x5f53,0x66f4,0x5e38,0x5fc3,0x8a00,0x41c,0x898f,0x6728,0x9ad8,0x25cf,0x5df,0x649,0x516c,0x5929,0x7f51,0xff10,0x5668,0x601d,0x8fd4,0x4e86,0x6301,0x6cd5,0x3bc,0x130,0x53e3,0x753a,0x6771,0x5bb9,0x76ee,0xd6,0x422,0x548c,0x30e2,0x4f7f,0x3c3,0x92,0x307b,0x771f,0x30e4,0x5de5,0x3bb,0x6025,0x105,0x5ea6,0x5e02,0x5e7,0x554f,0x3080,0x3c1,0x5b89,0x610f,0x3c5,0xc5d0,0x5bfe,0x623f,0x958b,0x5973,0x30a9,0x5f8c,0x414,0x8c46,0x3083,0x2018,0x7acb,0x107,0xd7,0xd55c,0x6559,0x62e,0x7c73,0x7f8e,0x5db,0x4eca,0x5f0f,0x53e4,0x2192,0xc4,0x5916,0x7530,0x4ee3,0x44d,0xc758,0x76f8,0x5b9f,0x9762,0x5225,0x5fc5,0x3070,0xb85c,0x671f,0x8f09,0x660e,0x6a5f,0x662f,0x70b9,0x50cf,0xc9,0x4e88,0x9053,0x411,0x4e16,0x670d,0xc2a4,0x5199,0x3073,0xff12,0x30cf,0x6307,0x597d,0x9a13,0x6b69,0x30ce,0x4ecb,0x82b1,0x8ffd,0x72b6,0xae30,0x3b3,0x144,0x540c,0x5ddd,0x696d,0x417,0x7236,0x6240,0x535a,0x578b,0x897f,0xc9c0,0x6c34,0x5c45,0x8cc3,0xd558,0x2122,0x7a0e,0x5d8,0x3076,0x9650,0xc744,0x41b,0x30b6,0x7b49,0x6b21,0x266a,0x151,0x969b,0x77e5,0x451,0x53d7,0xc2dc,0xac00,0x8eca,0x6f14,0x7d39,0xc790,0x5149,0x80,0x78ba,0x203b,0x13e,0x2605,0x5473,0x544a,0x9152,0x5316,0x25bc,0xda,0x5d6,0x9078,0x4f1d,0x6d3b,0x8cb8,0x80b2,0xb2,0x8a08,0x5f92,0x5f79,0x5909,0x6cc1,0xc544,0xb4,0x8aac,0xc740,0x5c4a,0x6765,0xc1,0x7b2c,0x73fe,0x8fd1,0xc7,0x623b,0x2514,0x539f,0x6d77,0x5c71,0xbf,0xace0,0x66f2,0x56de,0x165,0x3b7,0x4e3b,0x5358,0x4fdd,0x5317,0x5468,0x89c6,0xc5b4,0x4f55,0x201e,0x8a71,0xc0ac,0x7523,0x8272,0xfb,0x89e3,0x756a,0x5bb4,0x8cbb,0x305e,0x30d2,0x306d,0x4eac,0x713c,0x8c61,0x3005,0x5cf6,0x8ac7,0x826f,0xc11c,0x60f3,0x6761,0x6b4c,0x25aa,0x3ba,0xf5,0x53f7,0x754c,0x7ba1,0x2606,0xb9ac,0x5357,0x6b63,0x8cfc,0xb300,0x5e2d,0x5230,0x91ce,0x8a2d,0xb5,0x5207,0x9580,0x413,0x3087,0x428,0x679c,0x63b2,0x9891,0x91cf,0xe32,0x9577,0x671b,0x4ea7,0xd3,0x7d50,0x7dda,0xa1,0x5148,0xc778,0x5411,0x632,0x90fd,0x6d0b,0x4f60,0x5c11,0xb77c,0x7a7a,0x7d61,0x3c2,0x6e80,0xb3c4,0xf9,0x63a,0xff13,0x3052,0xb97c,0x455,0x88fd,0x3af,0x3072,0x5e73,0xd654,0x706b,0x8a8d,0x5143,0x795e,0x5f71,0x630,0x6982,0x6f2b,0x201a,0xc77c,0x2039,0x5173,0x424,0x7535,0x63d0,0x300e,0x89b3,0x5178,0x300f,0x9664,0xff62,0xad6d,0xff63,0x7403,0x770b,0x622,0x59cb,0x6620,0x55b6,0x91cd,0x79c1,0x52e2,0x3056,0xfd,0x30f4,0xbcf4,0x4e50,0x592a,0x52a8,0x3050,0x4f9b,0x5f62,0x8a55,0x85,0x39c,0xb2c8,0x8fba,0xb4dc,0x985e,0x4ed5,0x4e8c,0x62a5,0x6cc,0x98a8,0x3ad,0x5c02,0x5e0c,0xd2b8,0x5238,0x88c5,0x141,0x415,0x4e09,0x16d,0x3a1,0x767d,0x7a2e,0xb098,0x4e2a,0x7b54,0x7533,0x8eab,0x6c42,0x7d4c,0x5f15,0x63a8,0xc218,0x6d41,0xb9cc,0x3c0,0x30f6,0x7cfb,0xd574,0x85e4,0x5b57,0x5bcc,0x5171,0x53cb,0x621,0xac8c,0x9032,0x7fcc,0x93,0x5efa,0x5065,0x7f6e,0xc788,0xff15,0x7fa9,0x7968,0xba,0x7ecf,0x64ad,0x8074,0x9774,0xd1,0x8cea,0x9054,0x975e,0xeb,0x6238,0x5fdc,0x8f7d,0x2500,0x7d42,0x57ce,0x5ca1,0x9752,0x5f37,0x4e1a,0x423,0x7740,0x53ce,0x8b1d,0x90ce,0xc804,0x11d,0x56f3,0x606f,0xe23,0x96,0xff0f,0x8054,0x251c,0x63a1,0xb8cc,0x7ae0,0x629e,0x770c,0x65ad,0x5ea7,0x672a,0x6b74,0x3ac,0x6bd4,0xc81c,0x5b58,0xc601,0x82f1,0x62b,0x118,0x8bc1,0x968e,0x3071,0x673a,0x625,0x79d1,0x57fa,0x641c,0x663e,0x76f4,0x3b2,0xc5,0xc694,0x8907,0x7d20,0x85cf,0xc815,0x6d17,0x8bc4,0xa5,0xc0c1,0x2190,0x7247,0x56fe,0x8db3,0x3ae,0x4ef7,0xff14,0x42f,0x7de8,0x904b,0x5236,0x6750,0x456,0x6caa,0x7c7b,0xff21,0x405,0x627f,0x8336,0x9875,0x72ec,0x9069,0x821e,0x53f8,0x518d,0x6237,0x5e2f,0xc73c,0x5e83,0x89d2,0x65e9,0x795d,0xc7a5,0x3c9,0x6226,0x8bba,0x798f,0x6280,0x533b,0x767e,0x53cd,0x5b8c,0x4f20,0x9244,0xb9c8,0x5982,0x403,0x3086,0x3b6,0x7ad9,0xb4e4,0x591c,0xbd80,0x5404,0x7a0b,0x4e0e,0x4e4b,0xc6b0,0xe19,0x52a9,0x2665,0x7b11,0x3ce,0x611b,0x666f,0x6577,0x3a3,0x7136,0xadf8,0x7edc,0x9996,0x457,0x300a,0x79fb,0x42d,0x4e8e,0x9055,0x7e41,0x2212,0x8d44,0x66dc,0x3cc,0x4f0a,0xff18,0xe17,0x8996,0x300b,0x5e7f,0x8089,0x171,0x8cc7,0xc5ec,0xbbf8,0x6536,0x542b,0xff4d,0x53d1,0x25c6,0x5ff5,0x8bb0,0x44a,0x83ef,0x8ad6,0x901f,0xacfc,0x6574,0x5eb7,0xff24,0xd0,0x626,0x6821,0x6b8b,0x84,0x685c,0xbb34,0x96d1,0xb3d9,0x6bb5,0x4f4e,0x8bf7,0xc131,0x521b,0x5341,0xe48,0xe07,0x63a5,0x8449,0x394,0xac10,0x7537,0xc2e0,0x6e29,0xcd,0x39d,0xc18c,0x391,0xc624,0x585a,0x6b64,0x9020,0x58eb,0x4f4f,0x30bc,0x70ed,0x53f2,0x4f01,0x8d77,0x8abf,0xc6d0,0x5948,0x7d44,0x2502,0x6539,0x7531,0x65bd,0x8a3c,0x69cb,0x4e3e,0x8679,0x8bb8,0x8bcd,0x6e08,0x6c38,0xc6b4,0x307c,0xc8fc,0x638,0x58f0,0xff0b,0x160,0x8d85,0x4e03,0xb178,0x5e78,0x9662,0x653f,0x982d,0x98ce,0xc720,0x9ebb,0x5e33,0xe40,0x305c,0x77f3,0x5bf9,0xe01,0x666e,0x8857,0x6c11,0x6b62,0xff19,0x4efb,0x4e3a,0xbe44,0x6d88,0x427,0x7565,0xbaa8,0x10c,0x5347,0x592b,0x6848,0x8ee2,0x3c6,0x520a,0x109,0x65e0,0x95ee,0x5df1,0x8fc7,0xe22,0x6ca2,0xc2,0x7cbe,0x805e,0x6df1,0x529f,0xd130,0x8853,0x101,0x5d0e,0x7c4d,0x9806,0x904e,0x67e,0xc640,0x5217,0x5f69,0xa7,0xe2d,0x6751,0x7522,0x8425,0x15e,0x559c,0x6253,0x5305,0x9500,0x7518,0x9031,0x738b,0x60a8,0x8def,0x8acb,0xd588,0x534a,0x9928,0x518c,0x5272,0x8cde,0xad6c,0x6398,0x9858,0x30e8,0x6781,0x3075,0x60c,0x6797,0x402,0x5bfa,0x679a,0x67e5,0x53bb,0x5f85,0x590f,0x4e57,0x9b54,0x406,0x6b66,0x7814,0x5fae,0xd0c0,0x9999,0x8b58,0xbc15,0x95e8,0x80e1,0x7389,0x8c37,0x5f55,0x52d9,0x6a21,0x82e5,0x5f7c,0x5011,0x7b80,0xc5f0,0xc791,0x395,0x3b4,0x4e21,0x9ad4,0x8377,0x8f6c,0x62e1,0x82b8,0x671d,0x5c55,0x7d0d,0xf2,0x81f4,0x65cf,0x5e2e,0x5145,0xff05,0x675f,0x6625,0x5da,0x7ea7,0x52a1,0x8bae,0xc9c4,0x8a8c,0xc801,0x7dcf,0x96e2,0xad,0xe21,0xacf3,0x5409,0x843d,0x9ec4,0x7bc9,0xba74,0x6cbb,0x516b,0x643a,0x6e38,0xff16,0xac1c,0xce58,0x6e2f,0x491,0x6703,0x2032,0x5fd8,0xff30,0x65f6,0x91cc,0x5bae,0xacf5,0x94,0x5275,0x57df,0xff0e,0x6ce2,0x5e03,0xc784,0x7981,0x8bfb,0x6c7a,0xc704,0xe41,0x4e45,0xb7ec,0xc138,0x2021,0x5bc6,0x604b,0x652f,0x6fc0,0xb808,0x4f86,0x573a,0x4e5f,0x458,0xe35,0x606d,0xef,0x533a,0x5712,0x5355,0x677f,0x522b,0x454,0x15a,0x4eec,0x8056,0x822c,0x7bc0,0x2193,0x7dd2,0x76e4,0x4f8b,0x5c06,0xff23,0x6e05,0x7b56,0x8535,0x6975,0xc6a9,0x7d99,0x4fc2,0x6255,0xac83,0x6749,0x5dfb,0x4e95,0x677e,0x5fa9,0x5099,0xad00,0x63cf,0x4e28,0x514b,0x6af,0x5802,0x3a0,0x7a4d,0xc990,0x5df4,0x8bbe,0x5e9c,0x95f4,0x61f,0x5947,0x8001,0xce,0x6613,0x3c7,0x5b9d,0x73b0,0x6271,0x7570,0x7d19,0xd504,0x80f8,0x547d,0xff1e,0x5370,0x5dde,0x7a76,0x899a,0x60aa,0x8208,0x7387,0x7ffb,0x672b,0x4e94,0x53ca,0xb9ce,0x7167,0x88cf,0x9898,0xff17,0x8fbe,0x96e3,0x8c6a,0x6839,0xcd9c,0x8c4a,0x5e3,0xbc14,0x6c5f,0x8a0e,0x9605,0x540e,0xba54,0xc911,0x8a33,0x565,0xe31,0x3008,0x3009,0x5e8a,0xff34,0x5287,0x5c31,0x8f38,0x5024,0x5de6,0xc124,0x7ebf,0x3cd,0x5708,0x72c2,0x7fa4,0xff43,0x4e1c,0xc120,0x52dd,0x5267,0x8fce,0x5bbf,0x9ea6,0x4fee,0xff57,0xe44,0x4e08,0x99ac,0xc870,0xb1,0x6885,0x5361,0xb370,0xd560,0x5fb7,0xc57c,0x8a66,0x5176,0x65af,0x40a,0x97d3,0x9b5a,0x4e18,0x25cb,0x7559,0x4e13,0x5339,0x5bf8,0x8349,0x6575,0x4f3c,0xa4,0xc0dd,
		0x620f,0x8ca0,0x8b1b,0x8b70,0x65bc,0x17a,0x672d,0xbc1c,0x827a,0xcd94,0xd1a0,0x425,0xd0a4,0x4f11,0x5b85,0x30be,0x3065,0x9632,0xcd5c,0x793c,0x8102,0x4e26,0x5f20,0x83dc,0xd68c,0x9019,0x89c8,0x9808,0x7231,0x9802,0xd30c,0x5922,0x594f,0x984d,0x5f00,0x5b63,0xc2b5,0x67fb,0x76db,0x4e92,0xbcf8,0x614b,0x547c,0x539a,0x97ff,0x5e2b,0x70ba,0xff3d,0x6697,0xb144,0x111,0xe49,0x5426,0x4e48,0x5747,0x5c1a,0xff3b,0x8077,0x159,0xc2e4,0xe04,0x641e,0x8fd9,0x8ba4,0x5531,0xb0b4,0x5f35,0x6cca,0x800c,0xff33,0x7bb1,0x7b1b,0x56db,0x56e3,0x6b73,0x98ef,0x512a,0x7aef,0x79f0,0x8fdb,0x68b1,0x5dee,0x8baf,0xce74,0x5f01,0x56e0,0x173,0xcc9c,0x523a,0x5bff,0x9ed2,0x957f,0x5343,0x6ca1,0x9045,0x6483,0x7d1a,0x7b97,0x6d4b,0x5883,0x6743,0x89aa,0x3041,0x5a31,0xba85,0xff2f,0x7d71,0x5f88,0x516d,0x5373,0x104,0xd604,0x3b8,0xff2c,0x5907,0x7d00,0x8a95,0xff22,0x5fa1,0x90a3,0xd53c,0x4e89,0x5c5e,0x6bce,0xac04,0x4e7e,0x773c,0x7d76,0xb514,0x64e,0x5e45,0xc785,0x5c40,0x5e94,0xacbd,0x62c5,0x8f6f,0x501f,0x7801,0xff4f,0x767c,0x7efc,0x5feb,0x15d,0x71b1,0x5ca9,0x96c4,0x6b7b,0x7384,0xd06c,0xc560,0x5224,0x57fc,0x6d4f,0x6216,0x8efd,0x786e,0x88ab,0x8bed,0x5931,0x53f3,0x75c5,0xd488,0x79cb,0x153,0x529e,0x8f03,0xb418,0x4e9b,0x135,0x76ca,0x8cac,0x9bae,0x5b9e,0xacc4,0xe2a,0x73a9,0xbc84,0x79d8,0x934b,0xff2b,0x8b66,0x514d,0x259,0x4ed9,0x52df,0xff65,0x663c,0x914e,0xb4f1,0x534e,0x7fd4,0x5e55,0xbc29,0xb9d0,0x6069,0x5c3e,0x6b32,0x8282,0x4ef2,0x5e30,0x6863,0x66ff,0x8217,0x904a,0xc7ac,0x6c41,0x63a7,0x8350,0x864e,0xba70,0xff1c,0x7c21,0x96a0,0xb798,0xac15,0x592e,0xbb3c,0x5e72,0x5354,0x505c,0x5b97,0x6e96,0x6218,0x7ed3,0x964d,0xd3ec,0x8a3a,0xc158,0x7834,0xd788,0x5bc4,0xff2a,0xa2,0xc5ed,0x4e01,0x8fb2,0xb9e4,0x117,0xd638,0x9988,0x6f1,0x9014,0x95dc,0x2020,0x6674,0xbb38,0x629c,0x8bd1,0x6545,0xbc88,0x306c,0x8d34,0xff32,0x674e,0x6d74,0x70ad,0xc5c8,0x5897,0x5348,0x6bba,0x5e26,0x9805,0xb41c,0xad50,0x7bc7,0xbc18,0x6a4b,0x68ee,0x9a6c,0x8f66,0x8bf4,0x9009,0xe6,0x3074,0x8feb,0x7fd2,0x8f91,0x5915,0xe1e,0xc5c5,0xff49,0x8239,0xcf54,0x5019,0xff2d,0x4f46,0x5e95,0x40f,0x536b,0xb2f9,0x672f,0x8d8a,0xbd84,0x839e,0x6d3e,0x12b,0xe30,0x732b,0x8d22,0x5170,0x7686,0x4f0e,0xe15,0x61c9,0xff2e,0x2028,0x5f25,0x6696,0x6392,0x5150,0x5df2,0xac01,0xc6d4,0xec,0x99a8,0x5e08,0x8d64,0xc74c,0x6e90,0x5727,0x5074,0x89c2,0x6e7e,0x6d66,0x534f,0x96e8,0x64b,0x202a,0x963f,0x6807,0x552e,0x2116,0x5e5,0x6f0,0xd1b5,0x416,0x6c7d,0x8ba9,0x5fd7,0x518a,0x8fdd,0x77ed,0xb824,0x716e,0xe27,0x8ca8,0xccb4,0xff36,0x8840,0x5f1f,0xbc30,0xe02,0x426,0xd5,0x71e5,0x102,0x74b0,0x5427,0xc0,0xa8,0x39f,0x6298,0xe08,0x56f2,0x56ed,0xff1b,0x453,0x6bdb,0xc18d,0xd310,0x4e70,0x6c0f,0x7a81,0x878d,0x301,0x624d,0xb974,0x7642,0xbc95,0xbcfc,0xc548,0x5c3d,0x7f57,0x8bd5,0x7159,0x8be5,0xff40,0x76e3,0x6bcf,0x590d,0x72af,0x7f8a,0x9b45,0x6cb9,0x9732,0xad8c,0x6f6e,0x7d75,0x52b9,0x52e4,0x75db,0x99d0,0x81f3,0x8ab0,0x5904,0xb3,0x76df,0xc6b8,0xff45,0x53ea,0x62db,0x6b53,0x8bdd,0xff25,0xe1a,0xb9c9,0x51b7,0x9a70,0xd589,0x5934,0x2191,0x6162,0x5438,0x8ddd,0xa6,0x6bcd,0x9589,0x4e38,0x4ec0,0x725b,0x708a,0x8846,0x5965,0xff41,0xff28,0x564c,0x8a2a,0xe20,0x393,0x4f50,0x5957,0x653b,0x6cb3,0x7b14,0xb9,0xc608,0x6837,0xc988,0x85ac,0x7fbd,0x822a,0x724c,0x8d39,0xb2e8,0x4f48,0x63f4,0x17b,0x8d2d,0xcc28,0x51fb,0xb09c,0x94d,0x83d3,0xff1d,0x7edf,0xd2f0,0x5e79,0x8fd8,0x5f8b,0x6001,0xac70,0x7948,0xb140,0xae08,0x21d2,0x4ffa,0xb450,0x7591,0xff53,0x9801,0x7f6a,0xb9e8,0xe42,0xe29,0x5b87,0x6a9,0x2200,0x6c49,0x5a92,0x6628,0x8c03,0x632f,0x53c8,0x7ec8,0x5417,0x9854,0xbe0c,0x25b6,0xe14,0xe25,0x9060,0x6770,0x5b98,0x65ec,0x9700,0x5a03,0xbaa9,0x8e8d,0x30fd,0xae00,0x6075,0x6557,0x82e6,0x5999,0x6563,0x3077,0x62e9,0x6fef,0x9280,0x9d8f,0x54f2,0x419,0xc9c1,0x7e54,0x51ac,0x53cc,0x7d14,0x3ca,0x8b77,0x50cd,0x59ff,0xb358,0xd50c,0x62cd,0xc800,0x5a5a,0x78ef,0x683d,0x6b22,0xb2a5,0x57f9,0x5bdd,0x699c,0x5bb3,0x51c6,0x79c0,0xf8,0x5175,0x7dd1,0x9759,0x73ed,0x94fa,0x820e,0x6e1b,0x8133,0x4eab,0x113,0x5ead,0x8d70,0xe34,0x6d44,0x5e76,0x6df7,0xc54a,0x6cbf,0x907a,0x570b,0x9a5a,0x98db,0x20aa,0x89c1,0x99,0x542c,0xb354,0xc5f4,0x7701,0xbd,0x25b2,0x6551,0x8af8,0x8ca1,0xae4c,0x66ae,0xff26,0x42c,0x4e73,0x62bc,0x745e,0x786c,0x8bda,0x6790,0x650,0x7ec6,0x6614,0xc6cc,0x39b,0x5ba1,0xc5c6,0xd45c,0xc288,0x1ebf,0x6f9,0x30a5,0x603b,0x525b,0x5e93,0x64ae,0x7ae5,0x888b,0x8edf,0x108,0x8a5e,0xb124,0x3085,0x5f3e,0x8896,0xb2ec,0x796d,0xce5c,0x88d5,0x9769,0x662d,0xb6,0x221e,0x5cb8,0x7db1,0x90f5,0x8ff7,0x9aa8,0x1ec7,0x8de1,0x5f80,0x7b7e,0x9ed1,0x89bd,0x73cd,0x6e58,0x79cd,0x836f,0xd0dc,0x4f26,0x91e3,0x9645,0x500d,0x52b4,0x5f31,0x8f93,0x98de,0x57cb,0xce90,0x62c9,0x6a19,0xc0b0,0x25ce,0x6311,0xb0a8,0xd3b8,0x6f5c,0x967a,0x3014,0xd6c4,0xd8,0x6c88,0x5247,0x3015,0x6843,0xcee4,0xc644,0x6388,0x7d66,0x9707,0x6e21,0x928,0x50b7,0x6f22,0xbcf5,0x4e9a,0x676f,0x6a39,0x6cc9,0xe43,0x554a,0x63ee,0x4f59,0xff31,0x52e7,0x4e5d,0x5c04,0x63da,0x967d,0x8f2a,0xb0a0,0x8655,0x8bbf,0xd398,0x88dc,0x6e2c,0x9f8d,0x5c0e,0x9686,0x93f,0x56fa,0x5e7c,0xff0d,0xb85d,0xadf9,0x53b3,0x80cc,0x7206,0x9ce5,0x968f,0x8587,0xc678,0x983c,0xcc98,0x3a6,0x8cc0,0xc21c,0x5098,0x711a,0x5352,0x5b88,0xd559,0x939,0x61b6,0x969c,0xe37,0xc885,0xc9d1,0x59d4,0xd14c,0x8bfa,0x7259,0x9000,0xc2dd,0x4f18,0x667a,0xb9ad,0x9084,0x50d5,0x8863,0xd22c,0xff29,0x5742,0x6c14,0x5237,0x6c96,0xc591,0xb3c5,0x940,0x5c07,0x8cb4,0x106,0xac74,0x9648,0xe16,0x524a,0x7d05,0x8a70,0x9803,0x59d3,0x7d5e,0x10e,0x697c,0x6d4e,0x7ea2,0x5cf0,0x81ed,0x6d25,0xb54c,0xff3e,0x59b9,0x5012,0x5584,0x72ac,0x7763,0xb791,0xbbfc,0x8ecd,0x60d1,0xb7f0,0x561,0x4f0f,0x8594,0x9ed8,0x682a,0x5a66,0xe2b,0xb9b0,0xc900,0x80aa,0x4e91,0x6b27,0xb825,0xcd08,0xac19,0xbbf,0x6e6f,0x638c,0x540,0x8fd0,0x575,0x652,0xbcd,0x6b65,0x392,0x576,0xc62c,0x580,0x6d32,0x17d,0x6b3e,0xff39,0x10f,0x6afb,0x96c5,0x8033,0x4ed4,0xac,0x62ec,0x6a29,0xaca9,0x5a18,0x6ce3,0xbb4,0x7f16,0x95b2,0xc810,0x16b,0xba4,0x9db4,0xc2ec,0xbae,0xacb0,0xff58,0x926,0x7af9,0x5553,0x79d2,0xc99d,0x5bfc,0x8179,0x6bbb,0x7b46,0x885b,0x9006,0x505a,0x9451,0x6669,0x7dca,0xd37c,0x7597,0xb204,0x900f,0x5979,0x639b,0x6717,0x96a3,0x7a97,0x8ff0,0xff4e,0x56c,0x9e97,0x76ae,0x8d23,0x578,0x5b09,0x582,0x885d,0x978b,0x7af6,0x52c9,0x7ed9,0x523b,0x5c64,0x566,0x7eb3,0x8131,0x96f0,0x266b,0xb8e8,0x6f2,0xe38,0x6dfb,0x8ae6,0x9003,0x714e,0x636e,0x81e8,0x9886,0x2693,0x70c8,0x4f38,0x7ec4,0x8c5a,0x626b,0x9669,0xae40,0x6362,0x8d24,0x83f2,0x517c,0x5951,0x7b52,0x8305,0x95d8,0x990a,0x8b,0x192,0x53d8,0x6e9d,0xff47,0x5009,0x84dd,0x8d08,0x51b3,0x51cd,0x5f84,0x6050,0x62ab,0x6c99,0x7576,0xb8,0xff3a,0x90,0x6676,0x67f4,0xff44,0x58c1,0x5458,0x5de8,0x8d28,0xbd88,0x4ece,0x8aa4,0x7db2,0xc558,0x5c08,0xc0bc,0xb9dd,0x642d,0x8584,0x6316,0x71c3,0x78bc,0x9a71,0x5f93,0x7267,0x698,0xff27,0x6309,0x6804,0x6c92,0x9818,0x8b0e,0xbc,0x69fd,0xc628,0xc98c,0x8fea,0xff35,0x9e7f,0x4f9d,0x9f99,0xd2b9,0x8d4f,0xbe14,0x5bdf,0x5f3a,0x6052,0x68c0,0x6dbc,0xbe,0x7ea6,0x8a13,0xd568,0x9519,0xd569,0x5869,0x968a,0x5ba3,0x5c01,0x6838,0x8a31,0x9910,0x541b,0xb978,0x67c4,0x7e04,0x5e7b,0xb7fd,0xcb48,0x8150,0xff52,0x7720,0xff20,0x4e39,0x6d45,0x6163,0xbca0,0x9b3c,0x75c7,0x626e,0x62b1,0x12f,0x628a,0xd328,0x3a4,0x5e7e,0xff4b,0x25c7,0xaa,0xcef4,0x602a,0x6d6a,0x79e4,0x8ab2,0x307d,0x5340,0x6635,0x5e36,0x5acc,0x6a23,0x148,0x97,0x8da3,0x98fe,0x600e,0x8fde,0xbabb,0x5f66,0xb3cc,0xd074,0x5fb3,0x6297,0x93e,0x5264,0x56f0,0x7df4,0x8ba2,0xbd81,0x3007,0x30cc,0x6d99,0xd615,0x4e32,0x6756,0xb984,0xd0b9,0x25ab,0x5bf5,0xc139,0x2010,0x521a,0x61f8,0xd5a5,0x7c8b,0x82ae,0x2c8,0x66fe,0x64f,0x5f18,0x8352,0x8bc9,0xb530,0x1,0x60b2,0x66b4,0x42b,0xff9e,0x51e6,0x6319,0x7c89,0x589e,0x8111,0x5fcd,0x4e71,0xff9d,0x79df,0x7dba,0x9038,0x51c4,0x64d,0x696a,0x7a40,0x5be7,0x9b42,0xff54,0x9177,0x9cf4,0x65e7,0x5c0d,0x8fa6,0x5386,0x5439,0x92fc,0x9876,0x42e,0x6368,0x82af,0x624,0x67d3,0x6e56,0x6ede,0x80a9,0x5de7,0x62d2,0x8ba1,0x226a,0x53eb,0x226b,0x9633,0x987e,0x6279,0x7126,0xbcc0,0xd3ed,0x732e,0x6691,0x62fc,0x6f2c,0x219,0x987b,0xbc1b,0xc0c8,0xc874,0x670b,0x4e14,0x53ec,0x55ae,0x962a,0xcd1d,0x5b99,0x93e1,0x5510,0x6cf0,0x7a74,0x8b6f,0xc838,0x502b,0x5091,0x5144,0x91c7,0xc708,0x5211,0x5b22,0x5fe1,0x6597,0xac1d,0xc561,0x5e8f,0x62bd,0x6db2,0x75b2,0xba3c,0xc5d1,0x8fc5,0x9298,0xd65c,0x4e3d,0xac80,0xc55e,0x6ee1,0xafb8,0xce68,0xe33,0x6d6e,0xae09,0xff38,0x40b,0x6ea2,0x80a1,0x90f7,0x95c7,0x866b,0x89e6,0x4ec5,0x585e,0xc0c9,0xcc38,0x5256,0x96f7,0x53e6,0x64cd,0x7e70,0xb108,0x5371,0xce20,0xd655,0x200e,0xbd09,0x5375,0x5b54,0xd3c9,0x6591,0x804c,0x9154,0xb860,0x4ea1,0x83ca,0x96ea,0x640d,0x6f3,0x54ea,0xb9bf,0x12e,0x679d,0x5f48,0x6850,0xc808,0x4f5b,0x6d1b,0x8010,0x89c9,0xb290,0x54e6,0x6e09,0xb78c,0x62f3,0x8207,0x8aaa,0x651,0x2015,0x582a,0x62fe,0xc721,0xd48d,0x5e16,0x5036,0x6c23,0x202c,0x4ec1,0x513f,0x719f,0xb79c,0x5360,0x8bca,0xcc44,0x7dbf,0xc54c,0x6de1,0x5bd2,0x9903,0x8499,0xe,0x526f,0x5c3b,0x8fdc,0x9ede,0x88c1,0x89c0,0x59c6,0xc637,0x6bbf,0x9375,0xd32c,0x56c3,0x7b4b,0x8155,0xc9f1,0x65e8,0x6682,0xd608,0xb610,0xccad,0x4ecf,0x656c,0x76d1,0xba38,0x50ac,0x8fb9,0x5ee3,0x7edd,0xbd04,0x4efd,0x5356,0x6566,0x7b26,0x7b51,0x8fc4,0xff4c,0x68d2,0xb208,0xc5b8,0x4e66,0x7965,0x8d41,0x627e,0x6b20,0x388,0xc600,0x5218,0x59bb,0x65e2,0x67cf,0x90a6,0xbc8c,0x26a,0x6377,0x7c92,0x6236,0x8f9b,0x584a,0x72d9,0xaed8,0x654f,0x8b21,0x8d05,0x9d28,0xd0c8,0x702c,0x76d7,0x39a,0x7761,0xc9c8,0x658e,0x842c,0xd5d8,0x707d,0xc5d8,0x25b,0x62e0,0x5f90,0x8aa0,0xb2cc,0x6c5a,0x8108,0x9f62,0x7232,0x5374,0x5b8f,0x5fb4,0x932c,0x70cf,0xd734,0xc8,0x67b6,0xe1b,0x3012,0x6e7f,0x907f,0x68da,0x7372,0x8ca7,0x8dd1,0x9a12,0x170,0x5403,0xb7fc,0x8df5,0x5e6b,0x8cbc,0xad70,0xbc1d,0xbdf0,0x7ef5,0xff42,0x46a,0x690d,0xd4,0xc6c0,0x52c7,0x7473,0xb80c,0x5076,0x6bd2,0x2588,0x5800,0x718a,0x808c,0xc5c4,0x7a93,0x5c65,0xff9f,0x92b7,0x309c,0x5bbd,0x9811,0x9f13,0x4f17,0x4fca,0x4fe3,0x5382,0x6589,0x690e,0x81a8,0x9694,0x8cdb,0xb410,0x6fa4,0x5757,0x88e1,0xd9,0x5f9e,0x723e,0x8302,0x8f6e,0x952e,0xb809,0x59d0,0x6fc3,0x7de0,0x4e3c,0xaca0,0xff0a,0xff70,0x82,0xd765,0x21b,0x76d8,0x7a3d,0x8be6,0xc05c,0xcf00,0x279,0x92e,0x5c42,0x80a5,0x9591,0xd669,0x4e49,0x5e86,0x8138,0x9ebd,0xcfe0,0x61d0,0x73e0,0x970a,0xc88b,0x7e2e,0x5609,0x651d,0x2030,0x4e24,0x503c,0x51a0,0x6012,0x8a02,0x8c22,0xc545,0x4ead,0x5353,0x5e84,0x62dd,0x723d,0x8b93,0x9690,0xe09,0x53e5,0x72d7,0x9ece,0xc1a1,
		0xe46,0x6841,0x5ef6,0xb9de,0x4eb2,0x59eb,0x5c14,0x8428,0x9663,0xc2f1,0x5f13,0x7956,0x9a8c,0x6aa2,0x94a2,0x98fc,0x9ea9,0x63c3,0x804a,0x829d,0xe0a,0x2033,0x9304,0x932f,0xc9d5,0x1a,0x143,0x4ee4,0x538b,0x52bf,0x58ca,0x6a31,0x8d1f,0x8df3,0xc2b4,0xd544,0xf0,0x7092,0xbcc4,0x11c,0x7802,0x99c6,0xac78,0xf713,0x9063,0xb828,0xff37,0x64c,0x5475,0xb4e0,0xc220,0xd658,0x5740,0x9670,0xbcd1,0x7d93,0xbc31,0x273f,0x5104,0x6383,0x680f,0x6a8e,0xadfc,0x9b,0x706f,0x75be,0x7a7f,0x8d27,0x8f1d,0xae38,0xcef5,0x60a9,0x8a34,0xb378,0xc368,0x5fe7,0xad11,0xff50,0xe4c,0x9283,0xaf,0x4e59,0x504f,0xb780,0x3be,0x7cd6,0x7d1b,0x51e0,0x55dc,0x6016,0x8be2,0xc0b4,0x5283,0x8a98,0x8caf,0xd76c,0x511f,0xb9b4,0x6811,0xc816,0x9d,0x4e60,0x5c16,0x6548,0x6ff1,0xb137,0xc6c3,0x686,0x5b5d,0x7652,0x805a,0x4fb5,0x52b2,0x5a01,0x2c7,0x4f73,0xcf58,0x91,0x200b,0x515a,0x5885,0x6578,0xb192,0xd1a4,0x5996,0x5bfb,0x5e01,0x626c,0x811a,0x9002,0x9178,0xbc00,0xc11d,0x6602,0x79bb,0x8a23,0x97e9,0xc5d4,0xe39,0xd15c,0xb839,0xc84c,0x4ebf,0x52aa,0x8b72,0x7a0d,0x90ed,0x9678,0x5716,0x5851,0x6247,0x6d78,0x7130,0x790e,0x67a0,0x7238,0x96be,0x5974,0x684c,0x6cea,0x99c4,0x5c48,0x61c2,0xc7c1,0x25a1,0x5e1d,0x6c64,0xc5bc,0x614e,0x6ed1,0x5750,0x9677,0x50be,0x5fd9,0x6062,0xe13,0x54b2,0x6753,0x6c60,0xbc97,0x50da,0x5fb9,0x92ed,0xb4e3,0x397,0x7363,0xcd2c,0x70e7,0x80c6,0xbba4,0x3043,0x771e,0x7bc4,0x8cab,0xff48,0x5956,0x5c90,0x67d0,0x9655,0xca,0x6367,0xafbc,0xc2b9,0xc625,0xd68d,0x68a6,0x935b,0xc871,0x3047,0x4e43,0x5b69,0x5b83,0x6284,0x8cd1,0x8d37,0x949f,0xc0ad,0x63e1,0x8f83,0x77ac,0x8475,0x8f9e,0x9418,0x94fe,0xd611,0x4e4f,0x4e9c,0x809d,0x9162,0x689d,0x6b8a,0xb4a4,0x930,0x50f9,0x53c3,0x56e2,0x6fc1,0x9e93,0x5c0a,0x5cef,0x609f,0x6c57,0xc57d,0xd300,0x4f75,0x81,0x4e22,0x59da,0x6ec5,0x96f2,0x9ed9,0x58a8,0x6000,0x756b,0x7e26,0x84b8,0x85a6,0xaddc,0xb77d,0xd754,0x819c,0x88ad,0x94f6,0xb728,0x5fe0,0x6109,0x78e8,0x86db,0xd0dd,0x7532,0x9042,0x9644,0x5212,0x5a1c,0x5b78,0x15c,0x575b,0xb2f5,0xc5fc,0x10e6,0x5618,0x5c4f,0xff55,0x5174,0x533f,0x6021,0x8f7b,0xaca8,0x1c,0x9c,0x72ed,0x8058,0x82b3,0x8e0f,0x9738,0x5100,0x5320,0x54c0,0x60a3,0x7ef4,0x81fa,0x84ee,0x8c01,0xc7a1,0x4eae,0x5192,0x5f26,0x6b0a,0x6dcb,0x7d2b,0x8bad,0xb274,0x5be6,0x8303,0x9065,0xb118,0x40c,0x5b9c,0x675c,0x6b61,0x733f,0x78c1,0xcc29,0xd050,0x599e,0x8dfb,0xc9f8,0x55ab,0x68cb,0x76d6,0xb9bd,0xcda9,0x51b0,0x8b19,0x8c4c,0x8f2f,0x559d,0x596e,0x9271,0x9510,0xc7a0,0xd4e8,0x266f,0x6291,0x8a69,0x6094,0x7334,0x81fb,0xae34,0xc5b5,0xcd95,0x938,0x6606,0xb2c9,0x596a,0x75ab,0xbc0f,0x51e1,0x66dd,0x8ce2,0x9867,0xd07c,0x4e80,0x85fb,0x9992,0xc90c,0xcc45,0x5854,0x8bb2,0x53e2,0x57f7,0x6232,0x9884,0x990c,0x51dd,0x8a72,0xbf55,0x6355,0x6da8,0x906d,0xc228,0x4ea6,0x708e,0x7434,0x8718,0x6a6b,0xcca0,0x907,0x54cd,0x6b04,0x7dad,0x806f,0x81d3,0x95f2,0xb2dd,0x7099,0x8b90,0x987a,0xccab,0xd6a8,0x94b1,0x9957,0x5976,0x6daf,0x732a,0x7e4a,0xc798,0x76c8,0x7f85,0x8521,0x50e7,0x77e2,0x9262,0xc811,0xd614,0x91f,0x575a,0x5c3c,0x6f64,0x8e0a,0xc724,0x840c,0x8cbf,0x9646,0x88dd,0xbf40,0xc528,0xd5e4,0x5251,0x52d8,0x5be9,0x6230,0x6dfa,0x7855,0x96c7,0xd038,0x5f81,0x6f02,0x8266,0x9685,0x9f0e,0xbb35,0xff46,0xe28,0x5462,0x5b64,0x62b9,0xce78,0xd601,0xff72,0x51b2,0x54c8,0x5c3a,0x7e4b,0x975c,0xc61b,0x2c6,0x25bd,0x90ca,0x9e23,0xb05d,0xb304,0xb807,0xbc40,0x5047,0x5ec9,0x5f6c,0x6653,0x7be0,0x9810,0x5169,0x52a3,0x6731,0x90aa,0x986f,0xb4b7,0x20b4,0x5049,0x8d62,0x95fb,0xc751,0x5152,0x67d4,0x7d2f,0x80de,0x8d5b,0x9970,0x616e,0x6176,0x7977,0x89c4,0x5f02,0x6768,0x6cb8,0x9f20,0xff7b,0xc0f5,0x9f,0x915,0x5200,0x60e0,0x6ef4,0x7950,0x7eed,0x8b83,0x8bd7,0xace8,0xbe57,0x8017,0x4ff3,0x574a,0x7e3d,0x68b0,0x8107,0x91dd,0xc8e0,0xd150,0x5c3f,0x5e81,0x6458,0x6f01,0x6f5f,0x73af,0x845b,0x9192,0xce21,0x11b,0x59c9,0x5f0a,0x81b3,0x9047,0xc904,0xff71,0xff7a,0xcf,0x59dc,0x6f58,0x9eba,0xb9e1,0x25c4,0x5265,0x82bd,0x8dc3,0x9bad,0x514e,0x519b,0x5857,0x707c,0x82cf,0x886c,0x8f29,0x9905,0x24b6,0x4f0d,0x54a8,0x566c,0x5a46,0x6389,0x7ec3,0x854e,0x3013,0x6742,0x6d12,0x88c2,0xb298,0xd56d,0xd575,0x5984,0x5ec3,0xb420,0x6d69,0x6fb3,0x9879,0x4fc3,0x5524,0x5ac1,0xac08,0xd798,0x399,0x4ef0,0x5132,0x84cb,0xb7c9,0xc655,0xd2c0,0x552f,0xc30d,0x548f,0x598a,0x5e05,0x6960,0xcee8,0xd0c4,0x303,0x56da,0x5d07,0x613f,0x7687,0x7eaa,0x8b5a,0x4fa6,0x517b,0x6687,0x80ba,0xc2f6,0x5c0b,0x65e6,0x6817,0x7ee7,0x80c3,0xd639,0x4eee,0x5b59,0x6065,0x61a7,0x6469,0x64a4,0x6c37,0x6e0b,0x390,0x3049,0x55ce,0x6d59,0x88f8,0x99b4,0xc140,0xd53d,0xd63c,0x75af,0x8209,0x8c08,0x25b3,0x63ed,0x64c1,0x90d1,0x9f3b,0xc0e4,0xd154,0x589c,0x5e7d,0x60f9,0x6212,0x6234,0x66d9,0x6df5,0x731b,0xbab8,0x4f2f,0x4f51,0x5146,0x543b,0x6444,0x7e2b,0x7f18,0x8ddf,0x8fbb,0x508d,0x6607,0x7d46,0x8986,0xc695,0x4f3a,0x507d,0x73ea,0x901b,0x908a,0xb9bc,0x14d,0x16f,0x45b,0x60dc,0x66a2,0x8c28,0x8e48,0xc529,0xd3f0,0xff89,0x4e4e,0x4f19,0x5beb,0x65d7,0x7ec7,0x8a89,0xb958,0xcc3e,0x4f34,0x5bdb,0x63d2,0x6e15,0x6eb6,0x7bee,0x2248,0x6167,0x665a,0x8972,0xad34,0xbc94,0xc26c,0x4fd7,0x6a13,0x7cde,0x91c8,0x98fd,0xbc0d,0x2660,0x76fe,0x9986,0x9c7c,0x51b5,0x56f4,0x58c7,0x5c81,0x62b5,0x91dc,0xbe48,0x54b3,0x6020,0x4fa0,0x5e3d,0x68a8,0xb08c,0xc2ac,0xcc3d,0x4e34,0x6b3a,0x7c97,0x8170,0x8b00,0xbd99,0xc654,0x5448,0x611a,0xff61,0x4e1d,0x4e25,0x50b3,0x5bc2,0x8015,0xccd0,0x5a9b,0x6784,0x5b81,0x5d29,0x5e06,0x64d4,0x8c8c,0xb2f4,0xb86f,0xba87,0xd5c8,0xff8f,0xe1c,0x60a6,0x7075,0x7545,0x7e01,0x904d,0x9eb5,0xd2bc,0xfe80,0x5706,0x5c24,0x6842,0x6c47,0x6e67,0x72fc,0x7766,0x7a42,0x9aee,0xb0ac,0x53f9,0x543e,0x77b3,0x7e8c,0x8cb0,0x8d38,0x45c,0x5263,0x5939,0x5d50,0x7f72,0x8431,0x9234,0xb5a8,0xd64d,0x50bb,0x79ef,0x8ed2,0x90e1,0xff8c,0x6c1,0x62e5,0x64f4,0x7adf,0xacac,0x6a02,0x74f6,0x8bc6,0xbe60,0xff7d,0x64b2,0x6ecb,0x95a3,0xc6e8,0x4f1f,0x5642,0x586b,0x5983,0x7985,0x7db4,0x80dc,0x81e3,0x8a17,0x60ca,0x633f,0x7164,0x83b7,0x862d,0x8a87,0xbfd0,0x40e,0x591f,0x65ac,0x6c40,0x7a32,0x8650,0x989c,0x558b,0x5ac9,0x86c7,0xd314,0x58ee,0x5987,0x5de1,0x61a9,0x6328,0x64da,0x6562,0x867d,0xb5bb,0xb838,0x9be,0x200f,0x62f6,0x6b6f,0x6f84,0x721b,0x74dc,0x8d66,0x9676,0xff84,0x6b23,0x8c13,0x8d4e,0x9ebc,0xbab0,0xd070,0xd3e,0x59ac,0x5f52,0x67f3,0x6c70,0x7409,0x77db,0x7eb2,0x8d8b,0x2009,0x5cb3,0x706d,0x70b8,0x8997,0x9396,0xac16,0xff76,0xff7f,0xe36,0x5a2f,0x77ff,0x7b5b,0x9ea5,0xad74,0xadc0,0xb123,0xb835,0xff80,0x100,0x2dc,0x452,0x200c,0x5d8b,0x6876,0x8276,0x9640,0xcf64,0x546a,0x5f70,0x639f,0x64c7,0x6bc1,0x7070,0x84c9,0x88b4,0x94ed,0x961f,0x1e29,0x2591,0x51e4,0x542f,0x90ae,0xe18,0x6b77,0x7d10,0x8ca2,0x5b55,0x5bee,0x80af,0x92c7,0xcc30,0x2011,0x52de,0x5377,0x5410,0x68b6,0x6cbc,0x7984,0x7cf8,0x820d,0xc95,0x51cf,0x54e5,0x5c9b,0x5f39,0x6f54,0x72d0,0x72e9,0x7be9,0xc783,0xd6c8,0xacb,0x5805,0x6905,0x751c,0x7656,0x7dbe,0x8a3b,0xc81d,0xcabd,0xcd98,0xff77,0x5075,0x537b,0x60a0,0x7275,0x7dfb,0x88c4,0xb193,0xd478,0x5821,0x6349,0x65fa,0x6cf3,0x7cca,0x7e6b,0x96b7,0x978d,0x989d,0xb5a0,0x3a9,0x5440,0x68c4,0x74a7,0x76e1,0x7eaf,0x806a,0x8212,0xbbf9,0x45e,0x6068,0x67f1,0x6fe1,0x722c,0x7344,0x96b1,0x9706,0x9c24,0xb7a8,0xb86d,0xcc0d,0xd2f4,0xd305,0x45f,0xa95,0x4e9e,0x5442,0x820c,0x84bc,0x84c4,0x9592,0x9a0e,0x9a30,0xd02,0x4e30,0x53f6,0x5eca,0x65cb,0x6a58,0x7827,0x7a6b,0x93ae,0x983b,0xc5c7,0xd0ac,0x6de,0x2207,0x5617,0x5e4c,0x64f7,0xc989,0xe47,0x2266,0x55a9,0x63fa,0x6d82,0x827e,0x8363,0x838e,0x87a2,0x89ba,0x8b5c,0x9526,0x9636,0x9f50,0xce6d,0xd480,0xff3c,0xa88,0x5949,0x5faa,0x66ab,0x7891,0x7d62,0x8bfe,0x9ca8,0xb113,0xb465,0x134,0xca0,0x2103,0x2620,0x2727,0x5733,0x658c,0x7a00,0xbdd4,0xd32,0x5eb5,0x6089,0x62d3,0x635c,0x76bf,0x7c98,0x49a,0x61f7,0x64b0,0x7d6e,0x8a50,0xb0b8,0xbca4,0xc27d,0xc568,0xd61c,0xff59,0x49b,0xaae,0x5167,0x51ef,0x5de3,0x6803,0x6a0b,0x6bd5,0x6ce5,0x7f3a,0x905c,0x54ed,0x55e3,0x5674,0x5c4d,0x6f0f,0x6f20,0x9010,0x9274,0xace1,0xb7ab,0xd640,0x39e,0x61b,0x307a,0x51f9,0x5606,0x6258,0x676d,0x695a,0x6eff,0x71c8,0x865f,0x8865,0x9855,0xcce4,0x102c,0x30f1,0x694a,0x7e3e,0x80f6,0x8154,0xb7ad,0x2003,0x2267,0x3062,0x538c,0x6447,0x67ff,0x6ce1,0x75fa,0x7c9f,0x8328,0x8870,0x8cfd,0xb8f9,0xd2f1,0xff8a,0x561b,0x6734,0x6b86,0x7199,0x75e9,0x76c6,0x7a3c,0x7b87,0x7d27,0x8299,0x87f9,0x8912,0xb0d0,0xb150,0xc5bb,0xc775,0xd0c1,0xd600,0x83,0x10d0,0x5899,0x5954,0x5c6c,0x71d5,0x820a,0x94bb,0xacbc,0xb17c,0x125,0xd4d,0x30c2,0x4f24,0x541f,0x5988,0x5fc6,0x6893,0x6a3d,0x828b,0x9aea,0xb790,0xbd24,0x2461,0x52ff,0x7d55,0x86cb,0xb799,0xc190,0xc9dc,0x8f,0x152,0x51f0,0x570d,0x5751,0x7eff,0x8d35,0x91b8,0x9e4f,0xb110,0xb5a4,0xc13c,0xc6e0,0xd758,0xd2e,0xe24,0x2661,0x5565,0x5c09,0x6115,0x63b4,0x80a0,0x9022,0x459,0x45a,0xd2f,0x5566,0x59a5,0x6446,0x7425,0x7a31,0x8d26,0x1eaf,0x587e,0x5f77,0x6249,0x64e0,0x6865,0x6e9c,0x73c0,0x73c8,0x7de9,0x819a,0x8537,0x8ce3,0x9ac4,0xc0b6,0xc194,0xcc2c,0xff56,0x5edf,0x631f,0x6d1e,0x7e7c,0x7f36,0x902e,0x95ca,0xb07c,0xb367,0xb840,0x146,0x10d8,0x2764,0x8a93,0xc4f0,0xd3d0,0x408,0x6f4,0x10da,0x51cc,0x57a3,0x62ff,0x73b2,0x81b5,0x8e29,0x8fb0,0x92ad,0xc2b7,0xce60,0x5f04,0x632b,0x7840,0x7947,0x920d,0xac14,0x5eb8,0x6851,0x6a94,0x751a,0x8f44,0x91ca,0xae68,0xbc38,0xd134,0xd78c,0xcb,0x6302,0x7ecd,0x837c,0x8b49,0x8d50,0x8ef8,0xbe59,0xbe7c,0xc794,0xcc,0x327,0x540a,0x570f,0x59ae,0x5a04,0x6c50,0x6c6a,0x840d,0x8a6e,0x9760,0x9a19,0xbca8,0xc564,0x38f,0x30f2,0x4eff,0x6076,0x6f70,0x7b39,0x871c,0x8ba8,0xbd10,0xc554,0xd39c,0xff78,0x10d7,0x10e0,0x2642,0x50a8,0x53e9,0x5766,0x5920,0x5c51,0x72a0,0x773e,0x7ed8,0x7f50,0x8178,0x8cd3,0x901d,0x9061,0x955c,0xaef4,0xb0ae,0xc728,0xcea1,0x179,0x935,0x2162,0x4fc4,0x5242,0x5451,0x5723,0x6df3,0x8072,0x9521,0x9837,0xb904,0xbc24,0xc1fc,0x150,0xabe,0xd33,0x2460,0x4e58,0x4e61,0x5a3c,0x5efb,0x6eda,0x84a1,0x8dcc,0x96a8,0xad81,0xb864,0xd3fc,0x5219,0x53a8,0x5761,0x5893,0x5ef3,0x60e8,0x624e,0x6627,0x6d2a,0x7345,0x76d2,0x7eba,0x82d7,0x8fa8,0xb458,0xb9c1,0xba39,0xc6c5,0xc998,0xc9d3,0x6015,0x65ed,0x764c,0x79ae,0x7c60,0x8c9d,0x9285,0x96d5,0x9dfa,0xade0,0xaf3d,0xb6f0,0xff97,0xffe3,0x2229,0x642c,0x64e6,0x6a59,0x6d9b,0x78a7,0x7e1b,0x8b6c,0x8c9e,0x95f9,0x96d6,0x932,0x4e4c,0x5203,0x526a,0x5302,0x5962,0x5f7f,0x618e,0x643e,0x8338,0x885e,0x8d5a,0x95ea,0xb538,0xcf30,0xd3bc,0xff9a,0x5141,0x517d,0x659c,0x6670,0x7011,0x730e,0x7b28,0x8f69,0x9093,0x94c1,0x9673,0x9761,0xac90,0xb78d,0xca8,0xdd2,0x5634,0x70e6,0x7551,0x7ca7,0x7f1d,0x865a,0x8af7,
		0x96eb,0xb4dd,0xb529,0xb9f9,0xc6b1,0xf8ff,0x308,0x407,0x924,0x92d,0x6155,0x619a,0x660c,0x674f,0x6f94,0x73ba,0x7ed1,0x8292,0x8861,0x8d21,0x907c,0x98d8,0x9972,0xb4ef,0xc130,0xc314,0xc787,0xc8fd,0x52b1,0x5782,0x71df,0x742a,0x7432,0x7d18,0x8389,0x963b,0x9665,0x96dc,0x9896,0xb2d0,0xb7ed,0x10e3,0x279a,0x50c5,0x54c9,0x5e63,0x63aa,0x7235,0x786b,0x816b,0x85aa,0x8607,0x90c1,0xc635,0xc880,0xd3f4,0x203c,0x2462,0x51f8,0x5968,0x6e07,0x7272,0x789f,0x8105,0x85ab,0x86ee,0x8776,0x9326,0x987f,0x99d2,0xb3c8,0xb3fc,0xcf8c,0xd761,0x87,0xab8,0x10e5,0x4e8f,0x54aa,0x61c7,0x6b6a,0x717d,0x7336,0x7897,0x7a9f,0x7ca4,0x817e,0x8de8,0x8f89,0x9547,0x9583,0x961c,0x9635,0x9bdb,0xff5d,0x110,0x154,0x223c,0x5434,0x545f,0x559a,0x55aa,0x6325,0xb7b5,0xb8f8,0xbbff,0xc168,0xcc99,0xff6f,0xf7,0x1a1,0x3a7,0x9b2,0x2564,0x4f54,0x5413,0x558a,0x5a49,0x8702,0x895e,0x8cca,0x9813,0x9d5c,0x9e1f,0xb429,0xcf5c,0xd0d1,0xd610,0xff9b,0x13d,0xacd,0x57c3,0x5986,0x64a5,0x66d6,0x6866,0x722a,0x7a1a,0x814e,0x8a0a,0x8b33,0x8d75,0x919c,0xac11,0xbc45,0xd138,0x2566,0x53a6,0x59a8,0x6276,0x62dc,0x65fb,0x66c6,0x6cdb,0x7329,0x79e6,0x83b2,0x83cc,0x8d76,0x8f49,0x900d,0x91a4,0x94c3,0xb0c8,0xba40,0xc149,0xff83,0xccd,0x272a,0x5496,0x5504,0x5944,0x5a9a,0x5f03,0x6101,0x680b,0x7eb8,0xcb49,0xcde8,0xff7c,0x302,0xabf,0x545c,0x5835,0x5bf6,0x5e9f,0x6182,0x6270,0x7015,0x7433,0x7a83,0x7c9b,0x807d,0x8096,0x8511,0x85dd,0x96f6,0x9776,0xb04c,0xba5c,0xcf1c,0xff5b,0xff8e,0x949,0x1ea3,0x51b4,0x52ab,0x55b0,0x5bab,0x6293,0x7261,0x773a,0x7aae,0x7b94,0x8358,0x83f1,0x8d3e,0x9634,0xada4,0xbc16,0xc2a8,0xc6f9,0xd280,0x1b0,0x304,0x5b4,0x920,0xcbf,0xe0b,0x1019,0x2463,0x279c,0x5815,0x5958,0x5bc5,0x60da,0x6492,0x69ae,0x6b72,0x6d89,0x6fe4,0x7262,0x7729,0x7949,0x7c3f,0x7d79,0x821f,0x8230,0x8304,0x88fe,0x8cb6,0x8d1d,0x95c6,0xad73,0xb180,0xb364,0xb4c0,0xc824,0xd380,0xff98,0x88,0xaa8,0xc41,0xc9f,0xcaf,0xf0b,0x1d52,0x5269,0x5937,0x62d8,0x71d2,0x7832,0x809a,0x8d95,0x97e7,0x9812,0xae0d,0xc12d,0xd004,0xd29c,0xff99,0xcb0,0x2047,0x4f10,0x51af,0x6263,0x6681,0x6db5,0x71ed,0x723a,0x72d2,0x7e6a,0x8166,0x8339,0x8d74,0x8f14,0x8ff9,0x97ad,0x9f84,0xb00c,0xb454,0xb4ed,0xb960,0xbaac,0xc2f8,0xd17,0x202f,0x21b5,0x507f,0x5197,0x532f,0x57d4,0x67ef,0x6dd8,0x6ee8,0x70ef,0x7463,0x7a33,0x7fe0,0x80ce,0x810a,0x895f,0x8f15,0x8fbf,0x91e7,0x96c0,0xafc8,0xc9d0,0xff93,0x8c,0xc6,0x2bc,0x1ecb,0x1ed3,0x5077,0x51a8,0x5415,0x60ef,0x622a,0x633a,0x6dc0,0x6fe0,0x710a,0x758e,0x8036,0x8061,0x8113,0x817a,0x81bd,0x857e,0x8bef,0x9488,0x95ed,0x9727,0x9eb9,0xc52c,0xd1b0,0xd1f4,0xff3f,0x263c,0x574f,0x5ff1,0x621a,0x6442,0x75f4,0x7960,0x7d21,0x8afa,0x8e2a,0xac24,0xb8b0,0xb8fd,0xc15c,0x937,0xc9c,0xdc4,0x2513,0x4eea,0x52c3,0x55da,0x5824,0x5a1b,0x6267,0x65c1,0x6795,0x70ae,0x739b,0x75b1,0x7f06,0x8151,0x8247,0x82fa,0x874b,0x8bf1,0x916c,0x92ea,0x9501,0xb9db,0xd0d5,0xd540,0xd56b,0xa9f,0xcb5,0xcbe,0x3045,0x309b,0x4e27,0x4f7c,0x519c,0x536f,0x53d4,0x5b9b,0x635f,0x67af,0x7063,0x7def,0x7e55,0x80f4,0x83e0,0x8a1f,0x8d60,0x8f88,0x9c2f,0xb0e5,0xd750,0xff64,0x543c,0x5507,0x5631,0x5e18,0x61f2,0x6775,0x68af,0x7325,0x7b48,0x7cb5,0x82b7,0x9077,0x9080,0x9132,0x9190,0x9b31,0xb0bc,0xb35c,0xb7b4,0xb801,0xb9e5,0xba4d,0xcc54,0xcf04,0xd0f1,0xd5ec,0x19,0x129,0x221a,0x3003,0x4fa7,0x51a5,0x67dc,0x70c2,0x7791,0x7e82,0x8327,0x884d,0x8b39,0x8fbd,0xb2e5,0xb2ee,0xb8f0,0xc5c9,0xc88c,0xf020,0xe2f,0x2025,0x52f2,0x555f,0x5589,0x5718,0x5806,0x59d1,0x5a05,0x5c1d,0x5fcc,0x6241,0x62d9,0x67aa,0x6adb,0x7adc,0x7b20,0x7eb5,0x803d,0x80a2,0x812b,0x8463,0x846c,0x8823,0x8c31,0x9057,0xae4a,0xc598,0xccbc,0xd508,0xd5cc,0xff81,0xff92,0x22c5,0x4f88,0x51c9,0x5384,0x5395,0x53e1,0x594b,0x614c,0x6190,0x65a4,0x6668,0x6808,0x70bc,0x72b9,0x73ca,0x7504,0x956d,0x9784,0x9913,0xb084,0xb518,0xba58,0xbe4c,0xc555,0xd31d,0xd3ad,0xd578,0xff82,0x429,0x982,0x9ac,0x5118,0x5239,0x52d2,0x53d9,0x5561,0x57ab,0x5b5c,0x66f9,0x7538,0x76f2,0x7fe1,0x8083,0x8fc8,0x9059,0x94a9,0xb0af,0xb20c,0xbcbd,0x8d,0x6d2,0x1ea1,0x2666,0x30f5,0x339e,0x572d,0x60df,0x6170,0x6846,0x7058,0x800d,0x83ab,0x90af,0x918d,0x99a5,0x9c9c,0xadc4,0xb0c9,0xb2d8,0xc14b,0xcda4,0xff73,0x92f,0x220e,0x2252,0x5398,0x5f6b,0x6652,0x66a6,0x6bbc,0x6e20,0x7169,0x775b,0x7fc1,0x8ecc,0x9699,0x96aa,0xb054,0xb2d9,0xb744,0xba4b,0xbe68,0xc78a,0xc9e4,0xd2,0x30c,0x6aa,0x941,0x565b,0x5dfe,0x6323,0x633d,0x660f,0x6c89,0x6cab,0x6f6d,0x731c,0x74e6,0x788e,0x7dde,0x82a5,0x837b,0x906e,0x9601,0xb099,0xb819,0xc559,0xc62e,0xc735,0xd648,0xff7e,0x98,0x94b,0xd3f,0x1fdf,0x56c1,0x59be,0x5f17,0x5ffd,0x6148,0x62c6,0x62e8,0x64bc,0x6643,0x6e1a,0x6edd,0x7237,0x7460,0x7cad,0x7ed5,0x7fa1,0x8106,0x81c9,0x82a6,0x82d1,0x83e9,0x8513,0x8bc8,0x8c26,0x8d14,0x8d2e,0x93c8,0x996e,0x9b06,0xaf2d,0xc1c4,0xc651,0xc92c,0xcca8,0xcfe1,0xff,0x14c,0x305,0x352,0x396,0x5016,0x55dd,0x57b0,0x5bb5,0x5be8,0x5cac,0x64ce,0x6897,0x698e,0x6f80,0x70e4,0x7560,0x77ee,0x79c9,0x7c95,0x7f70,0x8000,0x81c2,0x82db,0x8888,0x88d4,0x8987,0x8f68,0x9306,0x966a,0xacfd,0xad49,0xbb44,0xbf51,0xc058,0xc300,0x342,0x4d1,0xd30,0xf72,0x4e11,0x51c0,0x53f1,0x54ac,0x54bd,0x5875,0x58fd,0x5b6b,0x5ce0,0x5ef7,0x620e,0x658b,0x685d,0x6b96,0x6beb,0x714c,0x7682,0x7709,0x77ef,0x7cc0,0x7fc5,0x81a9,0x826e,0x840e,0x919b,0x99d5,0xe0e,0xe1f,0xf7c,0x1014,0x2161,0x51db,0x51fd,0x58d3,0x7009,0x7089,0x7405,0x7573,0x7881,0x7889,0x7a77,0x7aff,0x7f69,0x80d6,0x82d4,0x8387,0x84ec,0x8783,0x88df,0x8b80,0x8d0f,0x91ac,0x9322,0x94dc,0x96d9,0x9a57,0x9c88,0xb048,0xbe10,0xc500,0x1d,0x42a,0x490,0xdb1,0x2580,0x50b2,0x5154,0x5385,0x5495,0x5a7f,0x5bec,0x6070,0x62ed,0x6746,0x6881,0x68d5,0x6988,0x6ac3,0x6f47,0x70df,0x74ca,0x7750,0x77ad,0x7978,0x7b4d,0x7cb9,0x7de3,0x7ef3,0x7f62,0x86d9,0x8f9f,0x95f5,0x9c81,0xb04a,0xb7f4,0xcc0c,0xd0a8,0x169,0x2501,0x2765,0x314b,0x54af,0x5614,0x573e,0x5c53,0x5e9e,0x5f61,0x62d4,0x69cd,0x6e85,0x72c4,0x7da0,0x7ed2,0x8367,0x8590,0x8774,0x886b,0x8bf8,0x98d9,0xaf43,0xb8ec,0xbc25,0xc887,0xcd0c,0xce35,0xcea3,0xd1b1,0xfe41,0x11e,0x6ba,0xd2c,0x103a,0x4f47,0x4f69,0x50a3,0x55b7,0x5783,0x5c18,0x5d5c,0x6168,0x62a2,0x6f5b,0x734e,0x7422,0x788d,0x7dbb,0x7eb9,0x82f9,0x8a62,0x8fb1,0x9075,0x9600,0xaf80,0xc5e0,0xd034,0xd1a1,0xd551,0xd6e8,0xff6c,0xdb,0x314,0xd1c,0x4f8d,0x5bde,0x602f,0x607c,0x61a4,0x61be,0x62d6,0x654c,0x6590,0x6e10,0x6f06,0x7115,0x71d0,0x7577,0x79e9,0x7cdf,0x7f29,0x804b,0x8361,0x8471,0x848b,0x85cd,0x8680,0x8a85,0x8ce0,0x996d,0x9a97,0x9b41,0x9b8e,0xb0a9,0xb9f5,0xc878,0xc9dd,0xce7c,0xce84,0xff75,0x2e2,0x32f,0x351,0x35a,0x9b8,0xf56,0x103c,0x1ead,0x255a,0x5026,0x51a4,0x52c5,0x599d,0x5b8b,0x5c2c,0x5c34,0x5dcc,0x5e87,0x622e,0x6269,0x62a4,0x634f,0x6357,0x6b47,0x707e,0x7149,0x79a6,0x7aa6,0x7d0b,0x7e23,0x818f,0x836b,0x852d,0x88e4,0x8f5f,0x8fe6,0x903c,0x90bb,0x914c,0x91cb,0x93d1,0x9709,0x9918,0x9df2,0xb0ab,0xb155,0xb7ac,0xbb18,0xbb54,0xc12c,0xc219,0xc22b,0xc4f4,0xc549,0xcdb0,0x16e,0xd15,0xd26,0x1d49,0x2299,0x4e98,0x54c4,0x55bb,0x57b8,0x5ae9,0x5c60,0x5e9a,0x5f29,0x6028,0x6251,0x62d0,0x6372,0x647a,0x6666,0x6688,0x68c9,0x72c0,0x78b1,0x7d72,0x830e,0x8aed,0x8afe,0x8fa3,0x900a,0x9614,0x9881,0x9a91,0x9acc,0x9c39,0xbe5b,0xc9e7,0xceec,0xd0a5,0xd0d0,0xff88,0x13c,0x30f,0x36d,0xc17,0xd38,0xf61,0x266c,0x4ea9,0x4ff5,0x5446,0x54a3,0x5509,0x5f08,0x6524,0x6953,0x6bc0,0x731f,0x7aba,0x7ea4,0x7f13,0x7f79,0x7ff0,0x8070,0x8188,0x85e9,0x896f,0x8b10,0x8cf4,0x9189,0x94a7,0xb179,0xb2f7,0xbabd,0xc1e0,0xc5b9,0xc950,0x178,0x318,0x332,0xc32,0xd28,0xd4b,0xf51,0x2169,0x255d,0x4ecd,0x530d,0x5362,0x53bf,0x5582,0x55c5,0x59ec,0x5a20,0x5e1c,0x66f0,0x69a8,0x6c9f,0x6cfc,0x6e1d,0x7562,0x78b3,0x7be4,0x7ee9,0x7eea,0x8651,0x8813,0x8ced,0x8d3a,0x97fb,0x9a82,0xb8e1,0xb8e9,0xbc34,0xd6cc,0xd718,0x31a,0x101e,0x1d4d,0x2005,0x4f3d,0x55e8,0x567a,0x56e7,0x57a2,0x5bb0,0x5c27,0x61b2,0x65a5,0x668c,0x68ef,0x6977,0x6deb,0x80a4,0x8278,0x82de,0x8a60,0x8bde,0x9e21,0xae54,0xae5d,0xbb36,0xc3e0,0xc820,0xcc2e,0xcf08,0xd018,0xd0d3,0xd2c8,0xff03,0xff69,0xff94,0x9e,0x158,0x356,0xf42,0x1038,0x535c,0x53c9,0x54fc,0x5760,0x5bd3,0x5d74,0x5eb6,0x601c,0x60e7,0x615f,0x62ee,0x6321,0x66c7,0x68df,0x6912,0x6f15,0x73bb,0x755c,0x7a4f,0x7dcb,0x7ff3,0x82df,0x8749,0x8a03,0x8e87,0x987d,0x9a84,0xace7,0xb369,0xb73b,0xb9d1,0xbc0c,0xbe45,0xd15d,0xd31f,0xd514,0xff5a,0xff8d,0x137,0x162,0x30b,0x368,0x489,0xc24,0xc46,0x1d57,0x25a3,0x3231,0x4ec7,0x4f83,0x4ff1,0x5310,0x5321,0x537f,0x540f,0x5538,0x576a,0x5ab3,0x6124,0x629b,0x631a,0x66fc,0x6762,0x6adf,0x6b78,0x6bef,0x6c55,0x6f38,0x7529,0x7554,0x7587,0x7b79,0x80da,0x8be0,0x8c79,0x8d56,0x8e44,0x94c5,0x97f5,0x9e45,0x9e78,0xad1c,0xaf08,0xb2a6,0xb96d,0xc154,0xc789,0xc83c,0xca4c,0xce69,0xd188,0xff74,0xfffc,0x86,0x2d0,0x2e1,0x336,0x36a,0x710,0x7a8,0xd24,0xd35,0x1018,0x1d47,0x2044,0x5072,0x50ad,0x5270,0x54b1,0x5506,0x5564,0x5586,0x55a7,0x5c91,0x5c9a,0x646f,0x6631,0x664b,0x66fd,0x67da,0x681e,0x6a61,0x6bb4,0x6bc5,0x6c1b,0x6c4e,0x6c81,0x6cc4,0x72f1,0x745f,0x7ce7,0x81fc,0x853d,0x859b,0x8a63,0x8e8a,0x92f3,0x950b,0x96bc,0x96ef,0x97ee,0x9ce9,0xb800,0xbed7,0xc0f7,0xc2ed,0xc881,0xc8c4,0xcbe4,0xcf69,0xcfe8,0xd3a0,0xfe,0x164,0x1e3,0x252,0x2da,0x337,0x6d5,0x788,0x906,0x90f,0x917,0xd36,0x10d4,0x10dd,0x1a18,0x1e47,0x1eb5,0x226e,0x24e2,0x2584,0x262e,0x2669,0x30c5,0x4f30,0x4faf,0x52f8,0x5480,0x55b1,0x5925,0x5a25,0x5ec2,0x6346,0x64ab,0x655e,0x65cc,0x67ca,0x689f,0x6962,0x6984,0x6b50,0x6ba4,0x6d01,0x6eaa,0x76c3,0x7a63,0x7f77,0x803b,0x8098,0x8205,0x8403,0x8494,0x86cd,0x887f,0x8beb,0x8c6b,0x8f1b,0x947c,0x9756,0x99ed,0x9cf3,0x9d95,0xac9f,0xad04,0xaebe,0xaecf,0xb0b3,0xb1cc,0xb81b,0xb834,0xbd05,0xbed0,0xbf50,0xcc4c,0xd058,0xd234,0xd751,0x9a,0x12a,0x35b,0x363,0x679,0x9cb,0x10d5,0x12a0,0x226f,0x2464,0x51ea,0x5632,0x563b,0x5687,0x598d,0x5bbe,0x5df7,0x5f5d,0x5fa8,0x6064,0x622f,0x64ac,0x64c5,0x64e7,0x6e34,0x6eab,0x6fa1,0x715c,0x727d,0x7483,0x7898,0x7ebd,0x817f,0x87c4,0x8877,0x8a07,0x8d2f,0x9012,0x9081,0x9089,0x947d,0x984e,0x9870,0x991a,0x99ff,0x9ebf,0x9f61,0xb3cb,0xb4ec,0xb989,0xba67,0xbc43,0xc5fd,0xd3ab,0xfc61,0x1d4,0x218,0x22a,0x254,0x298,0x306,0x328,0x364,0x92b,0xd85,0xdaf,0xdc0,0xe0d,0x102d,0x1a01,0x1e63,0x2465,0x309e,0x4e5e,0x4f2a,0x4f43,0x503a,0x51d1,0x528d,0x53e0,0x56ee,0x5bd0,0x5d2d,0x5d57,0x61d2,0x64fa,0x687f,0x6de8,0x6e13,0x745a,0x78d4,0x7b06,0x7c6c,0x8317,0x8331,0x8427,0x849f,0x84d1,0x8559,0x85ea,0x8d9f,0x8e59,0x91ab,0x9530,0x9a5f,0x9baa,0xacb9,0xace4,0xb355,0xb380,
		0xb784,0xbc11,0xbe75,0xc65c,0xc77d,0xc78e,0xc7a6,0xcea0,0xd3b4,0xfc62,0xff67,0x2bb,0x33b,0x343,0x35d,0x365,0x6c7,0x6e9,0x71d,0x9bc,0x9cd,0xdb8,0xe4a,0x121b,0x129b,0x17b6,0x1ea7,0x1edb,0x2312,0x2466,0x318d,0x4ea2,0x5351,0x54d7,0x553e,0x56a2,0x56bc,0x59ca,0x5c62,0x5d14,0x67a2,0x67ab,0x6c1f,0x6dc7,0x6e83,0x7119,0x745b,0x75ae,0x75d8,0x7845,0x7919,0x7955,0x7aaa,0x7b5d,0x7f14,0x7f94,0x83b1,0x83b9,0x83ba,0x854a,0x85af,0x8c10,0x8cdc,0x8e74,0x9072,0x971e,0x9748,0x9bab,0x9f4a,0xacaa,0xb10c,0xbbac,0xbcbc,0xc12f,0xc3df,0xc5ff,0xc6dc,0xcff5,0xd790,0xfba7,0xff68,0xff79,0xff8b,0xff9c,0x14,0x124,0x28a,0x300,0x319,0x32b,0x6c8,0x902,0xdba,0x1004,0x102f,0x10e1,0x122d,0x1466,0x1a14,0x1eb1,0x2261,0x4fd5,0x4fde,0x4fef,0x5055,0x56b4,0x5a07,0x5c38,0x5e25,0x5e61,0x5ee0,0x60bc,0x6191,0x61ff,0x6636,0x6735,0x6900,0x69c3,0x69cc,0x6a44,0x6a80,0x6d85,0x6d8e,0x72ee,0x73c2,0x747e,0x75e2,0x76d0,0x7901,0x795f,0x7a92,0x7b19,0x7bdd,0x7cfe,0x7d06,0x7d17,0x7d3a,0x7eda,0x7fe9,0x80be,0x80fa,0x813e,0x8270,0x85c9,0x87f2,0x8b8a,0x8d29,0x8d4c,0x8d54,0x8d5d,0x8da8,0x8f85,0x96c9,0x9a7b,0x9aa4,0x9b4f,0x9bd6,0x9cc4,0xac81,0xae65,0xb258,0xb313,0xb371,0xb6b1,0xb764,0xb959,0xb9d8,0xba84,0xc0f4,0xc4f8,0xc96c,0xcc14,0xcf55,0xd0ed,0xd131,0x20b,0x309,0x30a,0x31b,0x345,0x947,0x9ad,0xdc3,0xe10,0x10d9,0x144e,0x14c4,0x1a15,0x2729,0x27a0,0x30fe,0x4e3f,0x4fce,0x4fdf,0x5023,0x51f6,0x5243,0x52fe,0x53db,0x5449,0x545b,0x54d1,0x563f,0x5ba0,0x5deb,0x5df3,0x5e15,0x5f7b,0x5fb5,0x60b4,0x6233,0x626f,0x634c,0x64d2,0x6538,0x65b7,0x6615,0x6824,0x699b,0x6cd3,0x6d53,0x758f,0x76fc,0x7825,0x78fa,0x7a46,0x7e31,0x7e8f,0x7f38,0x7ffc,0x80bf,0x819d,0x82c5,0x8309,0x84b2,0x84bb,0x865c,0x8a36,0x8b02,0x8d5e,0x8fc1,0x9508,0x95bb,0x985b,0x9b03,0x9b25,0x9be8,0x9ec3,0x9f90,0xac13,0xb729,0xb985,0xbfcc,0xc2fc,0xc571,0xcfc4,0xd47c,0xfffb,0x283,0x401,0x7a7,0x948,0x995,0x9bf,0xbbe,0x1a05,0x261b,0x2708,0x503e,0x5208,0x5428,0x5527,0x5ec8,0x5eda,0x5ee2,0x6014,0x618b,0x6289,0x63bb,0x6410,0x6454,0x6740,0x68fa,0x6ccc,0x722d,0x7378,0x757f,0x778e,0x7815,0x80c0,0x8173,0x8393,0x85a9,0x85e5,0x88d9,0x88f3,0x8904,0x8c1c,0x8c93,0x8d1b,0x8f90,0x8fc2,0x9017,0x9215,0x94f8,0x96cc,0xafd4,0xb2eb,0xb755,0xba64,0xca54,0xcad3,0xce94,0xcf13,0xd14d,0xfb01,0xfc5e,0xff85,0x347,0x790,0x9af,0xb95,0xd82,0xdac,0xdbd,0x1403,0x1450,0x1483,0x1a17,0x52b3,0x55fd,0x5641,0x568e,0x5e42,0x6084,0x60b6,0x60e9,0x60fb,0x6194,0x62ac,0x6491,0x66c9,0x6da1,0x6eba,0x6ee4,0x6f31,0x7027,0x70eb,0x712f,0x71fb,0x733e,0x737a,0x75a1,0x77b0,0x78da,0x79bf,0x7a84,0x7e4d,0x7eee,0x8086,0x8273,0x8482,0x8523,0x8c50,0x8e5f,0x8fe5,0x903b,0x9175,0x925b,0x94be,0x96de,0x98a0,0x9ab0,0x9df9,0xb044,0xb091,0xb154,0xb1a8,0xb374,0xb451,0xb72c,0xc232,0xc80a,0xd0b4,0xd321,0xfb02,0xfc5f,0xff6d,0x30d,0x31e,0x326,0x340,0x362,0x36b,0x780,0x7aa,0xa97,0xab0,0xac1,0xb38,0xbaf,0x1000,0x101a,0x1781,0x1fd6,0x2012,0x215e,0x2199,0x21bb,0x2265,0x24d1,0x2504,0x4e53,0x4f6c,0x4fda,0x5147,0x5323,0x5367,0x5378,0x53a2,0x5499,0x5587,0x55d3,0x56c9,0x56ca,0x5bf0,0x5d6f,0x5f6d,0x6063,0x62d7,0x6324,0x633e,0x63ac,0x6401,0x6478,0x6500,0x65a1,0x665d,0x67ec,0x6805,0x6816,0x69c7,0x6b1d,0x6bd7,0x6c13,0x6ca3,0x6e44,0x6ed4,0x6f32,0x6fb9,0x70c1,0x70db,0x7116,0x71fc,0x72e1,0x731d,0x737b,0x7435,0x748b,0x75bc,0x75d5,0x762b,0x777f,0x77a0,0x78ca,0x7aaf,0x7cd7,0x7d68,0x7d9c,0x7ef7,0x7f1a,0x7f9a,0x807f,0x8087,0x80e4,0x810f,0x82eb,0x841d,0x8700,0x8766,0x8854,0x8a6d,0x8d25,0x8f67,0x8f70,0x8f8a,0x949e,0x94a5,0x968b,0x96bd,0x9701,0x981a,0x9877,0x9921,0x9ad3,0x9aed,0x9bc9,0x9e3f,0xb0c4,0xb188,0xb2a0,0xb540,0xb69d,0xb82c,0xc068,0xc464,0xc574,0xc6e1,0xc70c,0xc7ad,0xcac4,0xcbd4,0xd399,0xf8eb,0xf9d0,0xff6e,0x25c,0x27e,0x30e,0x316,0x31f,0x330,0x349,0x36c,0x6ce,0x6f8,0x712,0x723,0x92a,0x943,0xa2a,0xb06,0xb4b,0xd37,0xf7a,0x1ea5,0x20a3,0x2211,0x222b,0x2329,0x24d2,0x261e,0x270c,0x3094,0x4e54,0x4ed3,0x50d1,0x5151,0x5195,0x543d,0x5478,0x5580,0x55d4,0x56e4,0x5d1b,0x5e99,0x5f10,0x61c8,0x6361,0x637b,0x65f7,0x6655,0x6930,0x69d9,0x6c61,0x6c72,0x6c83,0x6c8c,0x6cbe,0x6d9c,0x6e0a,0x6e23,0x6f33,0x6f4d,0x7076,0x707f,0x73ae,0x7436,0x754f,0x75a3,0x76ef,0x775e,0x77aa,0x78cb,0x7cae,0x7eac,0x7f45,0x8110,0x8198,0x81a0,0x8569,0x856a,0x86ce,0x870a,0x8734,0x874e,0x8778,0x8822,0x892a,0x8ab9,0x8b17,0x8bdb,0x8c41,0x8c6c,0x8d1e,0x8d6b,0x90a2,0x9119,0x9320,0x937e,0x9713,0x9a4d,0x9a6f,0x9a9a,0x9ba8,0x9cb8,0xac31,0xacc1,0xb2ff,0xb428,0xba78,0xbaab,0xc553,0xc597,0xce75,0xcf85,0xcffc,0xd2f8,0xff91,0x12,0xde,0x1ff,0x317,0x320,0x331,0x33a,0x34b,0x353,0x463,0x4b7,0x4d9,0x56b,0x672,0x6a4,0x6c6,0x78b,0x7ac,0xab2,0xb32,0xbcb,0xd16,0xea5,0x101c,0x12aa,0x1e5b,0x1ed9,0x1eeb,0x2160,0x21a3,0x2517,0x25b8,0x25ca,0x321c,0x4e19,0x4fa8,0x4ffe,0x542d,0x5435,0x54ce,0x54df,0x5556,0x5608,0x5a1f,0x5a74,0x5b8d,0x5cad,0x5ce8,0x6252,0x639e,0x6634,0x665f,0x68f5,0x6b05,0x6bd9,0x6c2f,0x6cfb,0x6e3e,0x701a,0x70c3,0x71f5,0x7239,0x72fd,0x73d1,0x7624,0x7792,0x79b1,0x7aed,0x7bb8,0x7c27,0x7f24,0x8180,0x81e5,0x8218,0x8881,0x8aee,0x8bf5,0x8c17,0x8d16,0x8f0c,0x8f61,0x9497,0x9505,0x96b6,0x9945,0x9ae6,0x9b4d,0x9c3b,0x9e9f,0xad75,0xb0ad,0xb531,0xb72f,0xb968,0xc0d0,0xc370,0xc378,0xc53b,0xc587,0xc606,0xc639,0xc653,0xc705,0xc796,0xca0c,0xcf20,0xd0b7,0xd5dd,0xd720,0x123,0x145,0x21a,0x2dd,0x307,0x321,0x329,0x32a,0x398,0x3cb,0x4a7,0x4e3,0xa2c,0xa70,0xb4d,0xb9a,0xbb2,0xf0d,0x102e,0x1036,0x1ec1,0x2202,0x2260,0x25e4,0x270e,0x4e56,0x5018,0x5021,0x502a,0x50f5,0x515c,0x527d,0x547b,0x54fa,0x55bd,0x5ae3,0x5b6c,0x5ba6,0x5ce1,0x5d69,0x5ed6,0x5f1b,0x60ee,0x63b7,0x64bf,0x64d8,0x6572,0x673d,0x6789,0x6e8c,0x6f13,0x7078,0x71ee,0x7526,0x7c7e,0x7d63,0x7e5a,0x7e8d,0x8109,0x8112,0x82bb,0x8343,0x8725,0x889c,0x8956,0x8a1b,0x8bff,0x8d31,0x8d4b,0x8fe9,0x90b5,0x9171,0x918b,0x970d,0x9773,0x9971,0x9b4e,0x9d3b,0x9e64,0x9edb,0xac1a,0xad90,0xae5c,0xb125,0xb381,0xb3d5,0xb480,0xb6f4,0xb738,0xc11e,0xc313,0xc580,0xc607,0xc698,0xc90d,0xc9c7,0xcd09,0xd0c9,0xd48b,0xd6a1,0x281,0x333,0x34d,0x355,0x35e,0x366,0x4ba,0x57e,0x784,0x78d,0x7ae,0x9df,0xa1c,0xa3e,0xa9c,0xca1,0xd21,0xea7,0xf41,0xf63,0x1235,0x179f,0x1eb9,0x2283,0x4e82,0x4edf,0x50e5,0x516e,0x51cb,0x51ed,0x5220,0x53fc,0x54a5,0x5594,0x55b5,0x5657,0x58cc,0x5c41,0x5c49,0x5cd9,0x5f0b,0x5f57,0x60d5,0x613c,0x62c2,0x6342,0x638f,0x6405,0x6452,0x6867,0x68cd,0x6955,0x6a2b,0x6abb,0x6da6,0x6dda,0x6e26,0x6ef2,0x70ac,0x70bd,0x7464,0x7574,0x760d,0x7ade,0x7b3c,0x7c43,0x7cdc,0x7eb7,0x7f9e,0x803f,0x80f1,0x82cd,0x8429,0x8490,0x856d,0x8993,0x8c19,0x8caa,0x8e39,0x8e42,0x94ee,0x95b1,0x96c1,0x96db,0x98ea,0x9f4b,0xac12,0xb18d,0xb86c,0xba48,0xbc0b,0xbe80,0xc0ec,0xc369,0xc501,0xc570,0xc6dd,0xc9d9,0xcad9,0xcef7,0xd230,0xd30d,0xd54f,0xfffa,0x13f,0x312,0x323,0x334,0x33d,0x367,0x4a1,0x7a6,0x936,0xaa4,0xab5,0xb2d,0xb3e,0x1797,0x17d2,0x1ffe,0x2215,0x2570,0x2611,0x26a1,0x276e,0x4ec6,0x4fa3,0x5188,0x5191,0x51bb,0x524c,0x527f,0x5364,0x557c,0x5636,0x5713,0x5955,0x59dd,0x5c39,0x5de2,0x5f14,0x60ac,0x60f0,0x61ab,0x6200,0x62cc,0x632a,0x640f,0x6417,0x64ec,0x64fd,0x698a,0x6bb2,0x6cf5,0x6da7,0x6db8,0x6e5b,0x6ee2,0x6f62,0x70f9,0x71ac,0x7490,0x75d2,0x7737,0x776b,0x7784,0x77e9,0x7ad6,0x7caa,0x7e6d,0x7edb,0x7ee3,0x8026,0x817b,0x81c6,0x8235,0x82ac,0x835f,0x8a1d,0x8a25,0x8bbd,0x8c0a,0x8c23,0x8d2b,0x8d3c,0x907d,0x92c6,0x9489,0x949b,0x96fe,0x9739,0x9838,0x98af,0x98da,0x98e2,0x9c57,0x9d09,0x9f7f,0xb141,0xb545,0xb5bc,0xb611,0xb98e,0xbafc,0xbf08,0xbfd4,0xc274,0xc37c,0xc384,0xc557,0xc6cd,0xccc7,0xcef8,0xcf67,0xcf70,0xf02d,0xfb44,0x8e,0x115,0x261,0x31c,0x32d,0x335,0x33e,0x54d,0x56f,0x6b1,0x6cb,0x6d3,0x720,0x786,0x7b0,0x9ae,0xa40,0xb3f,0xbb5,0xd23,0xeb2,0x1006,0x1017,0x10d2,0x10db,0x126b,0x1798,0x17c2,0x1ecd,0x1fe5,0x2117,0x25ac,0x2601,0x276f,0x3099,0x4e1e,0x4fad,0x5291,0x532a,0x53ed,0x54fd,0x562f,0x594e,0x5978,0x5ae6,0x5baa,0x5c7f,0x5f2f,0x5fd0,0x61ac,0x621b,0x6292,0x635e,0x63a9,0x63f6,0x642a,0x65a7,0x6715,0x68ad,0x68b5,0x68e0,0x6b67,0x6b89,0x6e17,0x7194,0x71d7,0x72f8,0x732c,0x73de,0x743c,0x75b9,0x75c2,0x787c,0x78e1,0x78f2,0x79be,0x7a14,0x7a9d,0x7afa,0x7bb4,0x7cd5,0x7d33,0x7eb1,0x7f75,0x82ad,0x831c,0x83c5,0x851a,0x8599,0x8654,0x8717,0x8852,0x8a6b,0x8c2d,0x8d0a,0x8d2c,0x8d81,0x8e99,0x90b8,0x9149,0x9163,0x9295,0x94f0,0x95ef,0x9611,0x9688,0x9798,0x97a0,0x9897,0x98f4,0x9952,0x9985,0x9b51,0x9e70,0x9e92,0xac94,0xb51c,0xb6ab,0xb810,0xc385,0xc583,0xc660,0xc6f0,0xd5d0,0xd6d7,0xe035,0xfbde,0xff96,0x6,0x325,0x32e,0x33f,0x358,0x38c,0x5bc,0x69a,0x718,0x721,0x729,0x72a,0x787,0x905,0x916,0x985,0x9c0,0xaaf,0xac0,0xb15,0xd2d,0xf55,0xf66,0x120e,0x12eb,0x179a,0x1ebd,0x2000,0x2008,0x2198,0x2228,0x263e,0x4e1f,0x4e52,0x4fae,0x4fb6,0x50b5,0x51bd,0x51d6,0x51e7,0x524e,0x5289,0x5319,0x53ee,0x5443,0x57ae,0x592d,0x5993,0x5b5f,0x5d4c,0x5dba,0x5f27,0x5fd1,0x606b,0x61fa,0x62df,0x63c4,0x652a,0x6727,0x67d1,0x67e2,0x693f,0x6b93,0x6bdf,0x6c9b,0x6cde,0x70af,0x70d9,0x72e0,0x72f9,0x7360,0x7368,0x74f7,0x766e,0x7690,0x76b1,0x76ba,0x7852,0x7940,0x7d0a,0x7f87,0x7fa8,0x814a,0x852c,0x863c,0x87ba,0x88f4,0x8ba5,0x8bb6,0x8e81,0x94b5,0x9890,0x9a6d,0x9a7e,0x9a8f,0x9aa7,0x9ab8,0x9ad2,0x9ae3,0x9af4,0x9c48,0x9ed6,0x9f2c,0xaf2c,0xaf34,0xb080,0xb220,0xb550,0xb69c,0xbc1f,0xd329
	}
);

size_t try_utf8_char_step(const unsigned char* buffer, size_t buffer_size, long offset);

int get_language_group(char16_t c);

extracted_string* try_extract_string(const unsigned char* buffer, size_t buffer_size, long offset, size_t min_chars);

std::tuple<string, string, std::pair<int, int>, bool> try_extract_string_tuple(const unsigned char* buffer, size_t buffer_size, long offset, size_t min_chars, bool only_interesting);

vector<std::tuple<string, string, std::pair<int, int>, bool>> extract_all_strings(const unsigned char buffer[], size_t buffer_size, size_t min_chars, bool only_interesting);
