# Generated by ariadne-codegen
# Source: https://api.binaryai.cn/v1/endpoint

from typing import List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import FileType, SearchBinaryStatisticKey, SymbolType


class BindiffMatchInput(BaseModel):
    sha_256: str = Field(alias="sha256")


class CreateFileInput(BaseModel):
    ticket_id: str = Field(alias="ticketID")


class CreateMatchInput(BaseModel):
    sha_256: str = Field(alias="sha256")
    target: "MatchTargetInput"


class CreateUploadTicketInput(BaseModel):
    sha_256: Optional[str] = Field(alias="sha256", default=None)
    md_5: Optional[str] = Field(alias="md5", default=None)
    name: Optional[str] = None
    captcha_ticket: Optional[str] = Field(alias="captchaTicket", default=None)
    captcha_random_string: Optional[str] = Field(
        alias="captchaRandomString", default=None
    )
    is_private_upload: Optional[bool] = Field(alias="isPrivateUpload", default=None)


class KHashInput(BaseModel):
    hash_hexlified_string: str = Field(alias="hashHexlifiedString")
    version: str
    bit_size: int = Field(alias="bitSize")


class MatchTargetInput(BaseModel):
    bindiff: Optional["BindiffMatchInput"] = None
    oss: Optional["OSSMatchInput"] = None


class OSSMatchInput(BaseModel):
    repo_ur_ls: Optional[List[str]] = Field(alias="repoURLs", default=None)


class ReanalyzeInput(BaseModel):
    sha_256: str = Field(alias="sha256")
    skip_version_check: Optional[bool] = Field(alias="skipVersionCheck", default=None)


class SearchBinaryInput(BaseModel):
    offset: Optional[int] = None
    limit: Optional[int] = None
    keyword: Optional[str] = None
    include_type: Optional[List[FileType]] = Field(alias="includeType", default=None)
    third_lib: Optional[List["SearchThirdLib"]] = Field(alias="thirdLib", default=None)
    statistic: Optional[List["SearchBinaryStatisticInput"]] = None


class SearchBinaryStatisticInput(BaseModel):
    keys: List[SearchBinaryStatisticKey]


class SearchCVESec(BaseModel):
    name: str


class SearchFileInput(BaseModel):
    sha_256: Optional[str] = Field(alias="sha256", default=None)
    md_5: Optional[str] = Field(alias="md5", default=None)


class SearchThirdLib(BaseModel):
    name: Optional[str] = None
    version: Optional[List[str]] = None
    cves: Optional[List["SearchCVESec"]] = None


class SessionLoginInput(BaseModel):
    previous_session_token: Optional[str] = Field(
        alias="previousSessionToken", default=None
    )
    weixin: Optional["WeixinSessionLoginInput"] = None


class SymbolTableFilter(BaseModel):
    symbol_type: Optional[List[SymbolType]] = Field(alias="symbolType", default=None)


class UpdateAccessKeyInput(BaseModel):
    enabled: Optional[bool] = None
    notes: Optional[str] = None


class WeixinSessionLoginInput(BaseModel):
    code: str
