import plotly.graph_objects as go
import plotly.io as pio
import matplotlib.colors
from fonts.ttf import Lato, LatoBold
from .utils import biolizard_qualitative_pal, biolizard_divergent_pal, l_viridis_pal, blz_blue, blz_green

lizard_style_template = go.layout.Template()
lizard_style_template.layout = {
#     'activeselection' : {},
    'annotationdefaults': {'arrowhead': 0, 'arrowwidth': 1},
#     'annotations' : {},
    'autotypenumbers': 'convert types',
    'barmode' : 'group',
    'boxmode' : 'group',
    'coloraxis': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
    'colorscale': {'diverging': [matplotlib.colors.rgb2hex(biolizard_divergent_pal(i)) for i in range(255)],               
                   'sequential': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
                   'sequentialminus': [matplotlib.colors.rgb2hex(l_viridis_pal.reversed()(i)) for i in range(255)]},
    'colorway': biolizard_qualitative_pal.colors,
    'font': {'family': Lato, 'size': 12},
    'geo': {'bgcolor': blz_blue,
            'oceancolor': blz_blue,
            'lakecolor': blz_blue,
            'landcolor': blz_green,
            'showlakes': True,
            'showland': True,
            'subunitcolor': 'white'},
    # 'hoverlabel': {'align': 'left'},
    'hovermode': 'closest',
    'mapbox': {'style': 'light'},
    'paper_bgcolor': 'white',
    'plot_bgcolor': 'white',
    # 'polar': {'angularaxis': {'gridcolor': 'rgb(232,232,232)',
    #                           'linecolor': '#808080',
    #                           'showgrid': False,
    #                           'showline': True,
    #                           'ticks': 'outside'},
    #           'bgcolor': 'white',
    #           'radialaxis': {'gridcolor': 'rgb(232,232,232)',
    #                          'linecolor': '#808080',
    #                          'showgrid': False,
    #                          'showline': True,
    #                          'ticks': 'outside'}},
    'scattermode': 'overlay',
    'scene': {'xaxis': {'backgroundcolor': 'white',
                        'gridcolor': 'rgb(232,232,232)',
                        'gridwidth': 2,
                        'color' : '#222222',
                        'linecolor': '#808080',
                        'spikecolor': '#808080',
                        'tickcolor': '#555555',
                        'showbackground': True,
                        'showgrid': False,
                        'showline': True,
                        'ticks': 'outside',
                        'zeroline': False,
                        'zerolinecolor': '#808080',
                        'exponentformat': 'power'},
              'yaxis': {'backgroundcolor': 'white',
                        'gridcolor': 'rgb(232,232,232)',
                        'gridwidth': 2,
                        'color' : '#222222',
                        'linecolor': '#808080',
                        'spikecolor': '#808080',
                        'tickcolor': '#555555',
                        'showbackground': True,
                        'showgrid': False,
                        'showline': True,
                        'ticks': 'outside',
                        'zeroline': False,
                        'zerolinecolor': '#808080',
                        'exponentformat': 'power'},
              'zaxis': {'backgroundcolor': 'white',
                        'gridcolor': 'rgb(232,232,232)',
                        'gridwidth': 2,
                        'color' : '#222222',
                        'linecolor': '#808080',
                        'spikecolor': '#808080',
                        'tickcolor': '#555555',
                        'showbackground': True,
                        'showgrid': False,
                        'showline': True,
                        'ticks': 'outside',
                        'zeroline': False,
                        'zerolinecolor': '#808080',
                        'exponentformat': 'power'}},
    'separators': '. ',
    'shapedefaults': {'fillcolor': blz_green, 'line': {'width': 0}, 'opacity': 1},
    'ternary': {'aaxis': {'gridcolor': 'rgb(232,232,232)',
                          'gridwidth': 2,
                          'color' : '#222222',
                          'linecolor': '#808080',
                          'tickcolor': '#555555',
                          'showgrid': False,
                          'showline': True,
                          'ticks': 'outside',
                          'exponentformat': 'power'},
                'baxis': {'gridcolor': 'rgb(232,232,232)',
                          'gridwidth': 2,
                          'color' : '#222222',
                          'linecolor': '#808080',
                          'tickcolor': '#555555',
                          'showgrid': False,
                          'showline': True,
                          'ticks': 'outside',
                          'exponentformat': 'power'},
                'bgcolor': 'white',
                'caxis': {'gridcolor': 'rgb(232,232,232)',
                          'gridwidth': 2,
                          'color' : '#222222',
                          'linecolor': '#808080',
                          'tickcolor': '#555555',
                          'showgrid': False,
                          'showline': True,
                          'ticks': 'outside',
                          'exponentformat': 'power'}},
    'title': {'x': 0.05, 'font': {'family': LatoBold, 'size': 16, 'color': '#222222'}},
    'violinmode' : 'group',
    'waterfallmode': 'group',
    'xaxis': {'automargin': True,
              'gridcolor': 'rgb(232,232,232)',
              'linecolor': '#808080',
              'spikecolor': '#808080',
              'dividercolor': '#808080',
              'tickcolor': '#555555',
              'showgrid': False,
              'showline': True,
              'ticks': 'outside',
              'title': {'standoff': 15, 'font': {'family': Lato, 'size': 14, 'color': '#222222'}},
              'zeroline': False,
              'zerolinecolor': '#808080',
              'exponentformat': 'power'},
    'yaxis': {'automargin': True,
              'gridcolor': 'rgb(232,232,232)',
              'linecolor': '#808080',
              'spikecolor': '#808080',
              'dividercolor': '#808080',
              'tickcolor': '#555555',
              'showgrid': False,
              'showline': True,
              'ticks': 'outside',
              'title': {'standoff': 15, 'font': {'family': Lato, 'size': 14, 'color': '#222222'}},
              'zeroline': False,
              'zerolinecolor': '#808080',
              'exponentformat': 'power'},
}

lizard_style_template.data = {
    'bar': [{'error_x': {'color': '#555555'},
             'error_y': {'color': '#555555'},
             'marker': {'line': {'color': 'white', 'width': 0.5},
                        'pattern': {'fillmode': 'overlay', 'size': 10, 'solidity': 0.2}},
             'type': 'bar'}],
    'barpolar': [{'marker': {'line': {'color': 'white', 'width': 0.5},
                             'pattern': {'fillmode': 'overlay', 'size': 10, 'solidity': 0.2}},
                  'type': 'barpolar'}],
    'carpet': [{'aaxis': {'endlinecolor': '#808080',
                          'gridcolor': blz_green,
                          'linecolor': blz_green,
                          'minorgridcolor': blz_green,
                          'startlinecolor': '#808080'},
                'baxis': {'endlinecolor': '#808080',
                          'gridcolor': blz_green,
                          'linecolor': blz_green,
                          'minorgridcolor': blz_green,
                          'startlinecolor': '#808080'},
                'type': 'carpet'}],
    'choropleth': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
                    'colorscale': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
                    'type': 'choropleth'}],
    'contour': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
                 'colorscale': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
                 'type': 'contour'}],
    'contourcarpet': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
                       'type': 'contourcarpet'}],
    'heatmap': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
                 'colorscale': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
                 'type': 'heatmap'}],
    # 'heatmapgl': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
    #                'colorscale': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
    #                'type': 'heatmapgl'}],
    'histogram': [{'marker': {'line': {'color': 'white', 'width': 0.6}}, 'type': 'histogram'}],
    'histogram2d': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
                     'colorscale': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
                     'type': 'histogram2d'}],
    'histogram2dcontour': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
                            'colorscale': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
                            'type': 'histogram2dcontour'}],
    'mesh3d': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}, 'type': 'mesh3d'}],
    'parcoords': [{'line': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                   'type': 'parcoords'}],
    'pie': [{'automargin': True, 'type': 'pie'}],
    'scatter': [{'fillpattern': {'fillmode': 'overlay', 'size': 10, 'solidity': 0.2}, 'type': 'scatter'}],
    'scatter3d': [{'line': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                   'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                   'type': 'scatter3d'}],
    'scattercarpet': [{'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                       'type': 'scattercarpet'}],
    'scattergeo': [{'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                    'type': 'scattergeo'}],
    'scattergl': [{'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                   'type': 'scattergl'}],
    'scattermapbox': [{'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                       'type': 'scattermapbox'}],
    'scatterpolar': [{'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                      'type': 'scatterpolar'}],
    'scatterpolargl': [{'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                        'type': 'scatterpolargl'}],
    'scatterternary': [{'marker': {'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'}},
                        'type': 'scatterternary'}],
    'surface': [{'colorbar': {'outlinewidth': 1, 'tickcolor': '#555555', 'ticks': 'outside', 'exponentformat': 'E'},
                 'colorscale': [matplotlib.colors.rgb2hex(l_viridis_pal(i)) for i in range(255)],
                 'type': 'surface'}],
    'table': [{'cells': {'fill': {'color': 'white'}, 'line': {'color': '#808080'}},
               'header': {'fill': {'color': blz_green}, 'line': {'color': '#808080'}},
               'type': 'table'}]
}

pio.templates["lizard_style"] = lizard_style_template