from typing import Any, AnyStr, BinaryIO, Hashable, Optional, Union

from bitarray import bitarray


def zeros(length: int, endian: Optional[str] = ...) -> bitarray: ...
def urandom(length: int, endian: Optional[str] = ...) -> bitarray: ...
def pprint(a: Any, stream: BinaryIO = ...,
           group: int = ...,
           indent: int = ...,
           width: int = ...) -> None: ...

def make_endian(a: bitarray, endian: str) -> bitarray: ...
def rindex(a: bitarray, Value: int) -> int: ...
def strip(a: bitarray, mode: str = ...) -> bitarray: ...

def count_n(a: bitarray, n: int, /) -> int: ...
def parity(a: bitarray, /) -> int: ...
def count_and(a: bitarray, b: bitarray, /) -> int: ...
def count_or(a: bitarray, b: bitarray, /) -> int: ...
def count_xor(a: bitarray, b: bitarray, /) -> int: ...
def subset(a: bitarray, b: bitarray, /) -> bool: ...

def ba2hex(a: bitarray, /) -> str: ...
def hex2ba(s: AnyStr, /,
           endian: Optional[str] = ...) -> bitarray: ...

def ba2base(n: int, a: bitarray, /) -> str: ...
def base2ba(n: int,
            s: AnyStr, /,
            endian: Optional[str] = ...) -> bitarray: ...

def ba2int(a: bitarray, signed: int = ...) -> int: ...
def int2ba(i: int, /,
           length: int = ...,
           endian: str = ...,
           signed: int = ...) -> bitarray: ...

def serialize(a: bitarray, /) -> bytes: ...
def deserialize(b: bytes, /) -> bitarray: ...
def huffman_code(freq_map: dict[Hashable, Union[int, float]],
                 endian: Optional[str] = ...
                 ) -> dict[Hashable, bitarray]: ...
